/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DecimalValue;
import com.cognos.xqe.data.values.ExactNumericValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueArithmeticException;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.util.MathUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.dom4j.Element;

public class IntegerValue
extends ExactNumericValue {
    static final long serialVersionUID = 7647274105530911872L;
    public static final IntegerValue NULL = DataValueFactory.createIntegerValue();
    public static final IntegerValue ZERO = DataValueFactory.createIntegerValue(0);
    public static final IntegerValue ONE = IntegerValue.createOne();
    public static final IntegerValue NEGATIVE_ONE = IntegerValue.createNegativeOne();
    private int value;

    IntegerValue(IntegerType aDataType) {
        super(aDataType);
    }

    @Override
    public void set(IValue v) {
        super.set(v);
        Value theValue = (Value)v;
        if (theValue != null && theValue.isOK()) {
            this.value = theValue.getInteger(this.dataType.getPrecision(), this.dataType.getScale());
        }
    }

    @Override
    public void set(String sValue) throws ValueConversionException {
        int a;
        if (sValue == null || sValue.compareTo("") == 0 || sValue.compareTo("null") == 0) {
            this.setNull();
            return;
        }
        try {
            a = Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)e, "string", sValue, "integer");
        }
        this.value = a;
        this.setNotNull();
    }

    @Override
    public void set(byte bValue) {
        this.value = bValue;
        this.setNotNull();
    }

    @Override
    public void set(short sValue) {
        this.value = sValue;
        this.setNotNull();
    }

    @Override
    public void set(int iValue) {
        this.value = iValue;
        this.setNotNull();
    }

    @Override
    public void set(long lValue) throws ValueConversionException {
        if (lValue > Integer.MAX_VALUE || lValue < Integer.MIN_VALUE) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "long", Long.toString(lValue), "integer");
        }
        this.value = (int)lValue;
        this.setNotNull();
    }

    @Override
    public void set(BigDecimal dValue) throws ValueConversionException {
        if (dValue == null) {
            this.setNull();
        } else {
            if (dValue.compareTo(DecimalValue.DEC2INT_UPPERBOUND) != -1 || dValue.compareTo(DecimalValue.DEC2INT_LOWERBOUND) != 1) {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "decimal", dValue.toString(), "integer");
            }
            BigDecimal bd = IntegerValue.cast(dValue, this.dataType.getPrecision(), this.dataType.getScale(), RoundingMode.DOWN);
            this.value = bd.unscaledValue().intValue();
            this.setNotNull();
        }
    }

    @Override
    public void set(float fValue) throws ValueConversionException {
        if (fValue >= 2.1474836E9f || fValue <= -2.1474836E9f) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "float", Float.toString(fValue), "integer");
        }
        int scale = this.dataType.getScale();
        this.value = scale != 0 ? (int)((double)fValue * MathUtil.pow10(scale)) : (int)fValue;
        this.setNotNull();
    }

    @Override
    public void set(double dValue) throws ValueConversionException {
        if (dValue >= 2.147483648E9 || dValue <= -2.147483649E9) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "double", Double.toString(dValue), "integer");
        }
        int scale = this.dataType.getScale();
        this.value = scale != 0 ? (int)(dValue * MathUtil.pow10(scale)) : (int)dValue;
        this.setNotNull();
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        int scale = this.dataType.getScale();
        String result = scale == 0 ? this.getUnscaledString() : (scale < 0 ? Long.toString((long)this.value * (long)MathUtil.pow10(-scale)) : Double.toString((double)this.value / MathUtil.pow10(scale)));
        return result;
    }

    @Override
    public short getShort(int precision, int scale) throws ValueConversionException {
        if (this.value > Short.MAX_VALUE || this.value < Short.MIN_VALUE) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "integer", Integer.toString(this.value), "smallint");
        }
        if (scale == this.dataType.getScale()) {
            return (short)this.value;
        }
        return (short)((double)this.value * MathUtil.pow10(scale - this.dataType.getScale()));
    }

    @Override
    public int getInteger(int precision, int scale) {
        if (scale == this.dataType.getScale()) {
            return this.value;
        }
        return (int)((double)this.value * MathUtil.pow10(scale - this.dataType.getScale()));
    }

    @Override
    public long getLong(int precision, int scale) {
        if (scale == this.dataType.getScale()) {
            return this.value;
        }
        return (long)((double)this.value * Math.pow(10.0, scale - this.dataType.getScale()));
    }

    @Override
    public BigDecimal getBigDecimal(int precision, int scale) {
        if (this.isNull()) {
            return null;
        }
        BigDecimal bd = BigDecimal.valueOf(this.value, this.getDataType().getScale());
        return IntegerValue.cast(bd, precision, scale);
    }

    @Override
    public float getFloat() {
        return (float)this.getDouble();
    }

    @Override
    public double getDouble() {
        int scale = this.dataType.getScale();
        if (scale == 0) {
            return this.value;
        }
        return (double)this.value / MathUtil.pow10(scale);
    }

    @Override
    public Object copy() {
        IntegerValue v = new IntegerValue((IntegerType)this.dataType);
        v.copyFrom(this);
        return v;
    }

    @Override
    public void add(IValue nValue) throws ValueArithmeticException {
        if (!this.validateStates(nValue)) {
            return;
        }
        long otherLong = ((Value)nValue).getLong(this.dataType.getPrecision(), this.dataType.getScale());
        long l = (long)this.value + otherLong;
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericOverflowError, Integer.toString(this.value), "+", Long.toString(otherLong), "integer");
        }
        this.value = (int)l;
    }

    @Override
    public void subtract(IValue nValue) throws ValueArithmeticException {
        if (!this.validateStates(nValue)) {
            return;
        }
        long longValue = ((Value)nValue).getInteger(this.dataType.getPrecision(), this.dataType.getScale());
        long l = (long)this.value - longValue;
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericUnderflowError, Integer.toString(this.value), "-", Long.toString(longValue), "integer");
        }
        this.value = (int)l;
    }

    @Override
    public void multiply(IValue nValue) throws ValueArithmeticException {
        if (!this.validateStates(nValue)) {
            return;
        }
        long longValue = ((Value)nValue).getInteger(this.dataType.getPrecision(), this.dataType.getScale());
        long l = (long)this.value * longValue;
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericUnderflowError, Integer.toString(this.value), "*", Long.toString(longValue), "integer");
        }
        this.value = (int)l;
    }

    @Override
    public void divide(IValue nValue) throws ValueArithmeticException {
        if (!this.validateStates(nValue)) {
            return;
        }
        long longValue = ((Value)nValue).getInteger(this.dataType.getPrecision(), this.dataType.getScale());
        long l = longValue;
        if (l == 0L) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_DivisionByZero);
        }
        if ((l = (long)this.value / l) > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericOverflowError, Integer.toString(this.value), "/", Long.toString(longValue), "integer");
        }
        this.value = (int)l;
    }

    @Override
    public void mod(IValue nValue) throws ValueArithmeticException {
        if (!this.validateStates(nValue)) {
            return;
        }
        long longValue = ((Value)nValue).getInteger(this.dataType.getPrecision(), this.dataType.getScale());
        long l = longValue;
        if (l == 0L) {
            return;
        }
        if ((l = (long)this.value % l) > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericOverflowError, Integer.toString(this.value), "%", Long.toString(longValue), "integer");
        }
        this.value = (int)l;
    }

    @Override
    public void abs() {
        if (this.isOK()) {
            this.value = StrictMath.abs(this.value);
        }
    }

    @Override
    public int sign() throws XQERuntimeException {
        if (this.isOK()) {
            if (this.value > 0) {
                return 1;
            }
            if (this.value < 0) {
                return -1;
            }
        }
        return 0;
    }

    @Override
    public int compareTo(Object pObject, NullBehavior nullHandling) {
        int integer;
        boolean nullLargerThanError;
        Value pValue = (Value)pObject;
        boolean thisIsNull = this.isNull();
        boolean thatIsNull = pValue.isNull();
        boolean thisIsError = !this.isOK() && !thisIsNull;
        boolean thatIsError = !pValue.isOK() && !thatIsNull;
        boolean bl = nullLargerThanError = NullBehavior.ZERO == nullHandling || NullBehavior.ZERO_STABLE_ELSE_FIRST == nullHandling || NullBehavior.ZERO_STABLE_ELSE_LAST == nullHandling || NullBehavior.ZERO_FIRST == nullHandling || NullBehavior.ZERO_LAST == nullHandling || NullBehavior.NULL_LAST == nullHandling;
        if (thisIsError && pValue.isOK()) {
            return -1;
        }
        if (this.isOK() && thatIsError) {
            return 1;
        }
        if (thisIsNull && thatIsError) {
            if (nullLargerThanError) {
                return 1;
            }
            return this.getState().compareTo(pValue.getState());
        }
        if (thisIsError && thatIsNull) {
            if (nullLargerThanError) {
                return -1;
            }
            return this.getState().compareTo(pValue.getState());
        }
        if (thisIsError && thatIsError) {
            return this.getState().compareTo(pValue.getState());
        }
        if (thisIsNull && thatIsNull) {
            return 0;
        }
        if (NullBehavior.ZERO_FIRST == nullHandling) {
            if (thisIsNull) {
                int compareValue = Double.compare(0.0, pValue.getDouble());
                if (compareValue == 0) {
                    return -1;
                }
                return compareValue;
            }
            if (thatIsNull) {
                int compareValue = Double.compare(this.value, 0.0);
                if (compareValue == 0) {
                    return 1;
                }
                return compareValue;
            }
        } else if (NullBehavior.ZERO_LAST == nullHandling) {
            if (thisIsNull) {
                int compareValue = Double.compare(0.0, pValue.getDouble());
                if (compareValue == 0) {
                    return 1;
                }
                return compareValue;
            }
            if (thatIsNull) {
                int compareValue = Double.compare(this.value, 0.0);
                if (compareValue == 0) {
                    return -1;
                }
                return compareValue;
            }
        } else if (NullBehavior.ZERO == nullHandling || NullBehavior.ZERO_STABLE_ELSE_FIRST == nullHandling || NullBehavior.ZERO_STABLE_ELSE_LAST == nullHandling) {
            if (thisIsNull) {
                return Double.compare(0.0, pValue.getDouble());
            }
            if (thatIsNull) {
                return Double.compare(this.value, 0.0);
            }
        } else if (NullBehavior.SQL == nullHandling || NullBehavior.NULL_FIRST == nullHandling) {
            if (!thisIsNull && thatIsNull) {
                return 1;
            }
            if (thisIsNull && !thatIsNull) {
                return -1;
            }
        } else if (NullBehavior.NULL_LAST == nullHandling) {
            if (!thisIsNull && thatIsNull) {
                return -1;
            }
            if (thisIsNull && !thatIsNull) {
                return 1;
            }
        }
        if (this.value == (integer = pValue.getInteger(this.dataType.getPrecision(), this.dataType.getScale()))) {
            return 0;
        }
        if (this.value > integer) {
            return 1;
        }
        return -1;
    }

    @Override
    public int compareTo(Object pObject) {
        return this.compareTo(pObject, NullBehavior.SQL);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        try {
            return this.compareTo(o) == 0;
        }
        catch (ClassCastException e) {
            return false;
        }
        catch (ValueConversionException ex) {
            return false;
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        if (!this.isOK()) {
            if (this.isNull()) {
                return NULL_STRING_HASH;
            }
            return this.getState().hashCode();
        }
        return Double.hashCode(this.value);
    }

    @Override
    public int fastHash() {
        if (!this.isOK()) {
            if (this.isNull()) {
                return NULL_STRING_HASH;
            }
            return this.getState().hashCode();
        }
        return this.value;
    }

    public BooleanValue sqlCompareTo(Object pObject) throws XQERuntimeException {
        IntegerValue a = (IntegerValue)pObject;
        if (!this.isOK() || !a.isOK()) {
            return BooleanValue.UNKNOWN;
        }
        if (this.value == a.getInteger(this.dataType.getPrecision(), this.dataType.getScale())) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    @Override
    public void trunc(int n) {
        if (!this.isOK()) {
            return;
        }
        if (n >= 0 || this.value == 0) {
            return;
        }
        n = -n;
        int shiftFactor = 10;
        for (int i = 1; i < n; ++i) {
            shiftFactor *= 10;
        }
        int mod = this.value % shiftFactor;
        this.value -= mod;
    }

    @Override
    public void round(int n) {
        if (!this.isOK()) {
            return;
        }
        int tmp = this.value;
        if (n >= 0 || tmp == 0) {
            return;
        }
        n = -n;
        int shiftFactor = 10;
        for (int i = 1; i < n; ++i) {
            shiftFactor *= 10;
        }
        int rounder = this.value > 0 ? 5 * (shiftFactor / 10) : -5 * (shiftFactor / 10);
        int mod = (tmp += rounder) % shiftFactor;
        this.value = tmp - mod;
    }

    @Override
    public void roundUp(int n) {
        if (!this.isOK()) {
            return;
        }
        int tmp = this.value;
        if (n >= 0 || tmp == 0) {
            return;
        }
        n = -n;
        int shiftFactor = 10;
        for (int i = 1; i < n; ++i) {
            shiftFactor *= 10;
        }
        int mod = tmp % shiftFactor;
        this.value = this.value > 0 ? tmp + shiftFactor : (tmp -= mod) - shiftFactor;
    }

    @Override
    public void roundDown(int n) {
        if (!this.isOK()) {
            return;
        }
        int tmp = this.value;
        if (n >= 0 || tmp == 0) {
            return;
        }
        n = -n;
        int shiftFactor = 10;
        for (int i = 1; i < n; ++i) {
            shiftFactor *= 10;
        }
        int mod = tmp % shiftFactor;
        this.value = tmp - mod;
    }

    @Override
    public String getUnscaledString() {
        return Integer.toString(this.value);
    }

    @Override
    public int sizeOf() {
        return ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.INTEGER);
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        if (this.isOK()) {
            this.set(iStream.readInt());
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        if (this.isOK()) {
            oStream.writeInt(this.value);
        }
    }

    public static int getEncodedSize() {
        return Value.getEncodedSize() + 4;
    }

    @Override
    public boolean isZero() {
        return this.isOK() && this.value == 0;
    }

    public static IntegerValue createOne() {
        return DataValueFactory.createIntegerValue(1);
    }

    public static IntegerValue createNegativeOne() {
        return DataValueFactory.createIntegerValue(-1);
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            result = this.value == ((IntegerValue)otherValue).value;
        }
        return result;
    }

    @Override
    public void persistData(XQEPersistContext ctx) {
        ctx.data(Integer.toString(this.value));
    }

    @Override
    public void restoreData(XQERestoreContext ctx, Element node) {
        String text = node.getText();
        if (text != null && !text.isEmpty()) {
            this.value = Integer.parseInt(text);
        }
    }

    @Override
    Number getScaledNumber() {
        if (this.getDataType().getScale() != 0) {
            return this.getBigDecimal();
        }
        return (Number)this.getObject();
    }

    @Override
    public Object toJSON() {
        return this.getScaledNumber();
    }
}

