/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.sql.SQLFunction;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DecimalType;
import com.cognos.xqe.data.types.IntervalQualifier;
import com.cognos.xqe.data.types.IntervalYearMonthType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DecimalValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.IntervalValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueArithmeticException;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.MathUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Period;
import java.time.format.DateTimeParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IntervalYearMonthValue
extends IntervalValue {
    static final long serialVersionUID = 1298622972537116649L;
    private static final int MONTHS_PER_YEAR = 12;
    private static final int MONTHS_PER_QUARTER = 3;
    public static final int MAX_MONTH_VALUE = 11;
    private static final String HYPHEN = "-";
    private static final int YEAR = 0;
    private static final int MONTH = 1;
    public static final Pattern PATTERN = Pattern.compile("(-|\\+)?([0-9]+|[0-9]+-[0-9]{1,2}+)");
    private static final String DURATION_INDICATOR = "P";
    private static final String YEAR_INDICATOR = "Y";
    private static final String MONTH_INDICATOR = "M";
    private static final byte MAX_ENCODED_SIZE = 6;

    IntervalYearMonthValue(IntervalYearMonthType aDataType) {
        super(aDataType, 2);
    }

    @Override
    public double extract(int field) {
        switch (field) {
            case 1: {
                return this.getYear();
            }
            case 2: {
                return this.getMonth();
            }
        }
        return 0.0;
    }

    public void set(boolean isNegative, int years, int months) {
        if (years < 0) {
            throw new IllegalArgumentException("years < 0");
        }
        if (months < 0) {
            throw new IllegalArgumentException("months < 0");
        }
        this.sign = isNegative ? -1 : 1;
        this.fields[0] = years;
        this.fields[1] = months;
        this.setNotNull();
    }

    @Override
    public void set(String sValue) throws ValueConversionException {
        if (sValue == null || sValue.compareTo("") == 0) {
            this.setNull();
            return;
        }
        Matcher m = PATTERN.matcher(sValue);
        if (m.matches()) {
            if (sValue.charAt(0) == '-') {
                this.sign = -1;
                sValue = sValue.substring(1);
            } else if (sValue.charAt(0) == '+') {
                this.sign = 1;
                sValue = sValue.substring(1);
            } else {
                this.sign = 1;
            }
            String[] list = sValue.split(HYPHEN);
            IntervalQualifier qualifier = this.getYearMonthType().getQualifier();
            if (list.length > 1 && qualifier != IntervalQualifier.INTERVAL_YEAR_TO_MONTH) {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", sValue, this.dataType.toString());
            }
            int value = Integer.parseInt(list[0]);
            switch (qualifier) {
                case INTERVAL_YEAR_TO_MONTH: {
                    if (list.length != 2) {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", sValue, this.dataType.toString());
                    }
                    this.fields[1] = Integer.parseInt(list[1]);
                    if (this.fields[1] > 11) {
                        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", sValue, this.dataType.toString());
                    }
                    this.fields[0] = value;
                    break;
                }
                case INTERVAL_YEAR: {
                    this.fields[0] = value;
                    break;
                }
                case INTERVAL_MONTH: {
                    this.fields[1] = value;
                    break;
                }
            }
            this.setNotNull();
        } else {
            this.setXSDLiteral(sValue);
        }
    }

    public void setXSDLiteral(String sValue) {
        if (sValue == null || sValue.compareTo("") == 0) {
            this.setNull();
            return;
        }
        try {
            Period period = Period.parse(sValue);
            this.fields[0] = Math.abs(period.getYears());
            this.fields[1] = Math.abs(period.getMonths());
            this.sign = period.isNegative() ? -1 : 1;
            this.setNotNull();
        }
        catch (DateTimeParseException e) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)e, "string", sValue, this.dataType.toString());
        }
    }

    @Override
    public void set(IValue v) {
        if (v == null || v.isNull()) {
            this.setNull();
            return;
        }
        if (v instanceof TextValue || v instanceof NumericValue) {
            this.set(((Value)v).getString());
        } else {
            IntervalYearMonthValue value = (IntervalYearMonthValue)v;
            this.sign = value.getSign();
            this.fields[0] = value.getYear();
            this.fields[1] = value.getMonth();
            this.normalizeValues();
        }
        this.copyFormatIdFrom(v);
        this.setNotNull();
    }

    @Override
    public void copyFrom(IValue iValue) {
        this.set(iValue);
        this.copyFormatIdFrom(iValue);
    }

    public int getYear() {
        return this.fields[0];
    }

    public int getMonth() {
        return this.fields[1];
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        String literal = null;
        StringBuilder b = new StringBuilder();
        if (this.sign < 0) {
            b.append(HYPHEN);
        }
        IntervalYearMonthType type = (IntervalYearMonthType)this.getDataType();
        switch (type.getQualifier()) {
            case INTERVAL_YEAR: {
                literal = Integer.toString(this.fields[0]);
                break;
            }
            case INTERVAL_MONTH: {
                literal = Integer.toString(this.fields[1]);
                break;
            }
            case INTERVAL_YEAR_TO_MONTH: {
                literal = String.format("%1$d-%2$02d", this.fields[0], this.fields[1]);
                break;
            }
            default: {
                literal = "";
            }
        }
        b.append(literal);
        return b.toString();
    }

    @Override
    public int getInteger(int precision, int scale) {
        int val = 0;
        IntervalYearMonthType type = (IntervalYearMonthType)this.getDataType();
        switch (type.getQualifier()) {
            case INTERVAL_YEAR: {
                val = this.fields[0];
                break;
            }
            case INTERVAL_MONTH: {
                val = this.fields[1];
                break;
            }
            default: {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "interval year to month", this.getString(), "integer");
            }
        }
        return (int)((double)(val *= this.sign) * MathUtil.pow10(scale));
    }

    @Override
    public BigDecimal getBigDecimal(int precision, int scale) {
        int val = 0;
        IntervalYearMonthType type = (IntervalYearMonthType)this.getDataType();
        switch (type.getQualifier()) {
            case INTERVAL_YEAR: {
                val = this.fields[0];
                break;
            }
            case INTERVAL_MONTH: {
                val = this.fields[1];
                break;
            }
            default: {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "interval year to month", this.getString(), "decimal");
            }
        }
        DecimalType decType = DataTypeFactory.getDecimalType(precision, scale);
        DecimalValue decValue = (DecimalValue)decType.createValue();
        decValue.set(val *= this.sign);
        return decValue.getBigDecimal();
    }

    private IntervalYearMonthType getYearMonthType() {
        return (IntervalYearMonthType)this.getDataType();
    }

    @Override
    public String getSQLLiteral() {
        String literal;
        IntervalYearMonthType type = (IntervalYearMonthType)this.getDataType();
        if (this.isNull()) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append("INTERVAL ");
        if (this.sign < 0) {
            b.append(HYPHEN);
        }
        String leadingPrecision = type.hasLeadingPrecision() ? Integer.toString(type.getLeadingPrecision()) : null;
        switch (type.getQualifier()) {
            case INTERVAL_YEAR: {
                literal = SQLFunction.format("'%1$d' YEAR@2[(%2$s)]", new Object[]{this.fields[0], leadingPrecision});
                break;
            }
            case INTERVAL_MONTH: {
                literal = SQLFunction.format("'%1$d' MONTH@2[(%2$s)]", new Object[]{this.fields[1], leadingPrecision});
                break;
            }
            case INTERVAL_YEAR_TO_MONTH: {
                literal = SQLFunction.format("'%1$d-%2$02d' YEAR@3[(%3$s)] TO MONTH", new Object[]{this.fields[0], this.fields[1], leadingPrecision});
                break;
            }
            default: {
                literal = "";
            }
        }
        b.append(literal);
        return b.toString();
    }

    @Override
    public String getXSDLiteral() {
        IntervalYearMonthType type = (IntervalYearMonthType)this.getDataType();
        if (this.isNull()) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        if (this.sign < 0) {
            b.append(HYPHEN);
        }
        b.append(DURATION_INDICATOR);
        switch (type.getQualifier()) {
            case INTERVAL_YEAR: {
                b.append(this.getYear()).append(YEAR_INDICATOR);
                break;
            }
            case INTERVAL_MONTH: {
                b.append(this.getMonth()).append(MONTH_INDICATOR);
                break;
            }
            case INTERVAL_YEAR_TO_MONTH: {
                b.append(this.getYear()).append(YEAR_INDICATOR);
                b.append(this.getMonth()).append(MONTH_INDICATOR);
                break;
            }
        }
        return b.toString();
    }

    @Override
    public String getFormattedLiteral(String formatSpec) {
        if (this.isNull()) {
            return null;
        }
        String literal = null;
        String signString = this.sign < 0 ? HYPHEN : "";
        IntervalYearMonthType type = (IntervalYearMonthType)this.getDataType();
        String precision = type.hasLeadingPrecision() ? Integer.toString(type.getLeadingPrecision()) : null;
        switch (type.getQualifier()) {
            case INTERVAL_YEAR: {
                literal = SQLFunction.format(formatSpec, new Object[]{this.fields[0], precision, signString});
                break;
            }
            case INTERVAL_MONTH: {
                literal = SQLFunction.format(formatSpec, new Object[]{this.fields[1], precision, signString});
                break;
            }
            case INTERVAL_YEAR_TO_MONTH: {
                literal = SQLFunction.format(formatSpec, new Object[]{this.fields[0], this.fields[1], precision, signString});
                break;
            }
            default: {
                literal = "";
            }
        }
        return literal;
    }

    @Override
    public int compareTo(Object object) {
        Value val = (Value)object;
        if (this.isNull() && val.isNull()) {
            return 0;
        }
        if (!this.isNull() && val.isNull()) {
            return 1;
        }
        if (this.isNull() && !val.isNull()) {
            return -1;
        }
        IntervalYearMonthValue a = (IntervalYearMonthValue)object;
        if (this.fields[0] + a.getYear() + this.fields[1] + a.getMonth() == 0) {
            return 0;
        }
        if (this.sign > 0 && a.getSign() < 0) {
            return 1;
        }
        if (this.sign < 0 && a.getSign() > 0) {
            return -1;
        }
        long thisValue = (long)this.fields[0] * 12L + (long)this.fields[1];
        long aValue = (long)a.getYear() * 12L + (long)a.getMonth();
        if (thisValue == aValue) {
            return 0;
        }
        if (thisValue > aValue) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    @Override
    public int hashCode() {
        int hashCode;
        int prime = 31;
        if (this.isNull()) {
            hashCode = Integer.MIN_VALUE;
        } else {
            hashCode = 1;
            hashCode = hashCode * 31 + this.fields[0];
            hashCode = hashCode * 31 + this.fields[1];
        }
        return hashCode;
    }

    public BooleanValue sqlCompareTo(Object object) {
        IntervalYearMonthValue a = (IntervalYearMonthValue)object;
        if (this.isNull() || a.isNull()) {
            return BooleanValue.UNKNOWN;
        }
        if (this.compareTo(a) == 0) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    @Override
    public void add(IValue value) {
        IntervalYearMonthValue ymValue = (IntervalYearMonthValue)value;
        int months = this.fields[0] * 12 + this.fields[1];
        int offsetMonths = ymValue.getYear() * 12 + ymValue.getMonth();
        int newMonths = this.sign * months + ymValue.getSign() * offsetMonths;
        int absNewMonths = StrictMath.abs(newMonths);
        this.fields[0] = absNewMonths / 12;
        this.fields[1] = absNewMonths % 12;
        this.sign = 1;
        if (newMonths < 0) {
            this.sign = -1;
        }
        this.normalizeValues();
    }

    public void addMonths(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.fields[1] = this.fields[1] + iValue;
        this.normalizeValues();
    }

    public void addQuarters(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.fields[1] = this.fields[1] + iValue * 3;
        this.normalizeValues();
    }

    public void addYears(int iValue) {
        if (this.isNull()) {
            return;
        }
        this.fields[0] = this.fields[0] + iValue;
        this.normalizeValues();
    }

    @Override
    public void subtract(IValue value) {
        IntervalYearMonthValue ymValue = (IntervalYearMonthValue)value;
        int months = this.fields[0] * 12 + this.fields[1];
        int offsetMonths = ymValue.getYear() * 12 + ymValue.getMonth();
        int newMonths = this.sign * months - ymValue.getSign() * offsetMonths;
        int absNewMonths = StrictMath.abs(newMonths);
        this.fields[0] = absNewMonths / 12;
        this.fields[1] = absNewMonths % 12;
        this.sign = 1;
        if (newMonths < 0) {
            this.sign = -1;
        }
        this.normalizeValues();
    }

    @Override
    public void multiply(IValue value) throws ValueArithmeticException {
        int x = ((Value)value).getInteger();
        if (x < 0) {
            this.sign *= -1;
            x = -x;
        }
        long result = (long)this.fields[0] * 12L + (long)this.fields[1];
        this.fields[1] = (int)((result *= (long)x) % 12L);
        if ((result /= 12L) > Integer.MAX_VALUE) {
            throw new ValueArithmeticException(XQEMessageKeys.DAT_NumericOverflowError, this.getString(), "*", Integer.toString(x), "integer");
        }
        this.fields[0] = (int)result;
        this.normalizeValues();
    }

    @Override
    public void divide(IValue value) {
        int x = ((Value)value).getInteger();
        if (x < 0) {
            this.sign *= -1;
            x = -x;
        }
        long result = (long)this.fields[0] * 12L + (long)this.fields[1];
        this.fields[1] = (int)((result /= (long)x) % 12L);
        this.fields[0] = (int)(result / 12L);
        this.normalizeValues();
    }

    private void normalizeValues() throws ValueConversionException {
        IntervalYearMonthType type = (IntervalYearMonthType)this.getDataType();
        switch (type.getQualifier()) {
            case INTERVAL_YEAR_TO_MONTH: {
                long result = (long)this.fields[0] * 12L + (long)this.fields[1];
                this.fields[1] = (int)(result % 12L);
                if ((result /= 12L) <= Integer.MAX_VALUE) {
                    this.fields[0] = (int)result;
                    break;
                }
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.toString(), this.getString(), this.dataType.toString());
            }
            case INTERVAL_YEAR: {
                long result = (long)this.fields[0] * 12L + (long)this.fields[1];
                if ((result /= 12L) > Integer.MAX_VALUE) {
                    throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.toString(), this.getString(), this.dataType.toString());
                }
                this.fields[0] = (int)result;
                this.fields[1] = 0;
                break;
            }
            case INTERVAL_MONTH: {
                long result = (long)this.fields[0] * 12L + (long)this.fields[1];
                if (result > Integer.MAX_VALUE) {
                    throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.toString(), this.getString(), this.dataType.toString());
                }
                this.fields[1] = (int)result;
                this.fields[0] = 0;
                break;
            }
        }
    }

    @Override
    public Object copy() {
        IntervalYearMonthValue v = new IntervalYearMonthValue((IntervalYearMonthType)this.dataType);
        v.set(this);
        return v;
    }

    @Override
    public String toString() {
        return this.getXSDLiteral();
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        if (this.isOK()) {
            IntervalQualifier qualifier = IntervalQualifier.get(iStream.readByte());
            switch (qualifier) {
                case INTERVAL_YEAR: {
                    this.fields[0] = iStream.readInt();
                    break;
                }
                case INTERVAL_MONTH: {
                    this.fields[1] = iStream.readInt();
                    break;
                }
                case INTERVAL_YEAR_TO_MONTH: {
                    this.fields[0] = iStream.readInt();
                    this.fields[1] = iStream.readByte();
                    break;
                }
            }
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        if (this.isOK()) {
            IntervalQualifier qualifier = ((IntervalYearMonthType)this.dataType).getQualifier();
            oStream.writeByte(qualifier.getOrdinal());
            switch (qualifier) {
                case INTERVAL_YEAR: {
                    oStream.writeInt(this.fields[0]);
                    break;
                }
                case INTERVAL_MONTH: {
                    oStream.writeInt(this.fields[1]);
                    break;
                }
                case INTERVAL_YEAR_TO_MONTH: {
                    oStream.writeInt(this.fields[0]);
                    oStream.writeByte(this.fields[1]);
                    break;
                }
            }
        }
    }

    public static int getEncodedSize() {
        return Value.getEncodedSize() + 6;
    }

    @Override
    public void negate() throws XQERuntimeException {
        this.multiply(IntegerValue.NEGATIVE_ONE);
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            result = this.fields[0] == ((IntervalYearMonthValue)otherValue).fields[0] && this.fields[1] == ((IntervalYearMonthValue)otherValue).fields[1];
        }
        return result;
    }
}

