/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.ObjectType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import org.dom4j.Element;

public class ObjectValue
extends Value {
    private static final String QUOTE = "'";
    static final long serialVersionUID = -4231132006736867360L;
    private Object value;

    ObjectValue() {
        super(ObjectType.OBJECTTYPE);
    }

    @Override
    public void set(Object obj) {
        this.value = obj;
        if (this.value != null) {
            this.setNotNull();
        }
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public String getString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    @Override
    public Object copy() {
        ObjectValue v = new ObjectValue();
        v.copyFrom(this);
        return v;
    }

    @Override
    public void copyFrom(IValue iValue) {
        Value pValue = (Value)iValue;
        if (pValue.isNull()) {
            this.setNull();
            return;
        }
        this.value = pValue.getObject();
        this.setNotNull();
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        return this.value.equals(obj);
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            ObjectValue otherObject = (ObjectValue)otherValue;
            result = this.value == null ? otherObject.value == null : this.value.equals(otherObject.value);
        }
        return result;
    }

    @Override
    public void persistAttributes(XQEPersistContext ctx) {
        super.persistAttributes(ctx);
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
    }

    @Override
    public String getSQLLiteral() throws UnsupportedOperationException {
        return QUOTE + this.value.toString().replace(QUOTE, "''") + QUOTE;
    }
}

