/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.PeriodType;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.IAddable;
import com.cognos.xqe.data.values.ISubtractable;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import java.sql.SQLException;
import org.dom4j.Element;

public class PeriodValue
extends Value
implements IAddable,
ISubtractable {
    static final long serialVersionUID = -4231132006736867360L;
    public static final String STATE_2FI00 = "2FI00";
    private static final String INVALID_PERIOD = "Input period has an end time that is not greater than its start time";
    private DateTimeValue start;
    private DateTimeValue end;
    private IDataType elementType;

    PeriodValue(PeriodType type) {
        super(type);
        this.elementType = type.getBaseType();
        this.start = (DateTimeValue)this.elementType.createValue();
        this.end = (DateTimeValue)this.elementType.createValue();
    }

    public DateTimeValue getStart() {
        return this.start;
    }

    public void setStart(DateTimeValue theStart) {
        this.setNotNull();
        this.start.copyFrom(theStart);
    }

    public DateTimeValue getEnd() {
        return this.end;
    }

    public void setEnd(DateTimeValue theEnd) {
        this.setNotNull();
        this.end.copyFrom(theEnd);
    }

    public void set(DateTimeValue theStart) {
        this.setStart(theStart);
    }

    public void set(DateTimeValue theStart, DateTimeValue theEnd) throws SQLException {
        if (!theStart.isNull() && !theEnd.isNull() && theEnd.compareTo(theStart) <= 0) {
            throw new SQLException(INVALID_PERIOD, STATE_2FI00);
        }
        this.setStart(theStart);
        this.setEnd(theEnd);
    }

    @Override
    public void set(Object obj) {
        this.copyFrom((IValue)obj);
    }

    public void set(Object[] attributes) {
        this.setNotNull();
        this.start.set(attributes[0]);
        this.end.set(attributes[1]);
    }

    @Override
    public Object copy() {
        PeriodValue v = new PeriodValue((PeriodType)this.dataType);
        v.copyFrom(this);
        return v;
    }

    @Override
    public void copyFrom(IValue iValue) {
        if (iValue == null || iValue.isNull()) {
            this.setNull();
            return;
        }
        PeriodValue pValue = (PeriodValue)iValue;
        this.setStart(pValue.getStart());
        this.setEnd(pValue.getEnd());
    }

    public Boolean contains(PeriodValue pValue) {
        if (pValue.isNull() || this.start.isNull() || this.end.isNull() || pValue.start.isNull() || pValue.end.isNull()) {
            return null;
        }
        if (this.start.compareTo(pValue.start) <= 0 && this.end.compareTo(pValue.end) >= 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean equals(PeriodValue pValue) {
        if (pValue.isNull() || this.start.isNull() || this.end.isNull() || pValue.start.isNull() || pValue.end.isNull()) {
            return null;
        }
        if (this.start.compareTo(pValue.start) == 0 && this.end.compareTo(pValue.end) == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public DateTimeValue intersectStart(PeriodValue pValue) {
        if (pValue.isNull() || this.start.isNull() || this.end.isNull() || pValue.start.isNull() || pValue.end.isNull()) {
            return null;
        }
        if (this.start.compareTo(pValue.end) < 0 && pValue.start.compareTo(this.end) < 0 || pValue.start.compareTo(this.end) < 0 && this.start.compareTo(pValue.end) < 0) {
            if (this.start.compareTo(pValue.start) < 0) {
                return pValue.start;
            }
            return this.start;
        }
        return null;
    }

    public DateTimeValue intersectEnd(PeriodValue pValue) {
        if (pValue.isNull() || this.start.isNull() || this.end.isNull() || pValue.start.isNull() || pValue.end.isNull()) {
            return null;
        }
        if (this.start.compareTo(pValue.end) < 0 && pValue.start.compareTo(this.end) < 0 || pValue.start.compareTo(this.end) < 0 && this.start.compareTo(pValue.end) < 0) {
            if (this.end.compareTo(pValue.end) < 0) {
                return this.end;
            }
            return pValue.end;
        }
        return null;
    }

    public PeriodValue intersect(PeriodValue pValue) {
        if (pValue.isNull() || this.start.isNull() || this.end.isNull() || pValue.start.isNull() || pValue.end.isNull()) {
            return null;
        }
        PeriodValue result = null;
        if (this.start.compareTo(pValue.end) < 0 && pValue.start.compareTo(this.end) < 0 || pValue.start.compareTo(this.end) < 0 && this.start.compareTo(pValue.end) < 0) {
            result = new PeriodValue((PeriodType)this.getDataType());
            if (this.start.compareTo(pValue.start) >= 0) {
                result.setStart(this.start);
            } else {
                result.setStart(pValue.start);
            }
            if (this.end.compareTo(pValue.end) <= 0) {
                result.setEnd(this.end);
            } else {
                result.setEnd(pValue.end);
            }
        }
        return result;
    }

    public DateTimeValue lDiffStart(PeriodValue pValue) {
        if (pValue.isNull() || this.start.isNull() || this.end.isNull() || pValue.start.isNull() || pValue.end.isNull()) {
            return null;
        }
        if (this.start.compareTo(pValue.start) < 0) {
            return this.start;
        }
        return null;
    }

    public DateTimeValue lDiffEnd(PeriodValue pValue) {
        if (pValue.isNull() || this.start.isNull() || this.end.isNull() || pValue.start.isNull() || pValue.end.isNull()) {
            return null;
        }
        if (this.start.compareTo(pValue.start) < 0) {
            return pValue.start;
        }
        return null;
    }

    public PeriodValue lDiff(PeriodValue pValue) throws SQLException {
        if (pValue.isNull() || this.start.isNull() || this.end.isNull() || pValue.start.isNull() || pValue.end.isNull()) {
            return null;
        }
        PeriodValue result = null;
        if (this.start.compareTo(pValue.end) < 0 && pValue.start.compareTo(this.end) < 0) {
            result = new PeriodValue((PeriodType)this.getDataType());
            if (this.start.compareTo(pValue.start) < 0) {
                result.set(this.start, pValue.start);
            }
        }
        return result;
    }

    public DateTimeValue rDiffStart(PeriodValue pValue) {
        if (pValue.isNull() || this.start.isNull() || this.end.isNull() || pValue.start.isNull() || pValue.end.isNull()) {
            return null;
        }
        if (this.end.compareTo(pValue.end) < 0) {
            return pValue.end;
        }
        return null;
    }

    public PeriodValue rDiff(PeriodValue pValue) throws SQLException {
        if (pValue.isNull() || this.start.isNull() || this.end.isNull() || pValue.start.isNull() || pValue.end.isNull()) {
            return null;
        }
        PeriodValue result = null;
        if (this.start.compareTo(pValue.end) < 0 && pValue.start.compareTo(this.end) < 0) {
            result = new PeriodValue((PeriodType)this.getDataType());
            if (this.end.compareTo(pValue.end) > 0) {
                result.set(pValue.end, this.end);
            }
        }
        return result;
    }

    public DateTimeValue rDiffEnd(PeriodValue pValue) {
        if (pValue.isNull() || this.start.isNull() || this.end.isNull() || pValue.start.isNull() || pValue.end.isNull()) {
            return null;
        }
        if (this.end.compareTo(pValue.end) < 0) {
            return this.end;
        }
        return null;
    }

    public DateTimeValue unionStart(PeriodValue pValue) {
        if (pValue.isNull() || this.start.isNull() || this.end.isNull() || pValue.start.isNull() || pValue.end.isNull()) {
            return null;
        }
        if (this.start.compareTo(pValue.start) <= 0 && this.end.compareTo(pValue.start) >= 0) {
            return this.start;
        }
        if (pValue.start.compareTo(this.start) <= 0 && pValue.end.compareTo(this.start) >= 0) {
            return pValue.start;
        }
        return null;
    }

    public DateTimeValue unionEnd(PeriodValue pValue) {
        if (pValue.isNull() || this.start.isNull() || this.end.isNull() || pValue.start.isNull() || pValue.end.isNull()) {
            return null;
        }
        if (this.end.compareTo(pValue.end) >= 0 && this.start.compareTo(pValue.end) <= 0) {
            return this.start;
        }
        if (pValue.end.compareTo(this.end) >= 0 && pValue.start.compareTo(this.end) <= 0) {
            return pValue.start;
        }
        return null;
    }

    public Integer meets(PeriodValue pValue) {
        if (pValue.isNull() || this.start.isNull() || this.end.isNull() || pValue.start.isNull() || pValue.end.isNull()) {
            return null;
        }
        if (this.end.compareTo(pValue.start) == 0) {
            return 1;
        }
        return 0;
    }

    public Boolean precedes(PeriodValue pValue) {
        if (this.isNull() || pValue.isNull() || this.start.isNull() || this.end.isNull() || pValue.start.isNull() || pValue.end.isNull()) {
            return null;
        }
        if (this.end.compareTo(pValue.start) <= 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean succeeds(PeriodValue pValue) {
        if (this.isNull() || pValue.isNull() || this.start.isNull() || this.end.isNull() || pValue.start.isNull() || pValue.end.isNull()) {
            return null;
        }
        if (this.start.compareTo(pValue.end) >= 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean immediatelyPrecedes(PeriodValue pValue) {
        if (this.isNull() || pValue.isNull() || this.start.isNull() || this.end.isNull() || pValue.start.isNull() || pValue.end.isNull()) {
            return null;
        }
        if (this.end.compareTo(pValue.start) == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean immediatelySucceeds(PeriodValue pValue) {
        if (this.isNull() || pValue.isNull() || this.start.isNull() || this.end.isNull() || pValue.start.isNull() || pValue.end.isNull()) {
            return null;
        }
        if (this.start.compareTo(pValue.end) == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean overlaps(PeriodValue pValue) {
        if (this.isNull() || pValue.isNull() || this.start.isNull() || this.end.isNull() || pValue.start.isNull() || pValue.end.isNull()) {
            return null;
        }
        if (this.start.compareTo(pValue.end) < 0 && pValue.start.compareTo(this.end) < 0) {
            return true;
        }
        return false;
    }

    public Integer within(PeriodValue pValue) {
        if (pValue.isNull() || this.start.isNull() || this.end.isNull() || pValue.start.isNull() || pValue.end.isNull()) {
            return null;
        }
        if (this.start.compareTo(pValue.start) >= 0 && this.end.compareTo(pValue.end) <= 0) {
            return 1;
        }
        return 0;
    }

    public PeriodValue normalize(PeriodValue pValue) throws SQLException {
        if (pValue.isNull() || this.start.isNull() || this.end.isNull() || pValue.start.isNull() || pValue.end.isNull()) {
            return null;
        }
        if (this.start.compareTo(pValue.start) >= 0 && this.start.compareTo(pValue.end) <= 0 || pValue.start.compareTo(this.start) >= 0 && pValue.start.compareTo(this.end) <= 0) {
            PeriodValue result = new PeriodValue((PeriodType)this.dataType);
            result.set(DateTimeValue.minimum(this.start, pValue.start), DateTimeValue.maximum(this.end, pValue.end));
            return result;
        }
        return null;
    }

    public DateTimeValue last() throws SQLException {
        if (this.isNull() || this.end.isNull()) {
            return null;
        }
        return this.end.prior();
    }

    @Override
    public void subtract(IValue value1, IValue value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void subtract(IValue value) {
        this.start.subtract(value);
        if (this.end != null) {
            this.end.subtract(value);
        }
    }

    @Override
    public void add(IValue value) {
        this.start.add(value);
        if (this.end != null) {
            this.end.add(value);
        }
    }

    @Override
    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PeriodValue) {
            PeriodValue pValue = (PeriodValue)obj;
            if (pValue.isNull() || this.start.isNull() || this.end.isNull() || pValue.start.isNull() || pValue.end.isNull()) {
                return false;
            }
            return this.start.compareTo(pValue.start) == 0 && this.end.compareTo(pValue.end) == 0;
        }
        return super.equals(obj);
    }

    @Override
    public int compareTo(Object o) {
        return this.start.compareTo(((PeriodValue)o).getStart());
    }

    @Override
    public String getString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(this.start.getString());
        builder.append(", ");
        builder.append(this.end.getString());
        builder.append(")");
        return builder.toString();
    }

    @Override
    public String toString() {
        return this.getString();
    }

    @Override
    public void persistAttributes(XQEPersistContext ctx) {
        super.persistAttributes(ctx);
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
    }
}

