/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.IEncodable;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.runtree.XDataContext;
import com.ibm.icu.text.Collator;
import com.ibm.json.java.JSONObject;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import java.util.TreeMap;
import org.dom4j.Element;

public class RowValue
extends Value
implements IRow {
    private static final String CLOSE_BRACE = "}";
    private static final String COMMA_SPACE = ", ";
    private static final String OPEN_BRACE = "{";
    static final long serialVersionUID = 1298622666537116649L;
    private transient int hashCode = 0;
    protected IValue[] rowData;

    RowValue() {
        this(RowType.ROWTYPE);
    }

    RowValue(RowType dType) {
        super(dType);
        this.setNotNull();
    }

    protected RowValue(int nColumns) {
        this();
        this.rowData = new IValue[nColumns];
    }

    protected RowValue(IValue[] pRowData) {
        this();
        this.rowData = pRowData;
    }

    @Override
    public void setNull() {
        super.setNull();
        for (IValue value : this.rowData) {
            value.setNull();
        }
    }

    public void set(IValue[] pRowData) {
        this.rowData = pRowData;
    }

    @Override
    public IValue[] getColumns() {
        return this.rowData;
    }

    @Override
    public IValue getColumn(int i) {
        return this.rowData[i];
    }

    public IValue getColumnForUpdate(int i) {
        this.setNotNull();
        return this.rowData[i];
    }

    @Override
    public void setColumn(int i, IValue value) {
        this.rowData[i] = value;
        this.hashCode = 0;
    }

    @Override
    public int getNumColumns() {
        if (this.rowData == null) {
            return 0;
        }
        return this.rowData.length;
    }

    @Override
    public Object copy() {
        return this.copy(true);
    }

    public RowValue copyWithSortedByRSAPIInfo() {
        for (IValue currValue : this.rowData) {
            if (currValue instanceof ContextBase) continue;
            return this;
        }
        RowValue newRowValue = (RowValue)this.copy(true);
        newRowValue.sortedByRSAPIInfo();
        return newRowValue;
    }

    private void sortedByRSAPIInfo() {
        TreeMap<Integer, ContextBase> rowDataSortedByRSAPIInfo = new TreeMap<Integer, ContextBase>();
        for (IValue currValue : this.rowData) {
            ContextBase currContextBase = (ContextBase)((Object)currValue);
            int rowsetId = currContextBase.getRowset().getRowsetId() + 2;
            int dataItemIdx = currContextBase.getDataItemIndex();
            Integer rowsetIdDataItemIdx = new Integer(rowsetId * 10000 + dataItemIdx);
            rowDataSortedByRSAPIInfo.put(rowsetIdDataItemIdx, currContextBase);
        }
        IValue[] newRowData = new IValue[this.rowData.length];
        Set rsapiInfoSet = rowDataSortedByRSAPIInfo.keySet();
        int pos = 0;
        for (Integer currPair : rsapiInfoSet) {
            ContextBase contextBase = (ContextBase)rowDataSortedByRSAPIInfo.get(currPair);
            if (contextBase instanceof ContextMember) {
                newRowData[pos++] = (ContextMember)contextBase;
                continue;
            }
            if (!(contextBase instanceof ContextValue)) continue;
            newRowData[pos++] = (ContextValue)contextBase;
        }
        this.rowData = newRowData;
    }

    public Object copy(boolean copyContextMembers) {
        IValue[] values = new IValue[this.rowData.length];
        for (int i = 0; i < this.rowData.length; ++i) {
            if (this.rowData[i] == null) continue;
            values[i] = copyContextMembers ? (IValue)this.rowData[i].copy() : (this.rowData[i] instanceof ContextMember && ((ContextMember)this.rowData[i]).getGroupBodyMeasures() == null ? this.rowData[i] : (IValue)this.rowData[i].copy());
        }
        RowValue newRow = new RowValue(values);
        newRow.hashCode = this.hashCode;
        return newRow;
    }

    @Override
    public void copyFrom(IValue iValue) {
        RowValue row = (RowValue)iValue;
        this.hashCode = row.hashCode;
        if (row.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            for (int i = 0; i < this.rowData.length; ++i) {
                this.rowData[i].copyFrom(row.getColumn(i));
            }
        }
    }

    @Override
    public int compareTo(Object object) throws XQERuntimeException {
        if (!(object instanceof RowValue)) {
            throw new ClassCastException();
        }
        int result = 0;
        IValue[] iValues = ((RowValue)object).getColumns();
        for (int i = 0; i < this.rowData.length && (result = this.rowData[i].compareTo(iValues[i])) == 0; ++i) {
        }
        return result;
    }

    public boolean equals(Object object) {
        if (this.hashCode() == ((RowValue)object).hashCode()) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    @Override
    public Object hashKey(Collator collator) {
        IValue[] values = new IValue[this.rowData.length];
        for (int i = 0; i < this.rowData.length; ++i) {
            values[i] = (IValue)this.rowData[i].hashKey(collator);
        }
        RowValue newRow = new RowValue(values);
        newRow.hashCode = this.hashCode;
        return newRow;
    }

    @Override
    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        for (IValue v : this.rowData) {
            if (v.isMetadata()) {
                IMetadata mdObj = (IMetadata)((Object)v);
                String caption = mdObj.getCaption();
                if (null == caption) {
                    this.hashCode ^= 0;
                    continue;
                }
                this.hashCode ^= caption.hashCode();
                continue;
            }
            this.hashCode ^= v.hashCode();
        }
        if (this.hashCode == 0) {
            this.hashCode = 1;
        }
        return this.hashCode;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public BooleanValue sqlCompareTo(Object pObject) throws XQERuntimeException {
        return BooleanValue.TRUE;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isMetadata() {
        return false;
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        this.hashCode = iStream.readInt();
        for (int i = 0; i < this.rowData.length; ++i) {
            ((IEncodable)((Object)this.rowData[i])).decode(context, iStream);
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        oStream.writeInt(this.hashCode);
        for (int i = 0; i < this.rowData.length; ++i) {
            ((IEncodable)((Object)this.rowData[i])).encode(context, oStream);
        }
    }

    @Override
    public int sizeOf() {
        int size = 0;
        int arrayListSize = ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.ARRAYLIST);
        size += arrayListSize;
        int totalObjectReference = ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.OBJECTREFERENCE) * this.rowData.length;
        size += totalObjectReference;
        for (int i = 0; i < this.rowData.length; ++i) {
            size += this.rowData[i].sizeOf();
        }
        return size;
    }

    @Override
    public boolean isSummary() {
        if (this.rowData.length < 1) {
            return false;
        }
        for (int i = 0; i < this.rowData.length; ++i) {
            ContextBase contextItem;
            if (!(this.rowData[i] instanceof ContextBase) || !(contextItem = (ContextBase)((Object)this.rowData[i])).isSummary()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OPEN_BRACE);
        for (int i = 0; i < this.rowData.length; ++i) {
            if (i > 0) {
                buffer.append(COMMA_SPACE);
            }
            buffer.append(this.rowData[i].toString());
        }
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    @Override
    public Object toJSON() {
        if (this.isNull()) {
            return null;
        }
        RowType dType = (RowType)this.dataType;
        JSONObject jObject = new JSONObject();
        for (int i = 0; i < this.rowData.length; ++i) {
            jObject.put((Object)dType.getFieldName(i), this.rowData[i].toJSON());
        }
        return jObject;
    }

    public static int getEncodedSize() {
        return -1;
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result && this.isOK()) {
            RowValue otherRow = (RowValue)otherValue;
            boolean bl = result = this.rowData.length == otherRow.rowData.length;
            if (result) {
                for (int i = 0; i < this.rowData.length; ++i) {
                    if (this.rowData[i] == null) {
                        result = otherRow.rowData[i] == null;
                    } else {
                        boolean otherDataIsValue = otherRow.rowData[i] instanceof Value;
                        if (this.rowData[i] instanceof Value) {
                            result = otherDataIsValue ? ((Value)this.rowData[i]).exactlyEquivalent((Value)otherRow.rowData[i]) : false;
                        } else {
                            boolean bl2 = result = !otherDataIsValue;
                            if (result) {
                                result = this.rowData[i].equals(otherRow.rowData[i]);
                            }
                        }
                    }
                    if (!result) break;
                }
            }
        }
        return result;
    }

    public Boolean containsNull() {
        IValue[] iValues = this.getColumns();
        for (int i = 0; i < iValues.length; ++i) {
            if (!iValues[i].isNull()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void persistAttributes(XQEPersistContext ctx) {
        super.persistAttributes(ctx);
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
    }
}

