/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.values;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.types.TextType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.CharValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.FloatValue;
import com.cognos.xqe.data.values.IAppendable;
import com.cognos.xqe.data.values.IPosition;
import com.cognos.xqe.data.values.ITextValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NCharValue;
import com.cognos.xqe.data.values.NVarcharValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TimeValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.data.values.VarcharValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.MathUtil;
import com.ibm.icu.text.Collator;
import com.ibm.json.java.internal.Serializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.dom4j.Element;

public abstract class TextValue
extends Value
implements ITextValue,
IAppendable,
IPosition {
    static final long serialVersionUID = -4231132006736867360L;
    private static final String POUND_ERR = "#ERR";
    protected String value;
    private Collator collator;
    protected static final String QUOTE = "'";
    protected static final String DOUBLE_QUOTE = "\"";
    private static final String ESCAPED_QUOTE = "''";
    protected static final String SPACE = " ";
    private static final int NULLVALUE_HASHCODE = Integer.MIN_VALUE;
    private transient int hashCode = Integer.MIN_VALUE;
    public static final TextValue ERROR_VALUE = DataValueFactory.createStringValue();
    private static final int UGLY_MULTIPLIER = 2;
    private static final int UGLY_ADDITIVE = 2;

    TextValue(TextType dType, Collator theCollator) {
        super(dType);
        this.collator = theCollator;
    }

    private void resetHashCode() {
        this.hashCode = Integer.MIN_VALUE;
    }

    @Override
    public void setNull() {
        super.setNull();
        this.resetHashCode();
    }

    @Override
    public void setNotNull() {
        super.setNotNull();
        this.resetHashCode();
    }

    @Override
    public void set(IValue v) throws XQERuntimeException {
        if (v == null || v.isNull()) {
            this.setNull();
            return;
        }
        this.setValue(((Value)v).getString());
        this.copyFormatIdFrom(v);
        if (v instanceof TextValue) {
            this.collator = ((TextValue)v).getCollator();
        }
        if (((Value)v).getState() == ValueState.ERROR) {
            this.setState(ValueState.ERROR);
        } else {
            this.setNotNull();
        }
    }

    @Override
    public void set(Object object) {
        if (object == null) {
            this.setNull();
        } else if (object instanceof String) {
            this.set((String)object);
        } else {
            this.set(object.toString());
        }
    }

    @Override
    public void set(String sValue) throws ValueConversionException {
        if (sValue == null) {
            this.setNull();
            return;
        }
        if (this.getMaximumLength() > 0 && sValue.length() > this.getMaximumLength()) {
            int i;
            for (i = sValue.length(); i > this.getMaximumLength() && sValue.charAt(i - 1) == ' '; --i) {
            }
            if (i > this.getMaximumLength()) {
                throw new ValueConversionException(XQEMessageKeys.DAT_StringOverflowError, Integer.toString(sValue.length()), this.dataType.getTypeName(), Integer.toString(this.getMaximumLength()));
            }
            this.setValue(sValue.substring(0, this.getMaximumLength()));
            this.setNotNull();
        } else {
            this.setValue(sValue);
            this.setNotNull();
        }
    }

    @Override
    public void set(char[] cValue) {
        if (cValue == null) {
            this.setNull();
            return;
        }
        this.set(String.valueOf(cValue));
    }

    @Override
    public void set(byte bValue) {
        this.value = Byte.toString(bValue);
        this.setNotNull();
    }

    @Override
    public void set(short sValue) {
        this.value = Short.toString(sValue);
        this.setNotNull();
    }

    @Override
    public void set(int iValue) {
        this.value = Integer.toString(iValue);
        this.setNotNull();
    }

    @Override
    public void set(long lValue) throws ValueConversionException {
        this.value = Long.toString(lValue);
        this.setNotNull();
    }

    @Override
    public void set(float fValue) throws ValueConversionException {
        this.value = Float.toString(fValue);
        this.setNotNull();
    }

    @Override
    public void set(double dValue) throws ValueConversionException {
        this.value = Double.toString(dValue);
        this.setNotNull();
    }

    @Override
    public void set(BigDecimal dValue) throws ValueConversionException {
        this.value = dValue.toString();
        this.setNotNull();
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        if (this.isError() && this.value == null) {
            return POUND_ERR;
        }
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String val) {
        this.value = val;
        this.resetHashCode();
    }

    public Collator getCollator() {
        return this.collator;
    }

    public void setCollator(Collator coll) {
        this.collator = coll;
        this.resetHashCode();
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        super.decode(context, iStream);
        if (this.isOK()) {
            this.set(iStream.readUTF());
        } else {
            this.resetHashCode();
        }
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        super.encode(context, oStream);
        if (this.isOK()) {
            oStream.writeUTF(this.value);
        }
    }

    @Override
    public int compareTo(Object pObject) {
        return this.compareTo(pObject, this.collator);
    }

    public int compareTo(Object pObject, Collator compareCollator) {
        int result;
        if (pObject == this) {
            return 0;
        }
        String sValue = null;
        IValue a = null;
        boolean sourceIsNull = false;
        if (pObject == null) {
            sourceIsNull = true;
        } else if (pObject instanceof IValue) {
            a = (IValue)pObject;
            sourceIsNull = a.isNull();
            if (pObject instanceof IMember) {
                sValue = ((IMember)pObject).getName();
            } else if (pObject instanceof TextValue) {
                sValue = ((TextValue)pObject).getString();
            } else {
                if (pObject instanceof DateTimeValue) {
                    return -1 * ((DateTimeValue)pObject).compareTo(this);
                }
                if (pObject instanceof BooleanValue) {
                    try {
                        return -1 * ((BooleanValue)pObject).compareTo(this);
                    }
                    catch (ValueConversionException vce) {
                        sValue = String.valueOf(((BooleanValue)pObject).getDouble());
                    }
                } else {
                    sValue = a instanceof Value ? ((Value)a).getString() : a.toString();
                }
            }
        } else if (pObject instanceof String) {
            sValue = (String)pObject;
        } else {
            return -1;
        }
        if (this.isNull()) {
            if (sourceIsNull) {
                return 0;
            }
            return -1;
        }
        if (sourceIsNull) {
            return 1;
        }
        if (this.isError()) {
            if (pObject instanceof Value && ((Value)pObject).isError()) {
                return 0;
            }
            return -1;
        }
        if (pObject instanceof Value && ((Value)pObject).isError()) {
            return 1;
        }
        String thisValue = this.value;
        if (this.isTypeOfChar(pObject) && this.isTypeOfChar(this)) {
            int thisLength;
            int pLength = ((TextValue)pObject).getString().length();
            if (pLength < (thisLength = this.getString().length())) {
                sValue = ((TextValue)pObject).rPad(thisLength, null);
            } else if (pLength > thisLength) {
                thisValue = this.rPad(pLength, null);
            }
        }
        if ((result = compareCollator == null ? thisValue.compareTo(sValue) : compareCollator.compare(thisValue, sValue)) == 0) {
            return 0;
        }
        if (result > 0) {
            return 1;
        }
        return -1;
    }

    private boolean isTypeOfChar(Object valueObject) {
        return valueObject instanceof CharValue || valueObject instanceof VarcharValue || valueObject instanceof NCharValue || valueObject instanceof NVarcharValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof IValue && this.hashCode() != ((IValue)o).hashCode()) {
            return false;
        }
        return this.compareTo(o) == 0;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == Integer.MIN_VALUE && !this.isNull()) {
            this.hashCode = this.collator != null ? this.collator.getCollationKey(this.value.replaceAll("\\s+$", "")).hashCode() : this.value.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public Object hashKey(Collator coll) {
        TextValue tv = (TextValue)this.copy();
        tv.setCollator(coll);
        if (coll.equals(this.collator)) {
            tv.setHashCode(this.hashCode);
        }
        return tv;
    }

    public BooleanValue sqlCompareTo(Object object) {
        TextValue a = (TextValue)object;
        if (this.isNull() || a.isNull()) {
            return BooleanValue.UNKNOWN;
        }
        if (this.compareTo(a) == 0) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }

    @Override
    public void copyFrom(IValue iValue) throws XQERuntimeException {
        if (iValue.isNull()) {
            this.setNull();
            return;
        }
        this.setNotNull();
        if (iValue instanceof Value) {
            Value val = (Value)iValue;
            this.setValue(val.getString());
            if (val.isError()) {
                this.setState(ValueState.ERROR);
            }
            if (val instanceof TextValue) {
                this.collator = ((TextValue)iValue).collator;
                this.hashCode = ((TextValue)iValue).hashCode;
            }
            this.copyFormatIdFrom(val);
        } else {
            this.setValue(iValue.toString());
        }
    }

    @Override
    public void validate(IDataType iDataType, XQELogger aLogger) {
        if (this.dataType.hasPrecision() && this.value.length() > this.dataType.getPrecision()) {
            if (iDataType.isTextType() || iDataType instanceof TextType || iDataType == MemberType.MEMBERTYPE || iDataType.getCCLTypeCode() == 46) {
                this.setValue(this.value.substring(0, this.dataType.getPrecision()));
                aLogger.log(LogLevel.WARN, OperationEnum.DEFAULT, XQEMessageKeys.DAT_RightTruncation);
            } else {
                throw new ValueConversionException(XQEMessageKeys.DAT_StringOverflowError, Integer.toString(this.value.length()), this.dataType.getTypeName(), Integer.toString(this.dataType.getPrecision()));
            }
        }
    }

    @Override
    public void append(String sValue) throws ValueConversionException {
        if (this.getMaximumLength() != -1 && this.getCurrentLength() + sValue.length() > this.getMaximumLength()) {
            throw new ValueConversionException(XQEMessageKeys.DAT_StringOverflowError, Integer.toString(this.getCurrentLength() + sValue.length()), this.dataType.getTypeName(), Integer.toString(this.getMaximumLength()));
        }
        this.setValue(this.value + sValue);
        this.setNotNull();
    }

    @Override
    public void append(IValue sValue) throws ValueConversionException {
        this.append(((Value)sValue).getString());
    }

    public void append(char[] pValue) throws XQERuntimeException {
        this.append(new String(pValue));
    }

    public void append(StringValue sValue) throws XQERuntimeException {
        this.append(sValue.getString());
    }

    public void append(StringBuilder sValue) throws XQERuntimeException {
        this.append(sValue.toString());
    }

    public String rPad(int length, String pattern) throws IllegalArgumentException {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        if (this.isNull()) {
            return null;
        }
        if (this.value.length() >= length) {
            return this.value.substring(0, length);
        }
        if (pattern == null || pattern.length() < 1) {
            pattern = new String(SPACE);
        }
        StringBuilder b = new StringBuilder(length);
        b.append(this.value);
        int padChars = length - this.value.length();
        int i = 0;
        block0: while (i < padChars) {
            for (int k = 0; k < pattern.length(); ++k) {
                b.insert(this.value.length() + i, pattern.charAt(k));
                if (++i == padChars) continue block0;
            }
        }
        return b.toString();
    }

    public String rTrim(String pattern) {
        boolean patternNull = false;
        if (this.isNull()) {
            return null;
        }
        if (pattern == null || pattern.length() < 1) {
            pattern = SPACE;
            patternNull = true;
        }
        if (pattern.length() > this.value.length()) {
            return this.value;
        }
        int i = this.value.length();
        while (i > 0) {
            StringBuilder b = new StringBuilder();
            for (int k = 0; k < pattern.length(); ++k) {
                b.insert(0, this.value.charAt(i - 1));
                --i;
            }
            if (patternNull ? !Character.isWhitespace(b.charAt(0)) : pattern.compareTo(b.toString()) != 0) {
                return this.value.substring(0, i += pattern.length());
            }
            if (i == this.value.length()) break;
            if (pattern.length() <= i) continue;
            return this.value.substring(0, i);
        }
        return "";
    }

    public String lPad(int length, String pattern) throws IllegalArgumentException {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        if (this.isNull()) {
            return null;
        }
        if (this.value.length() >= length) {
            return this.value.substring(0, length);
        }
        if (pattern == null || pattern.length() < 1) {
            pattern = new String(SPACE);
        }
        StringBuilder b = new StringBuilder(length);
        int padChars = length - this.value.length();
        int i = 0;
        block0: while (i < padChars) {
            for (int k = 0; k < pattern.length(); ++k) {
                b.insert(i, pattern.charAt(k));
                if (++i == padChars) continue block0;
            }
        }
        b.append(this.value);
        return b.toString();
    }

    public String lTrim(String pattern) {
        boolean patternNull = false;
        if (this.isNull()) {
            return null;
        }
        if (pattern == null || pattern.length() < 1) {
            pattern = SPACE;
            patternNull = true;
        }
        if (pattern.length() > this.value.length()) {
            return this.value;
        }
        int i = 0;
        while (i < this.value.length()) {
            StringBuilder b = new StringBuilder();
            for (int k = 0; k < pattern.length(); ++k) {
                b.insert(k, this.value.charAt(i));
                ++i;
            }
            if (patternNull ? !Character.isWhitespace(b.charAt(0)) : pattern.compareTo(b.toString()) != 0) {
                return this.value.substring(i -= pattern.length(), this.value.length());
            }
            if (i == this.value.length()) break;
            if (pattern.length() <= this.value.length() - i) continue;
            return this.value.substring(i, this.value.length());
        }
        return "";
    }

    public String substring(int index) throws ValueConversionException {
        if (this.isNull()) {
            return null;
        }
        if (index < 0 || index > this.value.length() - 1) {
            throw new ValueConversionException(XQEMessageKeys.DAT_SubstringFunctionError, Integer.toString(index), Integer.toString(this.value.length()), Integer.toString(this.value.length()));
        }
        return this.value.substring(index);
    }

    public String substring(int indexStart, int indexEnd) throws ValueConversionException {
        if (this.isNull()) {
            return null;
        }
        if (indexStart < 0 || indexStart > indexEnd || indexEnd > this.value.length()) {
            throw new ValueConversionException(XQEMessageKeys.DAT_SubstringFunctionError, Integer.toString(indexStart), Integer.toString(indexEnd), Integer.toString(this.value.length()));
        }
        return this.value.substring(indexStart, indexEnd);
    }

    @Override
    public String substring(long indexStart, int indexEnd) throws ValueConversionException {
        return this.substring((int)indexStart, indexEnd);
    }

    @Override
    public long position(IValue pattern) {
        return this.value.indexOf(pattern.toString()) + 1;
    }

    @Override
    public boolean getBoolean() throws ValueConversionException {
        if (this.isNull() || this.getValue() == null) {
            return false;
        }
        if (this.value.compareToIgnoreCase("true") == 0 || this.value.compareToIgnoreCase("1") == 0) {
            return true;
        }
        if (this.value.compareToIgnoreCase("false") == 0 || this.value.compareToIgnoreCase("0") == 0) {
            return false;
        }
        if (this.value.compareToIgnoreCase("unknown") == 0) {
            return false;
        }
        throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, this.dataType.getTypeName(), this.value, "boolean");
    }

    @Override
    public short getShort() {
        short result;
        try {
            result = Short.parseShort(this.value.trim());
        }
        catch (NumberFormatException e) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)e, "string", this.value, "smallint");
        }
        return result;
    }

    @Override
    public short getShort(int precision, int scale) {
        short result = this.getShort();
        if (scale == 0) {
            return result;
        }
        return (short)((double)result * MathUtil.pow10(scale));
    }

    @Override
    public int getInteger() {
        int result;
        try {
            result = Integer.parseInt(this.value.trim());
        }
        catch (NumberFormatException e) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)e, "string", this.value, "integer");
        }
        return result;
    }

    @Override
    public int getInteger(int precision, int scale) {
        int result = this.getInteger();
        if (scale == 0) {
            return result;
        }
        return (int)((double)result * MathUtil.pow10(scale));
    }

    public long getTimeInNanoseconds() {
        long result;
        try {
            result = Long.parseLong(this.value.trim());
        }
        catch (NumberFormatException e) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)e, "string", this.value, "long");
        }
        return result;
    }

    @Override
    public long getLong(int precision, int scale) {
        long result = this.getTimeInNanoseconds();
        if (scale == 0) {
            return result;
        }
        return (long)((double)result * MathUtil.pow10(scale));
    }

    @Override
    public BigDecimal getBigDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    public BigDecimal getBigDecimal(int precision, int scale) {
        BigDecimal bd = new BigDecimal(this.value, new MathContext(precision, RoundingMode.HALF_DOWN));
        return bd.setScale(scale, RoundingMode.HALF_DOWN);
    }

    @Override
    public float getFloat() {
        FloatValue floatValue = DataValueFactory.createFloatValue();
        floatValue.set(this.value);
        return floatValue.getFloat();
    }

    @Override
    public double getDouble() throws XQERuntimeException {
        DoubleValue doubleValue = DataValueFactory.createDoubleValue();
        doubleValue.set(this.value);
        return doubleValue.getDouble();
    }

    @Override
    public Timestamp getTimestamp() throws XQERuntimeException {
        if (this.isNull() || this.value == null) {
            return null;
        }
        TimestampValue tv = DataValueFactory.createTimestampValue();
        tv.set(this.value);
        return tv.getTimestamp();
    }

    @Override
    public Date getDate() throws XQERuntimeException {
        if (this.isNull() || this.value == null) {
            return null;
        }
        DateValue dv = DataValueFactory.createDateValue();
        dv.set(this.value);
        return dv.getDate();
    }

    @Override
    public Time getTime() throws XQERuntimeException {
        if (this.isNull() || this.value == null) {
            return null;
        }
        TimeValue dv = DataValueFactory.createTimeValue();
        dv.set(this.value);
        return dv.getTime();
    }

    @Override
    public String getSQLLiteral() {
        if (this.isNull()) {
            return null;
        }
        return QUOTE + this.value.replace(QUOTE, ESCAPED_QUOTE) + QUOTE;
    }

    @Override
    public String getSQLLiteral(String literalQuoteEscape) {
        if (this.isNull()) {
            return null;
        }
        String intermediateValue = TextValue.handleLiteralQuoteEscapeSequenceInOriginalValue(this.value, literalQuoteEscape);
        return QUOTE + intermediateValue.replace(QUOTE, literalQuoteEscape) + QUOTE;
    }

    private static String handleLiteralQuoteEscapeSequenceInOriginalValue(String originalValue, String literalQuoteEscape) {
        int literalQuoteEscapeLength = literalQuoteEscape.length();
        if (literalQuoteEscapeLength > 1) {
            String escapeSequence = literalQuoteEscape.substring(0, literalQuoteEscapeLength - 1);
            String result = originalValue.replace(escapeSequence, escapeSequence + escapeSequence);
            return result;
        }
        return originalValue;
    }

    @Override
    public String getJDBCLiteral(String literalQuoteEscape) {
        return this.getSQLLiteral(literalQuoteEscape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJSONLiteral() {
        String string;
        StringWriter writer = new StringWriter();
        Serializer srl = new Serializer((Writer)writer);
        try {
            if (this.isNull()) {
                srl.writeNull().flush();
            } else {
                srl.writeString(this.value).flush();
            }
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                srl.close();
                writer.close();
                srl = null;
                writer = null;
                throw throwable;
            }
            catch (IOException e) {
                throw new XQERuntimeException(XQEMessageKeys.EXE_InvalidJSONFormat, (Throwable)e);
            }
        }
        srl.close();
        writer.close();
        srl = null;
        writer = null;
        return string;
    }

    @Override
    public String getFormattedLiteral(String formatSpec) {
        if (this.isNull()) {
            return null;
        }
        return String.format(formatSpec, this.value.replace(QUOTE, ESCAPED_QUOTE));
    }

    @Override
    public String getFormattedLiteral(String formatSpec, String literalQuoteEscape) {
        if (this.isNull()) {
            return null;
        }
        String intermediateValue = TextValue.handleLiteralQuoteEscapeSequenceInOriginalValue(this.value, literalQuoteEscape);
        return String.format(formatSpec, intermediateValue.replace(QUOTE, literalQuoteEscape));
    }

    @Override
    public String getV5Literal() {
        return QUOTE + this.getV5formattedString().replaceAll(QUOTE, ESCAPED_QUOTE) + QUOTE;
    }

    @Override
    public char[] getCharArray() {
        if (this.isNull()) {
            return null;
        }
        return this.value.toCharArray();
    }

    @Override
    public byte[] getByteArray() {
        if (this.isNull()) {
            return null;
        }
        return this.value.getBytes();
    }

    public int getMaximumLength() {
        int result = this.dataType.getPrecision();
        if (result > 0) {
            result = result * 2 + 2;
        }
        return result;
    }

    public int getCurrentLength() {
        if (this.isNull()) {
            return 0;
        }
        return this.value.length();
    }

    public char getCharAt(int pIndex) {
        return this.value.charAt(pIndex);
    }

    @Override
    public Object getObject() {
        return this.getString();
    }

    @Override
    public int sizeOf() {
        if (this.isNull()) {
            return ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.TEXT);
        }
        return ValueSizeInfo.getSizeOfTextValue(this);
    }

    public static int getEncodedSize() {
        return -1;
    }

    @Override
    public boolean exactlyEquivalent(Value otherValue) {
        boolean result = super.exactlyEquivalent(otherValue);
        if (result) {
            TextValue otherText = (TextValue)otherValue;
            boolean bl = result = this.collator == otherText.collator;
            if (result) {
                result = this.value == null ? otherText.value == null : this.value.equals(otherText.value);
            }
        }
        return result;
    }

    public void setHashCode(int theHashCode) {
        this.hashCode = theHashCode;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    @Override
    public void persistData(XQEPersistContext ctx) {
        if (this.value != null) {
            ctx.data(this.value);
        }
    }

    @Override
    public void restoreData(XQERestoreContext ctx, Element node) {
        String text = node.getText();
        if (text != null) {
            this.value = text;
        }
    }

    static {
        ERROR_VALUE.set(POUND_ERR);
        ERROR_VALUE.setState(ValueState.ERROR);
    }
}

