/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.exception;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis.AxisFault;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XQEAxisFaultException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final String SPACE = " ";
    private static final String RIGHT_BRACKET = "]";
    private final AxisFault axisFault;

    public XQEAxisFaultException(AxisFault fault) {
        super((Throwable)fault);
        this.axisFault = fault;
    }

    private String getAxisFaultMessage() {
        return this.axisFault.getMessage();
    }

    private String getAxisFaultSeverity() {
        String severity = XQEAxisFaultException.getChildNodeValue(this.getExceptionNode(), "severity");
        if (severity == null) {
            severity = this.axisFault.getFaultString();
        }
        return severity;
    }

    private String getAxisFaultErrorCode() {
        String errorCode = XQEAxisFaultException.getChildNodeValue(this.getExceptionNode(), "errorCode");
        if (errorCode == null) {
            errorCode = this.axisFault.getFaultCode().toString();
        }
        return errorCode;
    }

    public List<String> getAxisFaultMessageStrings() {
        ArrayList<String> messageStrings = new ArrayList<String>();
        List<Node> messageNodes = XQEAxisFaultException.getChildNodes(this.getExceptionNode(), "message");
        for (Node messageNode : messageNodes) {
            String messageString = XQEAxisFaultException.getChildNodeValue(messageNode, "messageString");
            if (messageString == null) continue;
            messageStrings.add(messageString);
        }
        if (messageStrings.isEmpty()) {
            messageStrings.add(this.axisFault.getFaultReason());
        }
        return messageStrings;
    }

    private Node getExceptionNode() {
        Element exceptionNode = null;
        Element[] detailChildElements = this.axisFault.getFaultDetails();
        if (detailChildElements != null && detailChildElements.length > 0) {
            exceptionNode = detailChildElements[0];
        }
        return exceptionNode;
    }

    private static String getChildNodeValue(Node parentNode, String nodeName) {
        Node node;
        String nodeValue = null;
        List<Node> childNodes = XQEAxisFaultException.getChildNodes(parentNode, nodeName);
        if (!childNodes.isEmpty() && (node = childNodes.get(0).getFirstChild()) != null) {
            nodeValue = node.getNodeValue().trim();
        }
        return nodeValue;
    }

    private static List<Node> getChildNodes(Node parentNode, String nodeName) {
        ArrayList<Node> nodesToReturn = new ArrayList<Node>();
        if (parentNode != null && parentNode.hasChildNodes()) {
            NodeList childNodes = parentNode.getChildNodes();
            int childNodeCount = childNodes.getLength();
            for (int childNodeIndex = 0; childNodeIndex < childNodeCount; ++childNodeIndex) {
                Node childNode = childNodes.item(childNodeIndex);
                String childName = childNode.getLocalName();
                if (childName == null || !childName.equals(nodeName)) continue;
                nodesToReturn.add(childNode);
            }
        }
        return nodesToReturn;
    }

    @Override
    public String getMessage() {
        StringBuilder stringBuffer = new StringBuilder("[");
        stringBuffer.append("[AxisFaultMessage: ").append(this.getAxisFaultMessage()).append(RIGHT_BRACKET).append(SPACE);
        stringBuffer.append("[AxisFaultSeverity: ").append(this.getAxisFaultSeverity()).append(RIGHT_BRACKET).append(SPACE);
        stringBuffer.append("[AxisFaultErrorCode: ").append(this.getAxisFaultErrorCode()).append(RIGHT_BRACKET).append(SPACE);
        stringBuffer.append("[AxisFaultDetails: ");
        List<String> details = this.getAxisFaultMessageStrings();
        stringBuffer.append(details.toString());
        stringBuffer.append(RIGHT_BRACKET);
        stringBuffer.append(RIGHT_BRACKET);
        return stringBuffer.toString();
    }
}

