/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.exception;

import com.cognos.xqe.exception.XQEErrorCodeConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.IStaxComponentHandler;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.util.HashSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class XQEErrorCodeHandler
implements IStaxComponentHandler {
    private static final String XQE_ERRORCODES_CONFIGURATION = "XQEErrorCodesConfiguration";
    private static final String SEARCH_URL = "searchURL";
    private static final String ERROR_CODES = "errorCodes";
    private static final String ERROR = "error";
    private final XQEErrorCodeConfigurationManager configuration;

    public XQEErrorCodeHandler(XQEErrorCodeConfigurationManager theConfiguation) {
        this.configuration = theConfiguation;
    }

    @Override
    public void consume(XMLStreamReader reader) throws XMLStreamException {
        StaxUtil.moveToElement(reader);
        reader.require(1, null, XQE_ERRORCODES_CONFIGURATION);
        ChildElementIterator childIter = new ChildElementIterator(reader);
        HashSet<String> errors = new HashSet<String>();
        while (childIter.next()) {
            String name = reader.getLocalName();
            if (name.equals(SEARCH_URL)) {
                this.consumeSearchURL(reader);
                continue;
            }
            if (name.equals(ERROR_CODES)) {
                this.configuration.setErrorCodesConsumed(true);
                this.consumeErrorCodes(reader, errors);
                continue;
            }
            throw new XQERuntimeException(XQEMessageKeys.XML_UnexpectedXMLElementWithLoc, reader.getName(), (Object)reader.getLocation().getLineNumber(), (Object)reader.getLocation().getColumnNumber());
        }
        while (reader.getEventType() != 8) {
            reader.next();
        }
        this.configuration.setErrorCode(errors);
    }

    private void consumeSearchURL(XMLStreamReader reader) throws XMLStreamException {
        this.configuration.setSearchURL(reader.getElementText());
    }

    private void consumeErrorCodes(XMLStreamReader reader, HashSet<String> theErrors) throws XMLStreamException {
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (ERROR.equals(reader.getLocalName())) {
                this.consumeError(reader, theErrors);
                continue;
            }
            throw new XQERuntimeException(XQEMessageKeys.XML_UnexpectedXMLElementWithLoc, reader.getName(), (Object)reader.getLocation().getLineNumber(), (Object)reader.getLocation().getColumnNumber());
        }
    }

    private void consumeError(XMLStreamReader reader, HashSet<String> errors) throws XMLStreamException {
        String errorCode = reader.getElementText();
        if (null == errorCode) {
            throw new XQERuntimeException(XQEMessageKeys.XML_MissingXMLElementWithLoc, (Object)ERROR, (Object)reader.getLocation().getLineNumber(), (Object)reader.getLocation().getColumnNumber());
        }
        errors.add(errorCode);
    }
}

