/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.formatter;

import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.formatter.Criterion;
import com.cognos.xqe.format.formatter.ILogicalCondition;
import com.cognos.xqe.format.formatter.ResultFormatter;
import java.util.Iterator;
import java.util.List;

public class SearchCondition
implements ILogicalCondition {
    private boolean allCriteriaMustBeMet;
    private List<Criterion> criteria;

    public SearchCondition(boolean isAndLogicalOperator, List<Criterion> searchCriteria) {
        this.allCriteriaMustBeMet = isAndLogicalOperator;
        this.criteria = searchCriteria;
    }

    @Override
    public boolean isMet() {
        ResultFormatter formatter = FormatService.getInstance().getCurrentFormatter();
        List<FormatPropertySet> operandPropertySets = formatter.getAllOperandProperties();
        if (operandPropertySets.isEmpty()) {
            return false;
        }
        for (FormatPropertySet formatPropertySet : operandPropertySets) {
            Iterator<Criterion> criterionItr = this.criteria.iterator();
            boolean foundFailedCriterion = false;
            while (criterionItr.hasNext()) {
                Criterion criterion = criterionItr.next();
                if (criterion.isMet(formatPropertySet)) {
                    if (this.allCriteriaMustBeMet) continue;
                    return true;
                }
                foundFailedCriterion = true;
                if (!this.allCriteriaMustBeMet) continue;
                break;
            }
            if (!this.allCriteriaMustBeMet || foundFailedCriterion) continue;
            return true;
        }
        return false;
    }

    public boolean isAndLogicalOperator() {
        return this.allCriteriaMustBeMet;
    }

    public List<Criterion> getCriteria() {
        return this.criteria;
    }
}

