/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.formatter;

import com.cognos.xqe.format.FormatResourceParsingException;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.formatter.Action;
import com.cognos.xqe.format.formatter.AndCondition;
import com.cognos.xqe.format.formatter.AssignmentTransformation;
import com.cognos.xqe.format.formatter.BinaryComparisonCondition;
import com.cognos.xqe.format.formatter.BinaryPatternCondition;
import com.cognos.xqe.format.formatter.BinaryTransformation;
import com.cognos.xqe.format.formatter.Case;
import com.cognos.xqe.format.formatter.CaseTransformation;
import com.cognos.xqe.format.formatter.Criterion;
import com.cognos.xqe.format.formatter.ExpressionType;
import com.cognos.xqe.format.formatter.IBinaryCondition;
import com.cognos.xqe.format.formatter.ICondition;
import com.cognos.xqe.format.formatter.ILogicalCondition;
import com.cognos.xqe.format.formatter.ISetCondition;
import com.cognos.xqe.format.formatter.Library;
import com.cognos.xqe.format.formatter.NotCondition;
import com.cognos.xqe.format.formatter.OrCondition;
import com.cognos.xqe.format.formatter.SearchCondition;
import com.cognos.xqe.format.formatter.SetComparisonCondition;
import com.cognos.xqe.format.formatter.SetPatternCondition;
import com.cognos.xqe.format.formatter.SetTransformation;
import com.cognos.xqe.format.formatter.Transformation;
import com.cognos.xqe.format.formatter.TransformationPass;
import com.cognos.xqe.format.formatter.TypeTransformation;
import com.cognos.xqe.format.formatter.UnaryCondition;
import com.cognos.xqe.format.formatter.UnaryTransformation;
import com.cognos.xqe.format.formatter.ValueCondition;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.xml.stax.ForwardingChildElementIterator;
import com.cognos.xqe.util.xml.stax.IStaxComponentHandler;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.InputStream;
import java.util.Formatter;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class TransformationLibraryParser
implements IStaxComponentHandler {
    private static final String EMPTY_NAMESPACE = "";
    private static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final QName FORMAT_LIBRARY_QNAME = new QName("", "formatLibrary");
    private static final QName DEFAULT_TRANS_LAYER_QNAME = new QName("", "defaultTransformationLayer");
    private static final QName PROPERTY_TRANS_LAYER_QNAME = new QName("", "propertyTransformationLayer");
    private static final QName TYPE_TRANS_LAYER_QNAME = new QName("", "typeTransformationLayer");
    private static final QName EXPRESSION_TRANS_LAYER_QNAME = new QName("", "expressionTransformationLayer");
    private static final QName TRANSFORMATION_QNAME = new QName("", "transformation");
    private static final QName DESCRIPTION_QNAME = new QName("", "description");
    private static final QName FORMAT_TYPE_QNAME = new QName("", "formatType");
    private static final QName ACTION_QNAME = new QName("", "action");
    private static final QName CASE_QNAME = new QName("", "case");
    private static final QName UNARY_CONDITION_QNAME = new QName("", "unaryCondition");
    private static final QName CRITERION_QNAME = new QName("", "criterion");
    private static final QName PROPERTY_QNAME = new QName("", "property");
    private static final String ALWAYS_APPLY_ATTR = "alwaysApply";
    private static final String PASS_NUMBER_ATTR = "passNumber";
    private static final String TARGET_PROPERTY_ATTR = "targetProperty";
    private static final String VALUE_ATTR = "value";
    private static final String TYPE_ATTR = "type";
    private static final String STATE_ATTR = "state";
    private static final String OPERAND_STATE_ATTR = "operandState";
    private static final String COMPARISON_ATTR = "comparison";
    private static final String FIRST_OPERAND_STATE_ATTR = "firstOperandState";
    private static final String SECOND_OPERAND_STATE_ATTR = "secondOperandState";
    private static final String SET_STATE_ATTR = "setState";
    private static final String OPERAND_INDEX_ATTR = "operandIndex";
    private static final String PROPERTY_NAME_ATTR = "propertyName";
    private static final String LOGICAL_OPERATOR_ATTR = "logicalOperator";
    private static final String NAME_ATTR = "name";
    private static final String UNARY_TRANSFORMATION_VAL = "unaryTransformation";
    private static final String BINARY_TRANSFORMATION_VAL = "binaryTransformation";
    private static final String SET_TRANSFORMATION_VAL = "setTransformation";
    private static final String CASE_TRANSFORMATION_VAL = "caseTransformation";
    private static final String TYPE_TRANSFORMATION_VAL = "typeTransformation";
    private static final String ASSIGNMENT_TRANSFORMATION_VAL = "assignmentTransformation";
    private static final String UNARY_CONDITION_VAL = UNARY_CONDITION_QNAME.getLocalPart();
    private static final String BINARY_PATTERN_CONDITION_VAL = "binaryPatternCondition";
    private static final String BINARY_COMPARISON_CONDITION_VAL = "binaryComparisonCondition";
    private static final String SET_PATTERN_CONDITION_VAL = "setPatternCondition";
    private static final String SET_COMPARISON_CONDITION_VAL = "setComparisonCondition";
    private static final String VALUE_CONDITION_VAL = "valueCondition";
    private static final String SEARCH_CONDITION_VAL = "searchCondition";
    private static final String AND_CONDITION_VAL = "andCondition";
    private static final String OR_CONDITION_VAL = "orCondition";
    private static final String NOT_CONDITION_VAL = "notCondition";
    private static final String CORE_LIBRARY_FILE = "/com/cognos/xqe/format/formatter/core.library.xml";
    private static final String LOGMSG_UNKNOWN_TRANSFORMATION_TYPE = "Unknown transformation element type ";
    private static final String LOGMSG_UNEXPECTED_NODE = "Unexpected %s: \"%s\" while parsing '%s' in library %s.";
    private static final String LOGMSG_MISSING_NODE = "Missing %s: \"%s\" while parsing element '%s' in library %s.";
    private static final String LOGMSG_HANDLING_CORE_LIBRARY_FILE = "Handling the core.library.xml file: ";
    private static final String DOT = ".";
    private static final String CONDITION = "condition";
    private static final String ELEMENT = "element";
    private static final String ATTRIBUTE = "attribute";
    private final FormatService mService;
    protected Library currentLibrary;
    protected XMLStreamReader currentReader;

    public TransformationLibraryParser(FormatService service) {
        this.mService = service;
    }

    @Override
    public void consume(XMLStreamReader reader) throws XMLStreamException {
        if (null == this.currentLibrary) {
            return;
        }
        this.currentReader = reader;
        reader.require(1, FORMAT_LIBRARY_QNAME.getNamespaceURI(), FORMAT_LIBRARY_QNAME.getLocalPart());
        ForwardingChildElementIterator libraryLayerIterator = new ForwardingChildElementIterator(reader);
        try {
            libraryLayerIterator.next();
            reader.require(1, DEFAULT_TRANS_LAYER_QNAME.getNamespaceURI(), DEFAULT_TRANS_LAYER_QNAME.getLocalPart());
            ForwardingChildElementIterator defaultLayerItr = new ForwardingChildElementIterator(reader);
            while (defaultLayerItr.next()) {
                Transformation transformation = this.parseTransformation();
                TransformationPass pass = this.currentLibrary.getTransformationPass(transformation.getPassNumber());
                pass.addDefaultTransformation(transformation);
            }
            libraryLayerIterator.next();
            reader.require(1, PROPERTY_TRANS_LAYER_QNAME.getNamespaceURI(), PROPERTY_TRANS_LAYER_QNAME.getLocalPart());
            ForwardingChildElementIterator propertyItr = new ForwardingChildElementIterator(reader);
            while (propertyItr.next()) {
                reader.require(1, PROPERTY_QNAME.getNamespaceURI(), PROPERTY_QNAME.getLocalPart());
                String propertyName = this.parseAttributeValue(PROPERTY_QNAME, NAME_ATTR);
                ForwardingChildElementIterator propertyTransItr = new ForwardingChildElementIterator(reader);
                while (propertyTransItr.next()) {
                    Transformation transformation = this.parseTransformation();
                    TransformationPass pass = this.currentLibrary.getTransformationPass(transformation.getPassNumber());
                    pass.addPropertyTransformation(propertyName, transformation);
                }
            }
            libraryLayerIterator.next();
            reader.require(1, TYPE_TRANS_LAYER_QNAME.getNamespaceURI(), TYPE_TRANS_LAYER_QNAME.getLocalPart());
            ForwardingChildElementIterator typeLayerItr = new ForwardingChildElementIterator(reader);
            if (typeLayerItr.next()) {
                Transformation transformation = this.parseTransformation();
                TransformationPass pass = this.currentLibrary.getTransformationPass(transformation.getPassNumber());
                pass.setDefaultTypeTransformation(transformation);
                StaxUtil.moveToEndElement(reader, TYPE_TRANS_LAYER_QNAME, -1);
            }
            libraryLayerIterator.next();
            reader.require(1, EXPRESSION_TRANS_LAYER_QNAME.getNamespaceURI(), EXPRESSION_TRANS_LAYER_QNAME.getLocalPart());
            ForwardingChildElementIterator expressionItr = new ForwardingChildElementIterator(reader);
            while (expressionItr.next()) {
                String expressionName = this.parseAttributeValue(reader.getName(), NAME_ATTR);
                String expressionTypeStr = this.parseAttributeValue(reader.getName(), TYPE_ATTR);
                this.currentLibrary.setExpressionType(expressionName, ExpressionType.parseExpressionType(expressionTypeStr));
                propertyItr = new ForwardingChildElementIterator(reader);
                while (propertyItr.next()) {
                    if (reader.getName().equals(TRANSFORMATION_QNAME)) {
                        Transformation typeTransformation = this.parseTransformation();
                        TransformationPass pass = this.currentLibrary.getTransformationPass(typeTransformation.getPassNumber());
                        pass.setExpressionTypeTransformation(expressionName, typeTransformation);
                        continue;
                    }
                    reader.require(1, PROPERTY_QNAME.getNamespaceURI(), PROPERTY_QNAME.getLocalPart());
                    String propertyName = this.parseAttributeValue(PROPERTY_QNAME, NAME_ATTR);
                    ForwardingChildElementIterator propertyTransItr = new ForwardingChildElementIterator(reader);
                    while (propertyTransItr.next()) {
                        Transformation transformation = this.parseTransformation();
                        boolean alwaysApply = transformation.getAlwaysApply();
                        TransformationPass pass = this.currentLibrary.getTransformationPass(transformation.getPassNumber());
                        pass.addExpressionTransformation(expressionName, propertyName, transformation, alwaysApply);
                    }
                }
            }
        }
        catch (FormatResourceParsingException e) {
            throw new XMLStreamException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Library loadLibrary(String libraryName) {
        this.currentLibrary = new Library(libraryName);
        InputStream libraryFile = null;
        XQELogger logger = FormatService.FSLOGGER_RESOURCE_PARSING;
        try {
            libraryFile = this.getClass().getResourceAsStream(CORE_LIBRARY_FILE);
        }
        catch (Exception openEx) {
            logger.log(LogLevel.ERROR, LOGMSG_HANDLING_CORE_LIBRARY_FILE, (Throwable)openEx);
            return null;
        }
        XMLStreamReader libraryReader = null;
        try {
            libraryReader = StaxUtil.createXMLStreamReader(libraryFile);
            StaxUtil.moveToElement(libraryReader, FORMAT_LIBRARY_QNAME);
            this.consume(libraryReader);
        }
        catch (Exception ex) {
            logger.log(LogLevel.ERROR, "Exception while parsing the core.format.xml file.");
            logger.log(LogLevel.ERROR, (Throwable)ex);
            Library library = null;
            return library;
        }
        finally {
            if (null != libraryReader) {
                try {
                    libraryReader.close();
                }
                catch (Exception ex) {
                    logger.log(LogLevel.ERROR, LOGMSG_HANDLING_CORE_LIBRARY_FILE, (Throwable)ex);
                    this.currentLibrary = null;
                }
                try {
                    libraryFile.close();
                }
                catch (Exception ex) {
                    logger.log(LogLevel.ERROR, LOGMSG_HANDLING_CORE_LIBRARY_FILE, (Throwable)ex);
                    this.currentLibrary = null;
                }
            }
        }
        return this.currentLibrary;
    }

    public Action parseAction() throws XMLStreamException, FormatResourceParsingException {
        this.currentReader.require(1, ACTION_QNAME.getNamespaceURI(), ACTION_QNAME.getLocalPart());
        String targetProperty = this.currentReader.getAttributeValue(EMPTY_NAMESPACE, TARGET_PROPERTY_ATTR);
        String state = this.parseAttributeValue(this.currentReader.getName(), STATE_ATTR);
        Action.ActionType actionType = Action.ActionType.parseActionType(state);
        StaxUtil.moveToEndElement(this.currentReader, ACTION_QNAME);
        return new Action(actionType, targetProperty);
    }

    public Case parseCase() throws XMLStreamException, FormatResourceParsingException {
        this.currentReader.require(1, CASE_QNAME.getNamespaceURI(), CASE_QNAME.getLocalPart());
        ForwardingChildElementIterator childItr = new ForwardingChildElementIterator(this.currentReader);
        childItr.next();
        String description = null;
        if (this.currentReader.getName().equals(DESCRIPTION_QNAME)) {
            description = this.currentReader.getElementText();
            childItr.next();
        }
        ICondition condition = this.parseCondition();
        LinkedList<Transformation> transformations = new LinkedList<Transformation>();
        while (childItr.next()) {
            transformations.add(this.parseTransformation());
        }
        if (transformations.isEmpty()) {
            throw new FormatResourceParsingException("Cases must contain at least one transformation.");
        }
        return new Case(condition, transformations, description);
    }

    private Criterion parseCriterion() throws XMLStreamException, FormatResourceParsingException {
        this.currentReader.require(1, CRITERION_QNAME.getNamespaceURI(), CRITERION_QNAME.getLocalPart());
        String propertyNameStr = this.parseAttributeValue(CRITERION_QNAME, PROPERTY_NAME_ATTR);
        String comparisonStr = this.parseAttributeValue(CRITERION_QNAME, COMPARISON_ATTR);
        Criterion.CriterionComparisonOperator criterionComparator = Criterion.CriterionComparisonOperator.parseCriterionComparatorEnum(comparisonStr);
        String valueStr = this.parseAttributeValue(CRITERION_QNAME, VALUE_ATTR);
        StaxUtil.moveToEndElement(this.currentReader, CRITERION_QNAME);
        return new Criterion(propertyNameStr, criterionComparator, valueStr);
    }

    public ICondition parseCondition() throws XMLStreamException, FormatResourceParsingException {
        QName conditionElement = this.currentReader.getName();
        if (!conditionElement.getLocalPart().toLowerCase().contains(CONDITION)) {
            Formatter formatter = new Formatter();
            formatter.format(LOGMSG_UNEXPECTED_NODE, ELEMENT, conditionElement.getLocalPart(), CONDITION, this.currentLibrary.getName());
            String sErr = formatter.toString();
            formatter.close();
            throw new FormatResourceParsingException(sErr);
        }
        String conditionType = this.currentReader.getAttributeValue(XSI_NAMESPACE, TYPE_ATTR);
        if (null == conditionType) {
            if (conditionElement.equals(UNARY_CONDITION_QNAME)) {
                conditionType = UNARY_CONDITION_VAL;
            } else {
                Formatter formatter = new Formatter();
                formatter.format(LOGMSG_UNEXPECTED_NODE, ELEMENT, conditionElement.getLocalPart(), CONDITION, this.currentLibrary.getName());
                String sErr = formatter.toString();
                formatter.close();
                throw new FormatResourceParsingException(sErr);
            }
        }
        ICondition condition = null;
        if (conditionType.equals(UNARY_CONDITION_VAL)) {
            String operandTypeStr = this.parseAttributeValue(conditionElement, OPERAND_STATE_ATTR);
            UnaryCondition.UnaryOperandState state = UnaryCondition.UnaryOperandState.parseUnaryOperandState(operandTypeStr);
            condition = new UnaryCondition(state);
            StaxUtil.moveToEndElement(this.currentReader, conditionElement);
        } else if (conditionType.equals(BINARY_COMPARISON_CONDITION_VAL)) {
            String comparisonStr = this.parseAttributeValue(conditionElement, COMPARISON_ATTR);
            BinaryComparisonCondition.BinaryComparatorEnum comparator = BinaryComparisonCondition.BinaryComparatorEnum.parseBinaryComparatorEnum(comparisonStr);
            condition = new BinaryComparisonCondition(comparator);
            StaxUtil.moveToEndElement(this.currentReader, conditionElement);
        } else if (conditionType.equals(BINARY_PATTERN_CONDITION_VAL)) {
            String firstOperandStateStr = this.parseAttributeValue(conditionElement, FIRST_OPERAND_STATE_ATTR);
            BinaryPatternCondition.BinaryOperandState firstOperandState = BinaryPatternCondition.BinaryOperandState.parseOperandState(firstOperandStateStr);
            String secondOperandStateStr = this.parseAttributeValue(conditionElement, SECOND_OPERAND_STATE_ATTR);
            BinaryPatternCondition.BinaryOperandState secondOperandState = BinaryPatternCondition.BinaryOperandState.parseOperandState(secondOperandStateStr);
            condition = new BinaryPatternCondition(firstOperandState, secondOperandState);
            StaxUtil.moveToEndElement(this.currentReader, conditionElement);
        } else if (conditionType.equals(SET_COMPARISON_CONDITION_VAL)) {
            String comparisonStr = this.parseAttributeValue(conditionElement, COMPARISON_ATTR);
            SetComparisonCondition.SetComparatorEnum comparator = SetComparisonCondition.SetComparatorEnum.parseSetComparatorEnum(comparisonStr);
            condition = new SetComparisonCondition(comparator);
            StaxUtil.moveToEndElement(this.currentReader, conditionElement);
        } else if (conditionType.equals(SET_PATTERN_CONDITION_VAL)) {
            String setOperandStateStr = this.parseAttributeValue(conditionElement, SET_STATE_ATTR);
            SetPatternCondition.SetOperandState setOperandState = SetPatternCondition.SetOperandState.parseSetOperandState(setOperandStateStr);
            condition = new SetPatternCondition(setOperandState);
            StaxUtil.moveToEndElement(this.currentReader, conditionElement);
        } else if (conditionType.equals(VALUE_CONDITION_VAL)) {
            String operandIndexStr = this.parseAttributeValue(conditionElement, OPERAND_INDEX_ATTR);
            int operandIndex = Integer.parseInt(operandIndexStr);
            if (operandIndex < 0) {
                throw new FormatResourceParsingException("The 'operandIndex' attribute cannot be negative.");
            }
            String propertyNameStr = this.parseAttributeValue(conditionElement, PROPERTY_NAME_ATTR);
            String valueStr = this.parseAttributeValue(conditionElement, VALUE_ATTR);
            condition = new ValueCondition(operandIndex, propertyNameStr, valueStr);
            StaxUtil.moveToEndElement(this.currentReader, conditionElement);
        } else if (conditionType.equals(SEARCH_CONDITION_VAL)) {
            String logicalOperatorStr = this.parseAttributeValue(conditionElement, LOGICAL_OPERATOR_ATTR);
            boolean logicalOperator = "and".equalsIgnoreCase(logicalOperatorStr);
            LinkedList<Criterion> searchCriteria = new LinkedList<Criterion>();
            ForwardingChildElementIterator criterionItr = new ForwardingChildElementIterator(this.currentReader);
            while (criterionItr.next()) {
                Criterion criterion = this.parseCriterion();
                searchCriteria.add(criterion);
            }
            if (searchCriteria.isEmpty()) {
                throw new FormatResourceParsingException("A searchCondition must have at least one search criterion.");
            }
            condition = new SearchCondition(logicalOperator, searchCriteria);
        } else if (conditionType.equals(AND_CONDITION_VAL)) {
            LinkedList<ICondition> innerConditions = new LinkedList<ICondition>();
            ForwardingChildElementIterator condItr = new ForwardingChildElementIterator(this.currentReader);
            while (condItr.next()) {
                innerConditions.add(this.parseCondition());
            }
            if (innerConditions.isEmpty()) {
                throw new FormatResourceParsingException("An andCondition must have at least one nested condition.");
            }
            condition = new AndCondition(innerConditions);
        } else if (conditionType.equals(OR_CONDITION_VAL)) {
            LinkedList<ICondition> innerConditions = new LinkedList<ICondition>();
            ForwardingChildElementIterator condItr = new ForwardingChildElementIterator(this.currentReader);
            while (condItr.next()) {
                innerConditions.add(this.parseCondition());
            }
            if (innerConditions.isEmpty()) {
                throw new FormatResourceParsingException("An orCondition must have at least one nested condition.");
            }
            condition = new OrCondition(innerConditions);
        } else if (conditionType.equals(NOT_CONDITION_VAL)) {
            ForwardingChildElementIterator itr = new ForwardingChildElementIterator(this.currentReader);
            if (itr.next()) {
                ICondition innerCondition = this.parseCondition();
                condition = new NotCondition(innerCondition);
                StaxUtil.moveToEndElement(this.currentReader, conditionElement);
            } else {
                throw new FormatResourceParsingException("A notCondition must have exactly one nested condition.");
            }
        }
        return condition;
    }

    private String parseAttributeValue(QName currentElement, String attribute) throws FormatResourceParsingException {
        String attributeValue = this.currentReader.getAttributeValue(EMPTY_NAMESPACE, attribute);
        if (null == attributeValue) {
            Formatter formatter = new Formatter();
            formatter.format(LOGMSG_MISSING_NODE, ATTRIBUTE, attribute, currentElement.getLocalPart(), this.currentLibrary.getName());
            String sErr = formatter.toString();
            formatter.close();
            throw new FormatResourceParsingException(sErr);
        }
        return attributeValue;
    }

    private Integer parsePassNumber() {
        Integer passNumber = TransformationPass.DEFAULT_PASS_NUMBER;
        String passNumberAttr = this.currentReader.getAttributeValue(EMPTY_NAMESPACE, PASS_NUMBER_ATTR);
        if (null != passNumberAttr) {
            passNumber = Integer.decode(passNumberAttr);
        }
        return passNumber;
    }

    public Transformation parseTransformation() throws XMLStreamException, FormatResourceParsingException {
        Transformation transformation;
        this.currentReader.require(1, TRANSFORMATION_QNAME.getNamespaceURI(), TRANSFORMATION_QNAME.getLocalPart());
        String transformationType = this.currentReader.getAttributeValue(XSI_NAMESPACE, TYPE_ATTR);
        if (null == transformationType) {
            throw new FormatResourceParsingException(LOGMSG_UNKNOWN_TRANSFORMATION_TYPE + transformationType + DOT);
        }
        boolean alwaysApply = false;
        if (null != this.currentReader.getAttributeValue(EMPTY_NAMESPACE, ALWAYS_APPLY_ATTR)) {
            String alwaysApplyStr = this.parseAttributeValue(this.currentReader.getName(), ALWAYS_APPLY_ATTR);
            alwaysApply = Boolean.parseBoolean(alwaysApplyStr);
        }
        Integer passNumber = this.parsePassNumber();
        ForwardingChildElementIterator childElemsItr = new ForwardingChildElementIterator(this.currentReader);
        childElemsItr.next();
        String description = null;
        if (this.currentReader.getName().equals(DESCRIPTION_QNAME)) {
            description = this.currentReader.getElementText();
            childElemsItr.next();
        }
        if (transformationType.equals(UNARY_TRANSFORMATION_VAL)) {
            ICondition condition = this.parseCondition();
            if (!(condition instanceof UnaryCondition) && !(condition instanceof ILogicalCondition)) {
                Formatter formatter = new Formatter();
                formatter.format(LOGMSG_UNEXPECTED_NODE, CONDITION, condition.toString(), transformationType, this.currentLibrary.getName());
                String sErr = formatter.toString();
                formatter.close();
                throw new FormatResourceParsingException(sErr);
            }
            childElemsItr.next();
            Action action = this.parseAction();
            transformation = new UnaryTransformation(this.mService, condition, action, description, alwaysApply, passNumber);
            StaxUtil.moveToEndElement(this.currentReader, TRANSFORMATION_QNAME);
        } else if (transformationType.equals(BINARY_TRANSFORMATION_VAL)) {
            ICondition condition = this.parseCondition();
            if (!(condition instanceof IBinaryCondition) && !(condition instanceof ILogicalCondition)) {
                Formatter formatter = new Formatter();
                formatter.format(LOGMSG_UNEXPECTED_NODE, CONDITION, condition.toString(), transformationType, this.currentLibrary.getName());
                String sErr = formatter.toString();
                formatter.close();
                throw new FormatResourceParsingException(sErr);
            }
            childElemsItr.next();
            Action action = this.parseAction();
            transformation = new BinaryTransformation(this.mService, condition, action, description, alwaysApply, passNumber);
            StaxUtil.moveToEndElement(this.currentReader, TRANSFORMATION_QNAME);
        } else if (transformationType.equals(SET_TRANSFORMATION_VAL)) {
            ICondition condition = this.parseCondition();
            if (!(condition instanceof ISetCondition) && !(condition instanceof ILogicalCondition)) {
                Formatter formatter = new Formatter();
                formatter.format(LOGMSG_UNEXPECTED_NODE, CONDITION, condition.toString(), transformationType, this.currentLibrary.getName());
                String sErr = formatter.toString();
                formatter.close();
                throw new FormatResourceParsingException(sErr);
            }
            childElemsItr.next();
            Action action = this.parseAction();
            transformation = new SetTransformation(this.mService, condition, action, description, alwaysApply, passNumber);
            StaxUtil.moveToEndElement(this.currentReader, TRANSFORMATION_QNAME);
        } else if (transformationType.equals(CASE_TRANSFORMATION_VAL)) {
            LinkedList<Case> cases = new LinkedList<Case>();
            do {
                cases.add(this.parseCase());
            } while (childElemsItr.next());
            transformation = new CaseTransformation(this.mService, cases, description, alwaysApply, passNumber);
        } else if (transformationType.equals(TYPE_TRANSFORMATION_VAL)) {
            LinkedList<String> formatTypeNames = new LinkedList<String>();
            do {
                if (!this.currentReader.getName().equals(FORMAT_TYPE_QNAME)) {
                    Formatter formatter = new Formatter();
                    formatter.format(LOGMSG_UNEXPECTED_NODE, ELEMENT, this.currentReader.getLocalName(), transformationType, this.currentLibrary.getName());
                    String sErr = formatter.toString();
                    formatter.close();
                    throw new FormatResourceParsingException(sErr);
                }
                String type = this.parseAttributeValue(this.currentReader.getName(), TYPE_ATTR);
                formatTypeNames.add(type);
            } while (childElemsItr.next());
            if (formatTypeNames.size() < 2) {
                throw new FormatResourceParsingException("Type transformations must list at least two format types.");
            }
            transformation = new TypeTransformation(this.mService, formatTypeNames, description, alwaysApply, passNumber);
        } else if (transformationType.equals(ASSIGNMENT_TRANSFORMATION_VAL)) {
            String targetProperty = this.currentReader.getAttributeValue(EMPTY_NAMESPACE, TARGET_PROPERTY_ATTR);
            String value = this.parseAttributeValue(this.currentReader.getName(), VALUE_ATTR);
            transformation = new AssignmentTransformation(this.mService, value, targetProperty, description, alwaysApply, passNumber);
            StaxUtil.moveToEndElement(this.currentReader, TRANSFORMATION_QNAME);
        } else {
            throw new FormatResourceParsingException(LOGMSG_UNKNOWN_TRANSFORMATION_TYPE + transformationType + DOT);
        }
        return transformation;
    }
}

