/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.formatter;

import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.formatter.ILogicalCondition;
import com.cognos.xqe.format.formatter.ResultFormatter;
import com.cognos.xqe.format.formatter.ResultFormattingException;
import com.cognos.xqe.trace.LogLevel;

public class ValueCondition
implements ILogicalCondition {
    private int opIndex;
    private String propName;
    private String val;

    public ValueCondition(int operandIndex, String propertyName, String value) {
        this.opIndex = operandIndex;
        this.propName = propertyName;
        this.val = value;
    }

    @Override
    public boolean isMet() {
        FormatPropertyValue operandValue;
        ResultFormatter formatter = FormatService.getInstance().getCurrentFormatter();
        try {
            operandValue = formatter.getOperandProperties(this.opIndex).getPropertyValue(this.propName);
        }
        catch (ResultFormattingException e) {
            FormatService.FSLOGGER_FORMATTER.log(LogLevel.ERROR, "A ResultParsingException occurred while evaluating a ValueCondition.  Verify that the operand index is valid:", (Throwable)e);
            return false;
        }
        if (null == operandValue) {
            return "@notPresent".equals(this.val);
        }
        return operandValue.getStringValue().equals(this.val);
    }

    public int getOperandIndex() {
        return this.opIndex;
    }

    public String getPropertyName() {
        return this.propName;
    }

    public String getValue() {
        return this.val;
    }
}

