/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.string;

import com.cognos.xqe.format.FormatPropertyDefinition;
import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.FormatServiceUtils;
import com.cognos.xqe.format.string.FormatParserType;
import com.cognos.xqe.format.string.IFormatInfo;
import com.cognos.xqe.format.string.IFormatParser;
import com.cognos.xqe.format.string.V5FormatInfo;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.pool.XQESAXReaderPool;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringEscapeUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class V5FormatParser
implements IFormatParser {
    private static final String DOT = ".";
    private static final String AMP_LT = "&lt;";
    private static final String ENC_AMP_LT = "&amp;lt;";
    private static final String LOGMSG_CANNOT_PARSE_V5_STRING = "Could not parse V5 String object ";
    private static final String FORMAT_GROUP_ELEM_NAME = "formatGroup";
    private final FormatService mService;

    public V5FormatParser(FormatService service) {
        this.mService = service;
    }

    @Override
    public Object getFormatCacheKey(IFormatInfo info, Locale locale) {
        boolean isValid = null != info;
        return FormatServiceUtils.generateFormatCacheKey(FormatParserType.V5, isValid, info, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FormatPropertySet parseFormat(IFormatInfo info, Locale locale) throws Exception {
        String oldXml;
        XQELogger spLogger = FormatService.FSLOGGER_STRING_PARSING;
        if (null == info) {
            return null;
        }
        V5FormatInfo v5Info = (V5FormatInfo)info;
        String xml = v5Info.getXMLFormatString();
        if (0 == xml.length()) {
            return new FormatPropertySet(this.mService);
        }
        while ((xml.contains(AMP_LT) || xml.contains(ENC_AMP_LT)) && !(oldXml = xml).equals(xml = StringEscapeUtils.unescapeXml((String)xml))) {
        }
        SAXReader reader = null;
        Document doc = null;
        try {
            reader = XQESAXReaderPool.getInstance().borrowReader();
            doc = reader.read((Reader)new StringReader(xml));
        }
        catch (Exception e) {
            spLogger.log(LogLevel.ERROR, (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    XQESAXReaderPool.getInstance().returnReader(reader);
                }
                catch (Exception e) {
                    spLogger.log(LogLevel.ERROR, (Throwable)e);
                }
            }
        }
        if (null == doc) {
            spLogger.log(LogLevel.ERROR, LOGMSG_CANNOT_PARSE_V5_STRING + xml + DOT);
            return null;
        }
        Element rootElem = doc.getRootElement();
        Element formatGroupElem = null;
        if (FORMAT_GROUP_ELEM_NAME.equalsIgnoreCase(rootElem.getName())) {
            formatGroupElem = rootElem;
        } else {
            formatGroupElem = rootElem.element(FORMAT_GROUP_ELEM_NAME);
            if (formatGroupElem == null) {
                formatGroupElem = this.findFormatGroupElement(rootElem);
            }
            if (formatGroupElem == null) {
                spLogger.log(LogLevel.ERROR, LOGMSG_CANNOT_PARSE_V5_STRING + xml + DOT);
                return null;
            }
        }
        List formatNodes = formatGroupElem.elements();
        for (Element node : formatNodes) {
            String nodeName = node.getName();
            if (null == this.mService.getFormatType(nodeName)) continue;
            FormatPropertySet set = new FormatPropertySet(this.mService);
            set.setFormatType(nodeName);
            List attributes = node.attributes();
            for (Attribute attribute : attributes) {
                String attributeName = attribute.getQualifiedName();
                FormatPropertyValue propVal = FormatPropertyDefinition.createPropertyValue(this.mService, attributeName, attribute.getValue());
                if (null == propVal) continue;
                set.addPropertyValue(propVal);
            }
            return set;
        }
        spLogger.log(LogLevel.ERROR, LOGMSG_CANNOT_PARSE_V5_STRING + xml + DOT);
        return null;
    }

    private Element findFormatGroupElement(Element node) {
        if (FORMAT_GROUP_ELEM_NAME.equalsIgnoreCase(node.getName())) {
            return node;
        }
        List children = node.elements();
        for (Element child : children) {
            Element formatGroupElem = this.findFormatGroupElement(child);
            if (formatGroupElem == null) continue;
            return formatGroupElem;
        }
        return null;
    }
}

