/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.value;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.BooleanFormatPropertyValue;
import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.NumberFormatPropertyValue;
import com.cognos.xqe.format.value.IValueFormatter;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.Currency;
import java.util.Locale;
import java.util.Set;

public class ICUNumberValueFormatter
implements IValueFormatter {
    private static final IntegerValue ZERO = DataValueFactory.createIntegerValue(0);

    @Override
    public String applyFormat(IValue genericValue, FormatPropertySet formatProperties, Locale locale) {
        boolean isInteger;
        FormatPropertyValue zeroStringProperty;
        Value value = (Value)genericValue;
        if (genericValue.isNull()) {
            FormatPropertyValue whenMissingProperty = formatProperties.getPropertyValue("whenMissing");
            if (whenMissingProperty == null) {
                return " ";
            }
            return whenMissingProperty.getStringValue();
        }
        if (value.compareTo(ZERO) == 0 && (zeroStringProperty = formatProperties.getPropertyValue("whenZero")) != null) {
            return zeroStringProperty.getStringValue();
        }
        IDataType dataType = value.getDataType();
        Set<String> propertyNames = formatProperties.getPropertyNames();
        NumberFormat numberFormat = null;
        if (formatProperties.getFormatTypeName().equals("currencyFormat")) {
            String currencyCode = null;
            boolean useCurrencyCode = false;
            for (String propertyName : propertyNames) {
                if (propertyName.equals("currencyCode")) {
                    currencyCode = formatProperties.getPropertyValue(propertyName).getStringValue();
                    continue;
                }
                if (!propertyName.equals("currencyDisplay")) continue;
                String currencyDisplay = formatProperties.getPropertyValue(propertyName).getStringValue();
                useCurrencyCode = currencyDisplay.equals("CODE");
            }
            numberFormat = useCurrencyCode ? NumberFormat.getInstance((Locale)locale, (int)5) : NumberFormat.getCurrencyInstance((Locale)locale);
            if (currencyCode != null) {
                numberFormat.setCurrency(Currency.getInstance(currencyCode));
            }
        } else {
            numberFormat = NumberFormat.getInstance((Locale)locale);
        }
        int decimalSize = -1;
        boolean bl = isInteger = dataType.isInteger() || dataType.isDecimal() && dataType.getScale() == 0;
        if (formatProperties.getFormatTypeName().equals("numberFormat")) {
            if (isInteger) {
                numberFormat.setGroupingUsed(false);
            } else {
                decimalSize = 2;
            }
        }
        for (String propertyName : propertyNames) {
            if (propertyName.equals("useGrouping")) {
                BooleanFormatPropertyValue groupingUsed = (BooleanFormatPropertyValue)formatProperties.getPropertyValue(propertyName);
                numberFormat.setGroupingUsed(groupingUsed.getValue());
                if (groupingUsed.getValue() || !(numberFormat instanceof DecimalFormat)) continue;
                DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
                decimalFormat.setGroupingSize(0);
                continue;
            }
            if (!propertyName.equals("decimalSize")) continue;
            NumberFormatPropertyValue decimalSizePropValue = (NumberFormatPropertyValue)formatProperties.getPropertyValue(propertyName);
            decimalSize = (int)decimalSizePropValue.getValue();
        }
        if (decimalSize != -1) {
            numberFormat.setMinimumFractionDigits(decimalSize);
            numberFormat.setMaximumFractionDigits(decimalSize);
        }
        numberFormat.setRoundingMode(4);
        if (dataType.isInteger()) {
            return numberFormat.format(value.getLong());
        }
        if (dataType.isDecimal()) {
            return numberFormat.format(value.getBigDecimal());
        }
        return numberFormat.format(value.getDouble());
    }

    @Override
    public boolean canApply(IValue value) {
        return value.getDataType().isNumeric() && value instanceof Value;
    }
}

