/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.value;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatPropertyValue;
import com.cognos.xqe.format.NumberFormatPropertyValue;
import com.cognos.xqe.format.value.IValueFormatter;
import java.util.Locale;
import java.util.Set;

public class ICUStringValueFormatter
implements IValueFormatter {
    @Override
    public String applyFormat(IValue genericValue, FormatPropertySet formatProperties, Locale locale) {
        String stringValue;
        Value value = (Value)genericValue;
        if (genericValue.isNull()) {
            FormatPropertyValue whenMissingProperty = formatProperties.getPropertyValue("whenMissing");
            if (whenMissingProperty == null) {
                return " ";
            }
            return whenMissingProperty.getStringValue();
        }
        Set<String> propertyNames = formatProperties.getPropertyNames();
        int maximumCharacters = -1;
        String truncationString = "...";
        for (String propertyName : propertyNames) {
            if (propertyName.equals("truncationString")) {
                FormatPropertyValue truncationStringProperty = formatProperties.getPropertyValue(propertyName);
                if (truncationStringProperty == null) continue;
                truncationString = truncationStringProperty.getStringValue();
                continue;
            }
            if (!propertyName.equals("maximumCharacters")) continue;
            NumberFormatPropertyValue maximumCharactersPropValue = (NumberFormatPropertyValue)formatProperties.getPropertyValue(propertyName);
            maximumCharacters = (int)maximumCharactersPropValue.getValue();
        }
        if (maximumCharacters > 0 && truncationString.length() < maximumCharacters + 1 && (stringValue = value.getString()).length() > maximumCharacters) {
            StringBuilder truncatedString = new StringBuilder();
            truncatedString.append(stringValue.substring(0, maximumCharacters - truncationString.length()));
            truncatedString.append(truncationString);
            return truncatedString.toString();
        }
        return value.getString();
    }

    @Override
    public boolean canApply(IValue value) {
        return value.getDataType().isTextType() && value instanceof Value;
    }
}

