/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.format.value;

import com.cognos.xqe.format.value.DateTimeValueFormatter;
import com.cognos.xqe.format.value.IValueFormatter;
import com.cognos.xqe.format.value.NumberValueFormatter;
import com.cognos.xqe.util.SingletonHelper;
import java.util.HashMap;
import java.util.Map;

public class ValueFormatterManager {
    private Map<String, IValueFormatter> valueFormatterMap;
    private static SingletonHelper<ValueFormatterManager> singletonHelper = new SingletonHelper<ValueFormatterManager>(){

        @Override
        protected ValueFormatterManager newInstance() {
            return new ValueFormatterManager();
        }

        @Override
        protected void releaseImpl(ValueFormatterManager theInstance) {
        }

        @Override
        protected void initializeImpl(ValueFormatterManager theInstance) {
            theInstance.initialize();
        }
    };

    public static ValueFormatterManager getInstance() {
        return singletonHelper.getInstance();
    }

    private void initialize() {
        IValueFormatter valueFormatter = null;
        this.valueFormatterMap = new HashMap<String, IValueFormatter>();
        valueFormatter = new DateTimeValueFormatter();
        this.valueFormatterMap.put("dateTimeFormat", valueFormatter);
        this.valueFormatterMap.put("dateFormat", valueFormatter);
        this.valueFormatterMap.put("timeFormat", valueFormatter);
        valueFormatter = new NumberValueFormatter();
        this.valueFormatterMap.put("numberFormat", valueFormatter);
        this.valueFormatterMap.put("currencyFormat", valueFormatter);
    }

    public IValueFormatter getValueFormatter(String format) {
        return this.valueFormatterMap.get(format);
    }
}

