/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.ArrayValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.function.IFunction;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.ArrayUtil;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;

public abstract class Function
implements IFunction {
    public static final String NULL_STRING = "<null>";
    private String name;
    private String syntacticName;
    private String mangledName;
    private boolean isShareable = true;
    protected IDataType[] argumentTypes;
    protected byte[][] cclArgumentTypes = null;
    private int variableStartIdx = -1;
    private int minParameters;
    private int maxParameters;

    public Function() {
    }

    public Function(String fName, String fSyntacticName) {
        this.name = fName;
        this.syntacticName = fSyntacticName;
    }

    public Function(String fName, String fSyntacticName, byte[][] fArgumentTypes) {
        this(fName, fSyntacticName);
        this.cclArgumentTypes = fArgumentTypes;
    }

    public Function(String fName, String fSyntacticName, byte[][] fArgumentTypes, int fVariableStartIdx) {
        this(fName, fSyntacticName, fArgumentTypes);
        this.variableStartIdx = fVariableStartIdx;
    }

    public Function(String fName, String fSyntacticName, byte[][] fArgumentTypes, int minParms, int maxParms) {
        this(fName, fSyntacticName);
        this.cclArgumentTypes = fArgumentTypes;
        this.minParameters = minParms;
        this.maxParameters = maxParms;
        if (this.minParameters != this.maxParameters) {
            this.variableStartIdx = this.minParameters;
        }
    }

    public Function(String fName, String fSyntacticName, byte[][] fArgumentTypes, boolean fIsSharedFunction) {
        this(fName, fSyntacticName, fArgumentTypes);
        this.isShareable = fIsSharedFunction;
    }

    public Function(String fName, String fSyntacticName, byte[][] fArgumentTypes, boolean fIsSharedFunction, int minParms, int maxParms) {
        this(fName, fSyntacticName, fArgumentTypes, minParms, maxParms);
        this.isShareable = fIsSharedFunction;
    }

    public Function(String fName, String fSyntacticName, byte[][] fArgumentTypes, boolean fIsSharedFunction, int fVariableStartIdx) {
        this(fName, fSyntacticName, fArgumentTypes, fIsSharedFunction);
        this.variableStartIdx = fVariableStartIdx;
    }

    public Function(String fName, String fSyntacticName, IDataType[] fArgumentTypes, boolean fIsSharedFunction, int fVariableStartIdx) {
        this(fName, fSyntacticName);
        byte[][] cclDTypes = new byte[fArgumentTypes.length][];
        for (int i = 0; i < fArgumentTypes.length; ++i) {
            IDataType argType = fArgumentTypes[i];
            byte cclType = argType.getCCLTypeCode();
            if (cclType == 22) {
                if (argType.getSubType() == DataSubType.ANYTYPE) {
                    cclDTypes[i] = DataTypeCode.ALL_TYPES;
                    continue;
                }
                if (argType.getSubType() == DataSubType.NUMERICTYPE) {
                    cclDTypes[i] = DataTypeCode.ALL_NUMERIC_TYPES;
                    continue;
                }
                cclDTypes[i] = DataTypeCode.ALL_CHARACTER_TYPES;
                continue;
            }
            cclDTypes[i] = new byte[]{cclType};
        }
        this.argumentTypes = fArgumentTypes;
        this.cclArgumentTypes = cclDTypes;
        this.variableStartIdx = fVariableStartIdx;
    }

    public Function(String fName, String fSyntacticName, IDataType[] fArgumentTypes, int minParms, int maxParms) {
        this(fName, fSyntacticName);
        byte[][] cclDTypes = new byte[fArgumentTypes.length][1];
        for (int i = 0; i < fArgumentTypes.length; ++i) {
            cclDTypes[i][0] = fArgumentTypes[i].getCCLTypeCode();
        }
        this.argumentTypes = fArgumentTypes;
        this.cclArgumentTypes = cclDTypes;
        this.minParameters = minParms;
        this.maxParameters = maxParms;
        if (this.minParameters != this.maxParameters) {
            this.variableStartIdx = this.minParameters;
        }
    }

    public Function(String fName, String fSyntacticName, IDataType[] fArgumentTypes, boolean fIsShareable, int minParms, int maxParms) {
        this(fName, fSyntacticName, fArgumentTypes, minParms, maxParms);
        this.isShareable = fIsShareable;
    }

    @Override
    public boolean hasSignature(IDataType[] argTypes) {
        return this.validArgumentTypes(argTypes, true);
    }

    @Override
    public boolean hasSignature(IDataType[] argTypes, boolean strict) {
        return this.validArgumentTypes(argTypes, strict);
    }

    @Override
    public IDataType getResultDataType(IDataType[] fArgumentTypes) {
        IDataType result = fArgumentTypes == null || fArgumentTypes.length == 0 ? this.getResultDataTypeImpl(fArgumentTypes) : (this.hasMetadataTypeArguments(fArgumentTypes) && !this.isMetadataTypeArgumentAllowed() ? DataTypeFactory.getDataType((byte)22) : (this.hasVariantTypeArguments(fArgumentTypes) ? DataTypeFactory.getDataType((byte)22) : this.getResultDataTypeImpl(fArgumentTypes)));
        if (result == null) {
            XQELogger log = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryProcessing", LogLevel.WARN);
            if (log.isOn()) {
                StringBuilder parameter = new StringBuilder();
                parameter.append(this.getName());
                parameter.append("(");
                for (int i = 0; i < fArgumentTypes.length; ++i) {
                    if (i > 0) {
                        parameter.append(",");
                    }
                    if (fArgumentTypes[i] == null) {
                        parameter.append(NULL_STRING);
                        continue;
                    }
                    parameter.append(fArgumentTypes[i].getTypeName());
                }
                parameter.append(")");
                log.log(String.format("Unable to process %1$s function locally, will push to DB", parameter.toString()));
            }
            result = DataTypeFactory.getVariantType();
        }
        return result;
    }

    public IDataType[] getArgumentTypes() {
        return this.argumentTypes;
    }

    public boolean hasVariantTypeArguments(IDataType[] fArgumentTypes) {
        for (int i = 0; i < fArgumentTypes.length; ++i) {
            if (fArgumentTypes[i] == null || fArgumentTypes[i].getCCLTypeCode() != 22) continue;
            return true;
        }
        return false;
    }

    public boolean hasMetadataTypeArguments(IDataType[] fArgumentTypes) {
        for (int i = 0; i < fArgumentTypes.length; ++i) {
            if (fArgumentTypes[i] == null || fArgumentTypes[i].getSubType() != DataSubType.METADATATYPE) continue;
            return true;
        }
        return false;
    }

    protected abstract IDataType getResultDataTypeImpl(IDataType[] var1);

    public boolean isMetadataTypeArgumentAllowed() {
        return false;
    }

    public boolean validArgumentTypes(IDataType[] fArgumentTypes) {
        return this.validArgumentTypes(fArgumentTypes, true);
    }

    public boolean validArgumentTypes(IDataType[] fArgumentTypes, boolean strict) {
        try {
            this.validateArgumentTypes(fArgumentTypes, strict);
        }
        catch (XQERuntimeException e) {
            return false;
        }
        return true;
    }

    @Override
    public void validateArgumentTypes(IDataType[] fArgumentTypes) throws XQERuntimeException {
        this.validateArgumentTypes(fArgumentTypes, true);
    }

    public void validateArgumentTypes(IDataType[] fArgumentTypes, boolean strict) throws XQERuntimeException {
        if (this.cclArgumentTypes == null) {
            return;
        }
        boolean isValid = true;
        if (this.variableStartIdx < 0 ? fArgumentTypes.length != this.cclArgumentTypes.length : fArgumentTypes.length < this.variableStartIdx) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidArgumentCount, this.syntacticName.toLowerCase(), Integer.toString(this.cclArgumentTypes.length));
        }
        int k = 0;
        for (int i = 0; i < fArgumentTypes.length && isValid; ++i) {
            if (k > this.cclArgumentTypes.length - 1) {
                k = this.variableStartIdx;
            }
            if (!(isValid = fArgumentTypes[i] == null || fArgumentTypes[i].getCCLTypeCode() == 22 ? true : this.isValidType(fArgumentTypes[i], this.cclArgumentTypes[k], strict))) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidArgumentType, (Object)fArgumentTypes[i].toString(), (Object)(i + 1), (Object)this.syntacticName.toLowerCase());
            }
            ++k;
        }
    }

    @Override
    public void validateArgumentTypesImpl(IDataType[] fArgumentTypes) {
    }

    @Override
    public boolean isShareable() {
        return this.isShareable;
    }

    @Override
    public boolean isUDFunction() {
        return false;
    }

    @Override
    public boolean isDbFunction() {
        return false;
    }

    @Override
    public boolean isScalarFunction() {
        return false;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public boolean isTableFunction() {
        return false;
    }

    @Override
    public boolean isSQLFunction() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNativeName() {
        return this.getName();
    }

    @Override
    public String getMangledName() {
        return this.mangledName;
    }

    public void setMangledName(String theMangledName) {
        this.mangledName = theMangledName;
    }

    public int getArgumentCount() {
        if (this.cclArgumentTypes != null) {
            return this.cclArgumentTypes.length;
        }
        return 0;
    }

    public String toString() {
        return this.getName();
    }

    protected boolean isValidType(IDataType argument, byte[] acceptedTypes) {
        return this.isValidType(argument, acceptedTypes, true);
    }

    protected boolean isValidType(IDataType argument, byte[] acceptedTypes, boolean strict) {
        if (argument == null || argument.getCCLTypeCode() == 22) {
            return true;
        }
        if (!this.isMetadataTypeArgumentAllowed() && argument.getSubType() == DataSubType.METADATATYPE) {
            return false;
        }
        for (int i = 0; i < acceptedTypes.length; ++i) {
            if (argument.getCCLTypeCode() != acceptedTypes[i] && (acceptedTypes[i] != 1 || !ArrayUtil.contains(DataTypeCode.ALL_TEXT_TYPES, argument.getCCLTypeCode())) && (strict || !DataTypeCode.isPromotableTo(argument.getCCLTypeCode(), acceptedTypes[i]))) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getVariableStartIndex() {
        return this.variableStartIdx;
    }

    @Override
    public int getSignatureRank(IDataType[] fArgumentTypes) {
        int rank = 0;
        int k = 0;
        for (int i = 0; i < fArgumentTypes.length; ++i) {
            int value;
            byte acceptedType;
            byte argumentType = fArgumentTypes[i].getCCLTypeCode();
            if (this.variableStartIdx >= 0 && k > this.argumentTypes.length - 1) {
                k = this.variableStartIdx;
            }
            if (argumentType == (acceptedType = this.argumentTypes[k].getCCLTypeCode())) {
                value = 0;
            } else if (ArrayUtil.contains(DataTypeCode.ALL_CHARACTER_TYPES, acceptedType) && ArrayUtil.contains(DataTypeCode.ALL_TYPES_CONVERTIBLE_TO_CHARACTER, argumentType)) {
                value = 1;
            } else {
                value = acceptedType - argumentType;
                if (argumentType == 51 || argumentType == 22 && fArgumentTypes.length == 1) {
                    value = Math.abs(value);
                }
                if (value < 0) {
                    return -1;
                }
            }
            rank += value;
            ++k;
        }
        return rank;
    }

    private static boolean formatIdIsDefined(FormatId formatId) {
        return formatId != null && !formatId.equals(FormatId.INVALID_FORMAT_FID);
    }

    protected void setFormatID(String operationName, Value operand, Value output) {
        this.setFormatID(operationName, operand, output, null, null);
    }

    protected void setFormatID(String operationName, Value operand, Value output, String propertyName, String propertyValue) {
        FormatId operandFormatId = operand.getFormatId();
        if (!Function.formatIdIsDefined(operandFormatId)) {
            return;
        }
        FormatService service = FormatService.getInstance();
        ArrayList<FormatId> operandIds = new ArrayList<FormatId>();
        operandIds.add(operandFormatId);
        Properties externalParameters = new Properties();
        if (propertyName != null && propertyValue != null) {
            externalParameters.setProperty(propertyName, propertyValue);
        }
        output.setFormatId(service.formatResult(operationName, operandIds, externalParameters));
    }

    protected Object getObject(Class<?> clazz, Value value) {
        if (clazz == Short.class || clazz == Short.TYPE) {
            return value.getShort();
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return value.getInteger();
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return value.getLong();
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return Float.valueOf(value.getFloat());
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return value.getDouble();
        }
        if (clazz == BigDecimal.class) {
            return value.getBigDecimal();
        }
        if (clazz == String.class) {
            return value.getString();
        }
        if (clazz == Boolean.class) {
            return value.getBoolean();
        }
        if (clazz == Date.class) {
            return value.getJdbcDate();
        }
        if (clazz == Time.class) {
            return value.getTime();
        }
        if (clazz == Timestamp.class) {
            return value.getTimestamp();
        }
        if (clazz.isArray() && value instanceof ArrayValue) {
            return ((ArrayValue)value).getObject(clazz.getComponentType());
        }
        return value.getObject();
    }
}

