/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.character;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.ITextValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.StringFunction;
import com.cognos.xqe.runtree.XDataContext;
import com.ibm.icu.text.Normalizer;
import java.util.HashMap;
import java.util.Map;

public class Normalize
extends StringFunction {
    public static final String FUNCTION_NAME = "Normalize";
    private static final String NFC = "nfc";
    private static final String NFD = "nfd";
    private static final String NFKC = "nfkc";
    private static final String NFKD = "nfkd";
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TEXT_TYPES, {1, 45}, DataTypeCode.ALL_NUMERIC_TYPES};
    private static Map<String, Normalizer.Mode> icuMode = new HashMap<String, Normalizer.Mode>();

    public Normalize() {
        super(FUNCTION_NAME, ACCEPTED_TYPES, true, 1);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Normalize.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return Normalize.getStringTypeForOlapMetadata(oDataTypes, 0);
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDataType(ACCEPTED_TYPES[argNo][0]);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue output) throws XQERuntimeException {
        int nParameters = pEvaluator.getParameterCount();
        ITextValue input = (ITextValue)pEvaluator.getParameter(context, 0);
        if (input.isNull()) {
            output.setNull();
        } else {
            String normalForm = NFC;
            if (nParameters > 1) {
                IValue nfValue = pEvaluator.getParameter(context, 1);
                normalForm = nfValue.toString().toLowerCase();
            }
            String result = Normalizer.normalize((String)input.getString(), (Normalizer.Mode)icuMode.get(normalForm));
            if (nParameters > 2) {
                Value length = (Value)pEvaluator.getParameter(context, 2);
                result = result.substring(0, length.getInteger());
            }
            ((Value)output).set(result);
        }
    }

    static {
        icuMode.put(NFC, Normalizer.NFC);
        icuMode.put(NFD, Normalizer.NFD);
        icuMode.put(NFKC, Normalizer.NFKC);
        icuMode.put(NFKD, Normalizer.NFKD);
    }
}

