/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.character;

import com.cognos.xqe.ast.sql.SQLTrim;
import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.StringFunction;
import com.cognos.xqe.runtree.XDataContext;

public class Trim
extends StringFunction {
    public static final String FUNCTION_NAME = "Trim";
    public static final int TRAILING = 1;
    public static final int LEADING = 2;
    public static final int BOTH = 3;
    private static final int TRIM_SPEC_TYPES = 0;
    private static final int PAD_CHAR_TYPES = 1;
    private static final int SRC_VAL_TYPES = 2;
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{6}, DataTypeCode.ALL_CHARACTER_TYPES, DataTypeCode.ALL_TEXT_TYPES};

    public Trim() {
        super(FUNCTION_NAME, ACCEPTED_TYPES, true);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Trim.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return Trim.getStringTypeForOlapMetadata(oDataTypes, oDataTypes.length - 1);
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDataType(ACCEPTED_TYPES[argNo][0]);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue output) throws XQERuntimeException {
        int trimSpec = 3;
        String trimChar = " ";
        IValue[] parameters = pEvaluator.getParameters(context);
        Value trimSource = (Value)parameters[parameters.length - 1];
        if (parameters.length == 2) {
            trimSpec = ((SQLTrim)pEvaluator).getTrimSpec().value();
            trimChar = ((TextValue)parameters[0]).getString();
        } else if (parameters.length > 2) {
            trimSpec = ((NumericValue)parameters[0]).getInteger();
            trimChar = ((TextValue)parameters[1]).getString();
        }
        if (trimSource.isNull()) {
            output.setNull();
        } else {
            StringValue trimSource1 = DataValueFactory.createStringValue();
            trimSource1.set(trimSource);
            int charLen = this.charLength(trimChar);
            if (charLen > 1) {
                throw new XQERuntimeException(XQEMessageKeys.DAT_TrimCharacterLengthError, "", trimChar);
            }
            if (trimSpec == 2) {
                ((Value)output).set(trimSource1.lTrim(trimChar));
            } else if (trimSpec == 1) {
                ((Value)output).set(trimSource1.rTrim(trimChar));
            } else if (trimSpec == 3) {
                trimSource1.set(trimSource1.lTrim(trimChar));
                ((Value)output).set(trimSource1.rTrim(trimChar));
            }
        }
    }

    @Override
    public boolean hasSignature(IDataType[] argTypes) {
        boolean result = super.hasSignature(argTypes);
        if (!result && argTypes.length != ACCEPTED_TYPES.length) {
            switch (argTypes.length) {
                case 1: {
                    result = this.isValidType(argTypes[0], ACCEPTED_TYPES[2]);
                    break;
                }
                case 2: {
                    boolean bl = result = this.isValidType(argTypes[0], ACCEPTED_TYPES[0]) && this.isValidType(argTypes[1], ACCEPTED_TYPES[2]);
                    if (result) break;
                    result = this.isValidType(argTypes[0], ACCEPTED_TYPES[1]) && this.isValidType(argTypes[1], ACCEPTED_TYPES[2]);
                    break;
                }
                default: {
                    result = false;
                }
            }
        }
        return result;
    }
}

