/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.conditional;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ScalarFunction;
import com.cognos.xqe.runtree.XDataContext;

public class Coalesce
extends ScalarFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TYPES, DataTypeCode.ALL_TYPES};

    public Coalesce() {
        super("Coalesce", ACCEPTED_TYPES, 1);
    }

    @Override
    public boolean isMetadataTypeArgumentAllowed() {
        return true;
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Coalesce.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        IDataType result = oDataTypes[0];
        for (int i = 1; i < oDataTypes.length; ++i) {
            result = DataTypeComparator.getCompatibleType(result, oDataTypes[i]);
        }
        if (result instanceof StringType) {
            result = DataTypeFactory.getStringType();
        }
        return result;
    }

    @Override
    public void validateArgumentTypesImpl(IDataType[] fArgumentTypes) {
        for (int i = 1; i < fArgumentTypes.length; ++i) {
            if (DataTypeComparator.isComparableTo(fArgumentTypes[0], fArgumentTypes[i])) continue;
            throw new XQERuntimeException(XQEMessageKeys.PLN_IncompatibleArgumentTypes, (Object)fArgumentTypes[0].toString(), (Object)fArgumentTypes[i].toString(), (Object)this.getName().toLowerCase());
        }
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue output) throws XQERuntimeException {
        IValue input = pEvaluator.getParameter(context, 0);
        output.setNull();
        for (int i = 0; i < pEvaluator.getParameterCount(); ++i) {
            input = pEvaluator.getParameter(context, i);
            if (input.isNull()) continue;
            output.copyFrom(input);
            break;
        }
    }
}

