/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.conditional;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ScalarFunction;
import com.cognos.xqe.runtree.XDataContext;

public class SearchedCase
extends ScalarFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{51}, DataTypeCode.ALL_TYPES, DataTypeCode.ALL_TYPES};

    public SearchedCase() {
        super("SearchedCase", ACCEPTED_TYPES, 1);
    }

    @Override
    public boolean isMetadataTypeArgumentAllowed() {
        return true;
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return SearchedCase.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        IDataType result = oDataTypes[oDataTypes.length - 1];
        for (int i = 1; i < oDataTypes.length; i += 2) {
            result = DataTypeComparator.getCompatibleType(result, oDataTypes[i]);
        }
        return result;
    }

    @Override
    public void validateArgumentTypesImpl(IDataType[] fArgumentTypes) {
        IDataType result = fArgumentTypes[fArgumentTypes.length - 1];
        for (int i = 1; i < fArgumentTypes.length; i += 2) {
            if (DataTypeComparator.isComparableTo(result, fArgumentTypes[i])) continue;
            throw new XQERuntimeException(XQEMessageKeys.PLN_IncompatibleArgumentTypes, (Object)result.toString(), (Object)fArgumentTypes[i].toString(), (Object)this.getName().toLowerCase());
        }
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue output) throws XQERuntimeException {
        int nArgs = pEvaluator.getParameterCount();
        int elseResultPos = -1;
        if (nArgs % 2 != 0) {
            elseResultPos = --nArgs;
        }
        for (int i = 0; i < nArgs; i += 2) {
            IValue searchCond = pEvaluator.getParameter(context, i);
            if (searchCond.isNull() || searchCond.compareTo(BooleanValue.TRUE) != 0) continue;
            output.copyFrom(pEvaluator.getParameter(context, i + 1));
            return;
        }
        if (elseResultPos != -1) {
            output.copyFrom(pEvaluator.getParameter(context, elseResultPos));
        } else {
            output.setNull();
        }
    }

    @Override
    public boolean isNullable(boolean[] argNullable) {
        boolean nullable = false;
        int nArgs = argNullable.length;
        if (nArgs % 2 != 0) {
            nullable = argNullable[--nArgs];
        }
        for (int i = 1; i < nArgs && !nullable; i += 2) {
            nullable = argNullable[i];
        }
        return nullable;
    }
}

