/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.json;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.JSONValue;
import com.cognos.xqe.data.values.ObjectValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.json.JSONFunction;
import com.cognos.xqe.runtree.XDataContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import net.minidev.json.JSONObject;

public class JSONDocument
extends JSONFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{45}};

    public JSONDocument() {
        super("JSONDocument", ACCEPTED_TYPES, false);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        boolean isURI = true;
        boolean isJSONDocument = true;
        String input = pEvaluator.getParameter(context, 0).toString();
        ByteArrayInputStream istream = null;
        try {
            URI uri = new URI(input);
            JSONObject connectionInfo = new JSONObject();
            connectionInfo.put((Object)"SUBTYPE", (Object)"Other");
            connectionInfo.put((Object)"METHOD", (Object)"GET");
            connectionInfo.put((Object)"URL", (Object)input);
            connectionInfo.put((Object)"AUTHENTICATION_TYPE", (Object)"NONE");
            ((ObjectValue)outputArg).set(connectionInfo);
        }
        catch (URISyntaxException e) {
            isURI = false;
        }
        try {
            if (!isURI && JSONValue.compliesJSONFormat(input)) {
                istream = new ByteArrayInputStream(input.getBytes());
                ((ObjectValue)outputArg).set(istream);
            }
        }
        catch (IOException e) {
            isJSONDocument = false;
        }
        if (!isJSONDocument && !isURI) {
            throw new XQERuntimeException(XQEMessageKeys.EXE_JSONDOCInvalidInput);
        }
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] ins) {
        return DataTypeFactory.getObjectType();
    }
}

