/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.json;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.bibushandler.CancelRequestSourceEnum;
import com.cognos.xqe.bibushandler.CancelUnsuccessfulException;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.json.JSONReader;
import com.cognos.xqe.data.json.JSONReaderFactory;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MultisetType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.data.types.StructType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.MultisetValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.StructValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.TableFunction;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.relational.XTableFunction;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqe.util.json.JsonPathUtils;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class JSONTable
extends TableFunction {
    public static final String FOR_ORDINALITY = "FOR ORDINALITY";
    private static final byte[][] ACCEPTED_TYPES = new byte[][]{{45}, {45, 114}, DataTypeCode.ALL_TYPES};
    protected JSONCancelHandler cancelHandler = null;

    public JSONTable() {
        super("JSONTable", ACCEPTED_TYPES, true);
    }

    @Override
    protected IDataType getResultDataTypeImpl(IDataType[] argumentTypes) {
        return DataTypeFactory.getRowType();
    }

    @Override
    public ITabularResultSet execute(XDataContext context, IParameterEvaluator pEvaluator, IRowsetInfo rowsetInfo) {
        return new JSONTableResultSet(context, pEvaluator, rowsetInfo);
    }

    private final class JSONTableResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        protected boolean bCanceled;
        private XTableFunction xNode;
        private int nParameters;
        private int baseIndex;
        private JsonPath[] jsonPath;
        private XVectorContext vContext;
        private IHybridResultSet[] nestedResultSets;
        private int[] nestedJsonPathIndexes;
        private SQLAbstractFunction.OnErrorPolicy onErrorPolicy;

        JSONTableResultSet(XDataContext context, IParameterEvaluator parameterEvaluator, IRowsetInfo theRowsetInfo) {
            int i;
            super(context, context.getNodeId());
            this.bCanceled = false;
            this.onErrorPolicy = SQLAbstractFunction.OnErrorPolicy.NULL;
            ArrayList<Integer> nestedJsonPathIndexesArrayList = new ArrayList<Integer>();
            ArrayList<IHybridResultSet> nestedResultSetsArrayList = new ArrayList<IHybridResultSet>();
            this.xNode = (XTableFunction)parameterEvaluator;
            this.rowsetInfo = theRowsetInfo;
            this.nParameters = parameterEvaluator.getParameterCount();
            this.baseIndex = this.xNode.isNested() ? 1 : 2;
            this.jsonPath = new JsonPath[this.nParameters - this.baseIndex];
            for (i = 0; i < this.nParameters - this.baseIndex; ++i) {
                IXQEQueryNode currentChild = this.xNode.getChild(i + this.baseIndex);
                if (currentChild instanceof XTableFunction) {
                    XTableFunction currentXNode = (XTableFunction)currentChild;
                    nestedResultSetsArrayList.add((IHybridResultSet)currentXNode.execute(context));
                    this.jsonPath[i] = JsonPath.compile((String)currentXNode.getParameter(context, 0).toString(), (Predicate[])new Predicate[0]);
                    nestedJsonPathIndexesArrayList.add(i);
                    continue;
                }
                String literalValue = this.xNode.getParameter(context, this.baseIndex + i).toString();
                if (literalValue.equalsIgnoreCase(JSONTable.FOR_ORDINALITY)) continue;
                this.jsonPath[i] = JsonPath.compile((String)literalValue, (Predicate[])new Predicate[0]);
            }
            this.nestedJsonPathIndexes = new int[nestedJsonPathIndexesArrayList.size()];
            for (i = 0; i < nestedJsonPathIndexesArrayList.size(); ++i) {
                this.nestedJsonPathIndexes[i] = (Integer)nestedJsonPathIndexesArrayList.get(i);
            }
            this.nestedResultSets = nestedResultSetsArrayList.toArray(new IHybridResultSet[nestedResultSetsArrayList.size()]);
            JSONTable.this.cancelHandler = new JSONCancelHandler(this);
            context.getEnvironment().getCancelManager().addCancelHandler(JSONTable.this.cancelHandler);
            this.vContext = this.xNode.getVectorizationContext();
            if (this.xNode.getOnErrorPolicy() != null) {
                this.onErrorPolicy = this.xNode.getOnErrorPolicy();
            }
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new JSONTableIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
            super.release();
            for (int i = 0; i < this.nestedResultSets.length; ++i) {
                this.nestedResultSets[i].release();
            }
        }

        public boolean isCanceled() {
            return this.bCanceled;
        }

        public boolean canBeCanceled() {
            return !this.isCanceled();
        }

        public void setCanceled(boolean cancelled) {
            this.bCanceled = cancelled;
        }

        public boolean cancelImpl() {
            return true;
        }

        private final class JSONTableIterator
        extends XVectorTabularIterator {
            private RowValue row;
            private RowValue intermediateRow;
            private JSONReader jReader;
            private JSONArray nestedCache;
            private IPooledConnection pooledConnection;
            private boolean eod;
            private JSONTableIterator[] nestedTabIterators;
            private boolean intermediateResultsStage;
            private int recordId;
            private int iteratorId;
            private int ordinality;
            private boolean intermediateRowChanged;
            private FlatteningPolicy flatteningPolicy;

            private JSONTableIterator(XDataContext context) {
                XQEConfiguration config;
                String policyValue;
                super(context, context.getNodeId(), JSONTableResultSet.this.rowsetInfo);
                this.intermediateResultsStage = true;
                this.recordId = 0;
                this.iteratorId = 0;
                this.ordinality = 0;
                this.intermediateRowChanged = false;
                this.flatteningPolicy = FlatteningPolicy.FULL_OUTER_JOIN;
                if (!JSONTableResultSet.this.xNode.isNested()) {
                    IValue content = JSONTableResultSet.this.xNode.getParameter(context, 0);
                    String pathExpr = JSONTableResultSet.this.xNode.getParameter(context, 1).toString();
                    AbstractConnection connection = null;
                    IDataSource dataSource = JSONTableResultSet.this.xNode.getDataSource();
                    if (dataSource != null) {
                        this.pooledConnection = ConnectionUtil.getPooledConnection(context.getEnvironment(), dataSource);
                        connection = (AbstractConnection)this.pooledConnection.getConnection();
                    }
                    this.jReader = JSONReaderFactory.create(connection, content, pathExpr);
                }
                this.row = DataValueFactory.createRowValue(context.getLocalCollator(), JSONTableResultSet.this.rowsetInfo);
                this.intermediateRow = DataValueFactory.createRowValue(context.getLocalCollator(), JSONTableResultSet.this.rowsetInfo);
                this.nestedTabIterators = new JSONTableIterator[JSONTableResultSet.this.nestedResultSets.length];
                if (JSONTableResultSet.this.vContext != null) {
                    this.batch = XVectorRowBatchUtil.createRowBatch(JSONTableResultSet.this.vContext, JSONTableResultSet.this.rowsetInfo, context.getLocalCollator());
                }
                if ((policyValue = (config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE)).getStringProperty("queryExecution.JSON.flatteningPolicy[@value]", "")).equalsIgnoreCase(FlatteningPolicy.NESTED_LOOP_JOIN.getPolicy())) {
                    this.flatteningPolicy = FlatteningPolicy.NESTED_LOOP_JOIN;
                }
            }

            @Override
            public Object nextImpl() {
                if (JSONTableResultSet.this.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (this.intermediateResultsStage && !this.populateIntermediateResultsRow()) {
                    return null;
                }
                if (this.flatteningPolicy == FlatteningPolicy.FULL_OUTER_JOIN) {
                    return this.flattenedRowUsingFOJ();
                }
                return this.flattenedRowUsingNLJ();
            }

            private Object flattenedRowUsingFOJ() {
                this.row.copyFrom(this.intermediateRow);
                this.iteratorId = 0;
                int columnId = 0;
                int nestedResultSetsId = 0;
                boolean nestedResultsExhausted = true;
                for (int i = 0; i < JSONTableResultSet.this.jsonPath.length; ++i) {
                    if (JSONTableResultSet.this.jsonPath[i] == null) {
                        ((Value)this.row.getColumn(columnId)).set(this.ordinality + 1);
                        ++columnId;
                        continue;
                    }
                    if (this.isNestedPathIndex(i)) {
                        int nestedColumnSize = JSONTableResultSet.this.nestedResultSets[nestedResultSetsId].getTabularRowsetInfo().getNumColumns();
                        Object o = null;
                        if (this.nestedTabIterators[this.iteratorId] != null) {
                            o = this.nestedTabIterators[this.iteratorId].nextImpl();
                        }
                        if (o != null) {
                            RowValue retrievedValue = (RowValue)o;
                            for (int j = 0; j < nestedColumnSize; ++j) {
                                ((Value)this.row.getColumn(columnId + j)).set(retrievedValue.getColumn(j));
                            }
                            nestedResultsExhausted = false;
                        } else if (this.nestedTabIterators[this.iteratorId] != null) {
                            this.nestedTabIterators[this.iteratorId].release();
                            this.nestedTabIterators[this.iteratorId] = null;
                        }
                        ++this.iteratorId;
                        columnId += nestedColumnSize;
                        ++nestedResultSetsId;
                        continue;
                    }
                    ++columnId;
                }
                if (nestedResultsExhausted && !this.intermediateRowChanged) {
                    if (!this.populateIntermediateResultsRow()) {
                        return null;
                    }
                    return this.nextImpl();
                }
                this.intermediateRowChanged = false;
                ++this.ordinality;
                ++this.nRows;
                return this.row;
            }

            private Object flattenedRowUsingNLJ() {
                this.row.copyFrom(this.intermediateRow);
                int columnId = 0;
                int nestedResultSetsId = 0;
                for (int i = 0; i < JSONTableResultSet.this.jsonPath.length; ++i) {
                    if (JSONTableResultSet.this.jsonPath[i] == null) {
                        ((Value)this.row.getColumn(columnId)).set(this.ordinality + 1);
                        ++columnId;
                        continue;
                    }
                    if (this.isNestedPathIndex(i)) {
                        int nestedColumnSize = JSONTableResultSet.this.nestedResultSets[nestedResultSetsId].getTabularRowsetInfo().getNumColumns();
                        if (nestedResultSetsId == this.iteratorId) {
                            Object o = null;
                            if (this.nestedTabIterators[this.iteratorId] != null) {
                                o = this.nestedTabIterators[this.iteratorId].nextImpl();
                            }
                            if (o != null) {
                                RowValue retrievedValue = (RowValue)o;
                                for (int j = 0; j < nestedColumnSize; ++j) {
                                    ((Value)this.row.getColumn(columnId + j)).set(retrievedValue.getColumn(j));
                                }
                            } else {
                                if (this.nestedTabIterators[this.iteratorId] != null) {
                                    this.nestedTabIterators[this.iteratorId].release();
                                    this.nestedTabIterators[this.iteratorId] = null;
                                }
                                ++this.iteratorId;
                                if (this.iteratorId == this.nestedTabIterators.length) {
                                    this.iteratorId = 0;
                                    if (!this.intermediateRowChanged) {
                                        if (!this.populateIntermediateResultsRow()) {
                                            return null;
                                        }
                                        return this.nextImpl();
                                    }
                                }
                            }
                        }
                        columnId += nestedColumnSize;
                        ++nestedResultSetsId;
                        continue;
                    }
                    ++columnId;
                }
                this.intermediateRowChanged = false;
                ++this.ordinality;
                ++this.nRows;
                return this.row;
            }

            @Override
            public Object nextBatch() {
                if (JSONTableResultSet.this.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.batch.reset();
                if (this.eod) {
                    this.batch.eod = true;
                    return this.batch;
                }
                while (this.batch.size != this.batch.maxBatchSize && !this.eod) {
                    Object record = this.nextImpl();
                    if (record == null) {
                        this.eod = true;
                        break;
                    }
                    RowValue rowValue = (RowValue)record;
                    for (int i = 0; i < rowValue.getNumColumns(); ++i) {
                        IValue v = rowValue.getColumn(i);
                        ColumnVector vector = this.batch.columns[i];
                        if (v.getDataType().getCCLTypeCode() == 51) {
                            ((LongColumnVector)vector).set(this.batch.size, ((BooleanValue)v).getLong());
                            continue;
                        }
                        vector.assign(this.batch.size, v);
                    }
                    ++this.batch.size;
                }
                return this.batch;
            }

            private boolean populateIntermediateResultsRow() {
                Object record;
                if (JSONTableResultSet.this.xNode.isNested()) {
                    if (this.recordId >= this.nestedCache.size()) {
                        this.intermediateRowChanged = false;
                        this.eod = true;
                        return false;
                    }
                    record = this.nestedCache.get(this.recordId);
                    this.intermediateRowChanged = true;
                    ++this.recordId;
                } else {
                    if (!this.jReader.hasNext()) {
                        this.intermediateRowChanged = false;
                        this.eod = true;
                        return false;
                    }
                    record = this.jReader.next();
                    this.intermediateRowChanged = true;
                    this.ordinality = 0;
                }
                int columnId = 0;
                int nestedResultSetsId = 0;
                for (int i = 0; i < JSONTableResultSet.this.jsonPath.length; ++i) {
                    if (this.isNestedPathIndex(i)) {
                        JSONArray jsonArray;
                        block15: {
                            jsonArray = null;
                            try {
                                jsonArray = (JSONArray)JsonPathUtils.read(record, JSONTableResultSet.this.jsonPath[i]);
                            }
                            catch (RuntimeException e) {
                                if (JSONTableResultSet.this.onErrorPolicy != SQLAbstractFunction.OnErrorPolicy.ERROR) break block15;
                                this.release();
                                throw e;
                            }
                        }
                        if (jsonArray == null) {
                            jsonArray = new JSONArray();
                        }
                        if (this.nestedTabIterators[nestedResultSetsId] == null) {
                            this.nestedTabIterators[nestedResultSetsId] = (JSONTableIterator)JSONTableResultSet.this.nestedResultSets[nestedResultSetsId].getTabularIterator();
                        }
                        this.nestedTabIterators[nestedResultSetsId].nestedCache = jsonArray;
                        this.nestedTabIterators[nestedResultSetsId].flatteningPolicy = this.flatteningPolicy;
                        int nestedColumnSize = JSONTableResultSet.this.nestedResultSets[nestedResultSetsId].getTabularRowsetInfo().getNumColumns();
                        for (int j = 0; j < nestedColumnSize; ++j) {
                            IValue v = this.intermediateRow.getColumn(columnId + j);
                            v.setNull();
                        }
                        columnId += nestedColumnSize;
                        ++nestedResultSetsId;
                        continue;
                    }
                    if (JSONTableResultSet.this.jsonPath[i] != null) {
                        Object jObj;
                        IDataType dType;
                        Value v;
                        block16: {
                            v = (Value)this.intermediateRow.getColumn(columnId);
                            dType = v.getDataType();
                            jObj = null;
                            try {
                                jObj = JsonPathUtils.read(record, JSONTableResultSet.this.jsonPath[i]);
                            }
                            catch (RuntimeException e) {
                                if (JSONTableResultSet.this.onErrorPolicy != SQLAbstractFunction.OnErrorPolicy.ERROR) break block16;
                                this.release();
                                throw e;
                            }
                        }
                        this.getValue(jObj, dType, v);
                        ++columnId;
                        continue;
                    }
                    ++columnId;
                }
                if (!JSONTableResultSet.this.xNode.isFlatTableFunction()) {
                    this.intermediateResultsStage = false;
                }
                return true;
            }

            private boolean isNestedPathIndex(int index) {
                for (int i = 0; i < JSONTableResultSet.this.nestedJsonPathIndexes.length; ++i) {
                    if (index != JSONTableResultSet.this.nestedJsonPathIndexes[i]) continue;
                    return true;
                }
                return false;
            }

            private void getValue(Object jObj, IDataType dType, Value value) {
                if (jObj == null) {
                    value.setNull();
                } else if (dType.getCCLTypeCode() == 102) {
                    value.set(((JSONArray)jObj).toArray());
                } else if (dType.getCCLTypeCode() == 104) {
                    this.getStructValue((JSONObject)jObj, (StructType)value.getDataType(), (StructValue)value);
                } else if (dType.getCCLTypeCode() == 103) {
                    this.getMultisetValue(jObj, (MultisetType)value.getDataType(), (MultisetValue)value);
                } else {
                    try {
                        value.set(jObj);
                    }
                    catch (RuntimeException e) {
                        if (SQLAbstractFunction.OnErrorPolicy.ERROR == JSONTableResultSet.this.onErrorPolicy) {
                            throw e;
                        }
                        value.setNull();
                    }
                }
            }

            private void getStructValue(JSONObject jMap, StructType dType, StructValue sValue) {
                for (int j = 0; j < dType.getNumberColumns(); ++j) {
                    Value value = (Value)sValue.getColumnForUpdate(j);
                    Object jObj = jMap.get((Object)dType.getFieldName(j));
                    this.getValue(jObj, dType.getFieldDataType(j), value);
                }
            }

            private void getMultisetValue(Object jObject, MultisetType dType, MultisetValue multisetValue) {
                multisetValue.clear();
                RowType elementType = (RowType)dType.getElementType();
                if (jObject instanceof JSONObject) {
                    this.getMultisetElement((JSONObject)jObject, elementType, multisetValue);
                } else {
                    JSONArray jArray = (JSONArray)jObject;
                    for (int i = 0; i < jArray.size(); ++i) {
                        this.getMultisetElement((JSONObject)jArray.get(i), elementType, multisetValue);
                    }
                }
            }

            private void getMultisetElement(JSONObject jMap, RowType elementType, MultisetValue multisetValue) {
                RowValue rowValue = (RowValue)elementType.createValue();
                for (int j = 0; j < elementType.getNumberColumns(); ++j) {
                    Value value = (Value)rowValue.getColumnForUpdate(j);
                    Object jObj = jMap.get((Object)elementType.getFieldName(j));
                    this.getValue(jObj, elementType.getFieldDataType(j), value);
                }
                multisetValue.add(rowValue);
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public void release() {
                super.release();
                if (this.jReader != null) {
                    this.jReader.release();
                }
                if (this.pooledConnection != null) {
                    this.pooledConnection.returnConnection();
                }
            }
        }
    }

    public class JSONCancelHandler
    implements ICancelable {
        JSONTableResultSet resultSet;

        public JSONCancelHandler(JSONTableResultSet rs) {
            this.resultSet = rs;
        }

        @Override
        public void cancel() {
            if (this.resultSet.canBeCanceled()) {
                this.resultSet.setCanceled(true);
                if (!this.resultSet.cancelImpl()) {
                    throw new CancelUnsuccessfulException();
                }
            }
        }

        @Override
        public void cancel(CancelRequestSourceEnum cancelSource) {
            throw new CancelUnsuccessfulException();
        }
    }

    public static enum FlatteningPolicy {
        FULL_OUTER_JOIN("FOJ"),
        NESTED_LOOP_JOIN("NLJ");

        private String policy;

        private FlatteningPolicy(String approach) {
            this.policy = approach;
        }

        public String getPolicy() {
            return this.policy;
        }
    }
}

