/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.numeric;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.SmallintValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.NumericFunction;
import com.cognos.xqe.runtree.XDataContext;

public class Round
extends NumericFunction {
    private static final String ROUNDING_PRECISION = "roundingPrecision";
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_NUMERIC_TYPES, {4, 6}, {4}};

    public Round() {
        super("Round", ACCEPTED_TYPES, 1);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Round.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        if (oDataTypes[0] == null) {
            return null;
        }
        IDataType oDataType = oDataTypes[0];
        byte cclType = oDataType.getCCLTypeCode();
        if ((cclType == 12 || cclType == 54) && oDataType.getPrecision() != 0) {
            int precision = Math.min(oDataType.getPrecision() + 1, 256);
            int scale = oDataType.getScale();
            oDataType = DataTypeFactory.getDataType(cclType, precision, scale);
        }
        return oDataType;
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDataType(ACCEPTED_TYPES[argNo][0]);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        int nArgs = pEvaluator.getParameterCount();
        NumericValue output = (NumericValue)outputArg;
        IValue input = pEvaluator.getParameter(context, 0);
        if (input.isNull()) {
            output.setNull();
            return;
        }
        NumericValue numberToRound = (NumericValue)input;
        int precision = 0;
        SmallintValue rndtype = DataValueFactory.createSmallintValue();
        rndtype.set(0);
        if (nArgs >= 2) {
            precision = ((NumericValue)pEvaluator.getParameter(context, 1)).getInteger();
        }
        if (nArgs > 2) {
            rndtype = (SmallintValue)pEvaluator.getParameter(context, 2);
        }
        output.set(numberToRound);
        switch (rndtype.getInteger()) {
            case 0: {
                output.round(precision);
                this.setFormatID("Round", numberToRound, output, ROUNDING_PRECISION, Integer.toString(precision));
                break;
            }
            case 1: {
                output.roundUp(precision);
                this.setFormatID("Round", numberToRound, output, ROUNDING_PRECISION, Integer.toString(precision));
                break;
            }
            case 2: {
                output.roundDown(precision);
                this.setFormatID("Round", numberToRound, output, ROUNDING_PRECISION, Integer.toString(precision));
                break;
            }
            case 3: {
                output.trunc(precision);
                this.setFormatID("Round", numberToRound, output, ROUNDING_PRECISION, Integer.toString(precision));
                break;
            }
        }
    }
}

