/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.numeric;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ScalarFunction;
import com.cognos.xqe.runtree.XDataContext;

public class Tan
extends ScalarFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_NUMERIC_TYPES};

    public Tan() {
        super("TAN", ACCEPTED_TYPES);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Tan.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return DataTypeFactory.getDoubleType();
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getSmallintType();
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        Value input = (Value)pEvaluator.getParameter(context, 0);
        if (!input.isOK()) {
            ((Value)outputArg).setState(input.getState());
            return;
        }
        double result = StrictMath.tan(input.getDouble());
        ((Value)outputArg).set(result);
    }
}

