/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.operator;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.NumericFunction;
import com.cognos.xqe.runtree.XDataContext;

public class Mod
extends NumericFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_NUMERIC_TYPES, DataTypeCode.ALL_NUMERIC_TYPES};

    public Mod() {
        this("Mod");
    }

    public Mod(String fName) {
        super(fName, ACCEPTED_TYPES);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Mod.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        if (oDataTypes[0] == null) {
            return null;
        }
        boolean dividendBaseTypeIsApproximateNumeric = oDataTypes[0].isApproximateNumeric();
        if (dividendBaseTypeIsApproximateNumeric) {
            return oDataTypes[0];
        }
        boolean divisorBaseTypeIsApproximateNumeric = oDataTypes[1].isApproximateNumeric();
        if (dividendBaseTypeIsApproximateNumeric == divisorBaseTypeIsApproximateNumeric) {
            return oDataTypes[0];
        }
        return oDataTypes[1];
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDataType(ACCEPTED_TYPES[argNo][0]);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        NumericValue output = (NumericValue)outputArg;
        IValue input1 = pEvaluator.getParameter(context, 0);
        IValue input2 = pEvaluator.getParameter(context, 1);
        if (input1.isNull() || input2.isNull()) {
            output.setNull();
        } else {
            output.set(input1);
            output.mod(input2);
        }
    }
}

