/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.regex;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.StringFunction;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.StringSubstitutionEngine;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.adapters.dom.DOMAdapter;
import com.ibm.xml.xci.exec.BasicMutableDynamicContext;
import com.ibm.xml.xci.exec.BasicStaticContext;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.Preparer;
import com.ibm.xml.xci.exec.StaticContext;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SubstringRegex
extends StringFunction {
    public static final String FUNCTION_NAME = "SubstringRegex";
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TEXT_TYPES, DataTypeCode.ALL_TEXT_TYPES, {6, 8, 2, 4, 12, 10, 11, 107}, {6, 8, 2, 4, 12, 10, 11, 107}, DataTypeCode.ALL_TEXT_TYPES};
    private static final int PATTERN_IDX = 0;
    private static final int INPUT_IDX = 1;
    private static final int FROM_IDX = 2;
    private static final int OCCURRENCE_IDX = 3;
    public static final int FLAG_IDX = 4;
    public static final String SCRIPT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xsl:stylesheet version=\"2.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">  <xsl:output indent=\"yes\" method=\"xml\"/>  <xsl:param name=\"regex\" as=\"xs:string\"/>  <xsl:param name=\"flags\" as=\"xs:string\"/>  <xsl:template match=\"/\">    <xsl:analyze-string select=\"source\" regex=\"{$regex}\" flags=\"{$flags}\">      <xsl:matching-substring>        <match>          <xsl:value-of select=\".\"/>        </match>      </xsl:matching-substring>      <xsl:non-matching-substring/>    </xsl:analyze-string>  </xsl:template></xsl:stylesheet>";
    private static QName regex = new QName("regex");
    private static QName flags = new QName("flags");
    private SessionContext session = new SessionContext((ClassLoader)null);
    private CursorFactory factory = this.session.getSimpleDataFactory();
    private StaticContext staticCxt = new BasicStaticContext(this.session.getTypeRegistry());
    private Executable xsltExec;

    public SubstringRegex() {
        super(FUNCTION_NAME, ACCEPTED_TYPES, false, 2);
        this.staticCxt.setLanguageTypeAndVersion(5);
        this.staticCxt.setBaseURI(System.getProperty("user.dir"));
        Preparer preparer = this.session.getPreparer(RequestInfo.XSLT2);
        this.xsltExec = preparer.prepare(SCRIPT, this.staticCxt, -1);
    }

    @Override
    public void execute(XDataContext context, IParameterEvaluator pEvaluator, IValue outputArg) throws XQERuntimeException {
        Value output = (Value)outputArg;
        int nParameters = pEvaluator.getParameterCount();
        Value pattern = (Value)pEvaluator.getParameter(context, 0);
        Value input = (Value)pEvaluator.getParameter(context, 1);
        if (input.isNull() || pattern.isNull()) {
            output.setNull();
            return;
        }
        int fromPos = 1;
        int matchOcc = 1;
        String flagStr = "";
        if (nParameters > 2) {
            Value from = (Value)pEvaluator.getParameter(context, 2);
            if (from.isNull()) {
                output.setNull();
                return;
            }
            fromPos = from.getInteger();
        }
        if (nParameters > 3) {
            Value occurrence = (Value)pEvaluator.getParameter(context, 3);
            if (occurrence.isNull()) {
                output.setNull();
                return;
            }
            matchOcc = occurrence.getInteger();
        }
        if (nParameters > 4) {
            Value flag = (Value)pEvaluator.getParameter(context, 4);
            if (flag.isNull()) {
                output.setNull();
                return;
            }
            flagStr = flag.getString();
        }
        String source = StringSubstitutionEngine.escapeString(input.getString());
        if (fromPos > 1) {
            source = source.substring(fromPos - 1);
        }
        source = String.format("<source>%s</source>", source);
        BasicMutableDynamicContext dynamicCxt = new BasicMutableDynamicContext(this.session, this.staticCxt);
        dynamicCxt.bindVariable(regex, this.factory.sequence((CharSequence)pattern.getString(), null, false));
        dynamicCxt.bindVariable(flags, this.factory.sequence((CharSequence)flagStr, null, false));
        RequestInfo request = new RequestInfo(Cursor.RANDOM_ACCESS, this.staticCxt);
        StreamSource document = new StreamSource(new StringReader(source));
        Cursor contextDoc = this.session.document((Source)document, request);
        DOMAdapter.DOMCursor result = (DOMAdapter.DOMCursor)this.xsltExec.execute(contextDoc, (DynamicContext)dynamicCxt, Cursor.RANDOM_ACCESS, null);
        if (result == null) {
            output.setNull();
            return;
        }
        NodeList nodeList = result.getNode().getChildNodes();
        if (matchOcc > nodeList.getLength()) {
            output.setNull();
        } else {
            Node node = nodeList.item(matchOcc - 1);
            output.set(node.getTextContent());
        }
        result.release();
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return SubstringRegex.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return SubstringRegex.getStringTypeForOlapMetadata(oDataTypes, 1);
    }

    public static IDataType getParameterType(int argNo) {
        return DataTypeFactory.getDataType(ACCEPTED_TYPES[argNo][1]);
    }
}

