/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.function.DistinctSetFunctionState;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.function.operator.Add;
import com.cognos.xqe.function.set.SetFunctionsFormatManager;
import com.cognos.xqe.runtree.XDataContext;

public class Difference
extends SetFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{4, 6, 8, 10, 11, 12}};

    public Difference() {
        super("Difference", ACCEPTED_TYPES, false);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(context, type, this.isDistinct());
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Difference.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return Add.getOutputType(new IDataType[]{oDataTypes[0], oDataTypes[0]});
    }

    public static class DifferenceFormatManager
    extends SetFunctionsFormatManager {
        @Override
        protected FormatId calculateFormatId() {
            FormatService service = FormatService.getInstance();
            return service.formatResult("Subtract", this.getInputFormatIdList());
        }
    }

    public static class State
    extends DistinctSetFunctionState {
        private Value stored;
        private NumericValue diff;
        private int count = 0;
        private SetFunctionsFormatManager formatManager = new DifferenceFormatManager();

        public State() {
        }

        public State(XDataContext context, IDataType type, boolean isDistinct) {
            super(context, type, isDistinct);
            this.stored = (NumericValue)type.createValue();
            this.diff = (NumericValue)type.createValue();
        }

        @Override
        protected void iterateImpl(XDataContext context, IValue input) {
            ++this.count;
            if (input.isNull()) {
                return;
            }
            if (!this.stored.isNull()) {
                this.diff.set(input);
                this.diff.subtract(this.stored);
                this.formatManager.clear();
                this.formatManager.iterateFormat((Value)input);
                this.formatManager.iterateFormat(this.stored);
            }
            this.stored.set(input);
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            --this.count;
        }

        @Override
        protected void getResultImpl(XDataContext context, IValue value) {
            this.diff.setFormatId(this.formatManager.getResultFormat());
            value.copyFrom(this.diff);
        }
    }
}

