/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.runtree.XDataContext;

public class Every
extends SetFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{{51}};

    public Every() {
        super("Every", ACCEPTED_TYPES, false);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State();
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Every.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return DataTypeFactory.getBooleanType();
    }

    public static class State
    implements ISetFunctionState {
        private int trueCount = 0;
        private int count = 0;

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            Value input = (Value)pEvaluator.getParameter(context, 0);
            ++this.count;
            if (input.getBoolean()) {
                ++this.trueCount;
            }
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            --this.count;
        }

        @Override
        public void getResult(XDataContext context, IValue value) {
            ((Value)value).set(this.count == this.trueCount);
        }

        @Override
        public void terminate(XDataContext context) {
        }
    }
}

