/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.runtree.XDataContext;

public class FirstValue
extends SetFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TYPES};

    public FirstValue() {
        super("FirstValue", "first_value", ACCEPTED_TYPES, false);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(context, type);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return FirstValue.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return oDataTypes[0];
    }

    private static class State
    implements ISetFunctionState {
        private IValue firstValue;
        private int count = 0;

        State(XDataContext context, IDataType dType) {
            this.firstValue = dType.createValue(context.getLocalCollator());
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            Value input = (Value)pEvaluator.getParameter(context, 0);
            if (this.count++ == 0) {
                this.firstValue.copyFrom(input);
            }
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            --this.count;
        }

        @Override
        public void getResult(XDataContext context, IValue value) {
            value.copyFrom(this.firstValue);
        }

        @Override
        public void terminate(XDataContext context) {
        }
    }
}

