/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.runtree.XDataContext;
import java.util.TreeMap;

public class Min
extends SetFunction {
    private static final long serialVersionUID = 1L;
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TYPES};

    public Min() {
        super("Min", ACCEPTED_TYPES, false);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(type);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Min.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return oDataTypes[0];
    }

    public static class State
    implements ISetFunctionState {
        protected TreeMap<RefCountValue, RefCountValue> sortedValueMap = new TreeMap();
        private RefCountValue tmpRefVal = new RefCountValue();
        private int count = 0;

        public State() {
        }

        public State(IDataType type) {
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            IValue input = pEvaluator.getParameter(context, 0);
            if (!input.isNull()) {
                this.tmpRefVal.setValue(input);
            }
            RefCountValue refVal = null;
            if (!input.isNull()) {
                if (this.sortedValueMap.containsKey(this.tmpRefVal)) {
                    refVal = this.sortedValueMap.get(this.tmpRefVal);
                    refVal.incrementRefCount();
                } else {
                    refVal = new RefCountValue();
                    IValue v = input.getDataType().createValue(context.getLocalCollator());
                    v.copyFrom(input);
                    refVal.setValue(v);
                    this.sortedValueMap.put(refVal, refVal);
                }
            }
            ++this.count;
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            Value input = (Value)pEvaluator.getParameter(context, 0);
            if (!input.isNull()) {
                this.tmpRefVal.setValue(input);
            }
            RefCountValue refVal = null;
            if (!input.isNull() && this.sortedValueMap.containsKey(this.tmpRefVal)) {
                refVal = this.sortedValueMap.get(this.tmpRefVal);
                refVal.decrementRefCount();
                if (refVal.getRefCount() == 0) {
                    this.sortedValueMap.remove(refVal);
                }
            }
            --this.count;
        }

        @Override
        public void getResult(XDataContext context, IValue value) {
            if (this.sortedValueMap.size() > 0) {
                RefCountValue v = this.sortedValueMap.firstKey();
                if (v != null) {
                    IValue vv = v.getValue();
                    if (vv instanceof Value && ((Value)vv).isDivByZero()) {
                        ((Value)value).setState(ValueState.DIV_BY_ZERO);
                    } else {
                        value.copyFrom(v.getValue());
                    }
                } else {
                    value.setNull();
                }
            } else {
                value.setNull();
            }
        }

        @Override
        public void terminate(XDataContext context) {
        }

        protected IValue getMaxValue() {
            if (this.sortedValueMap.size() > 0) {
                RefCountValue v = this.sortedValueMap.lastKey();
                return v.getValue();
            }
            return null;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        public long getVersionID() {
            return 1L;
        }

        protected class RefCountValue
        implements Comparable<Object>,
        Cloneable {
            static final long serialVersionUID = -6984102225919973906L;
            private IValue value;
            private int refCount = 0;

            public RefCountValue() {
            }

            public RefCountValue(IValue pValue, int pRefCount) {
                this.value = pValue;
                this.refCount = pRefCount;
            }

            @Override
            public int compareTo(Object object) {
                IValue v = ((RefCountValue)object).getValue();
                return this.value.compareTo(v);
            }

            public Object copy() {
                RefCountValue x = null;
                try {
                    x = (RefCountValue)super.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new XQERuntimeException(e);
                }
                return x;
            }

            public void setValue(IValue pValue) {
                this.value = pValue;
                ++this.refCount;
            }

            public IValue getValue() {
                return this.value;
            }

            public void incrementRefCount() {
                ++this.refCount;
            }

            public void incrementRefCount(int pCount) {
                this.refCount += pCount;
            }

            public void decrementRefCount() {
                --this.refCount;
            }

            public void decrementRefCount(int pCount) {
                this.refCount -= pCount;
            }

            public int getRefCount() {
                return this.refCount;
            }

            public boolean equals(Object o) {
                return this.value.equals(o);
            }

            public int hashCode() {
                return this.value.hashCode();
            }
        }
    }
}

