/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.runtree.XDataContext;
import java.util.LinkedList;
import java.util.List;

public class NthValue
extends SetFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_TYPES, DataTypeCode.ALL_NUMERIC_TYPES, DataTypeCode.ALL_CHARACTER_TYPES, DataTypeCode.ALL_CHARACTER_TYPES};

    public NthValue() {
        super("NthValue", "nth_value", ACCEPTED_TYPES, false, 2);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(context, pEvaluator);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return NthValue.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return oDataTypes[0];
    }

    @Override
    public boolean isAggregate() {
        return true;
    }

    @Override
    public boolean isTwoPass() {
        return false;
    }

    public static class State
    implements ISetFunctionState {
        private static final int NULL_TREATMENT_INDEX = 3;
        private static final String FROMLAST = "FROM LAST";
        private static final String IGNORNULLS = "IGNORE NULLS";
        private int count = 0;
        private Value resultValue;
        private int offset;
        private boolean ignoreNulls = false;
        private boolean fromLast = false;
        private List<Value> lastNList;

        public State(XDataContext context, IParameterEvaluator pEvaluator) {
            int nArgs = pEvaluator.getParameterCount();
            if (nArgs > 3) {
                String nullTreatment;
                String fromFirstOrLast = pEvaluator.getParameter(context, 2).toString();
                if (fromFirstOrLast.equals(FROMLAST)) {
                    this.fromLast = true;
                }
                if ((nullTreatment = pEvaluator.getParameter(context, 3).toString()).equals(IGNORNULLS)) {
                    this.ignoreNulls = true;
                }
            } else if (nArgs > 2) {
                String option = pEvaluator.getParameter(context, 2).toString();
                if (option.equals(FROMLAST)) {
                    this.fromLast = true;
                } else if (option.equals(IGNORNULLS)) {
                    this.ignoreNulls = true;
                }
            }
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            Value value = (Value)pEvaluator.getParameter(context, 0);
            if (this.count == 0) {
                this.offset = ((Value)pEvaluator.getParameter(context, 1)).getInteger();
                if (this.offset <= 0) {
                    throw new XQERuntimeException(XQEMessageKeys.DAT_NumericValueOutOfRange);
                }
                this.resultValue = (Value)value.getDataType().createValue(context.getLocalCollator());
            }
            if (this.ignoreNulls && value.isNull()) {
                return;
            }
            ++this.count;
            if (!this.fromLast) {
                if (this.count == this.offset) {
                    this.resultValue.copyFrom(value);
                }
            } else {
                if (this.lastNList == null) {
                    this.lastNList = new LinkedList<Value>();
                }
                this.lastNList.add((Value)value.copy());
                if (this.lastNList.size() == this.offset) {
                    this.resultValue.copyFrom(this.lastNList.remove(0));
                }
            }
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getResult(XDataContext context, IValue value) {
            value.copyFrom(this.resultValue);
        }

        @Override
        public void terminate(XDataContext context) {
        }
    }
}

