/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.ValueComparator;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IAddable;
import com.cognos.xqe.data.values.IMultiplicable;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.function.operator.Multiply;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.resultsets.tabular.OrderBy;
import com.cognos.xqe.resultsets.tabular.RowComparator;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.util.SortEngine;
import java.util.ArrayList;
import java.util.Arrays;

public class PercentileCont
extends SetFunction {
    public static final String NAME = "PercentileCont";
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_NUMERIC_TYPES, {4, 6, 8, 10, 11, 12, 60, 17}};

    public PercentileCont() {
        super(NAME, "percentile_cont", ACCEPTED_TYPES, false);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(context, pEvaluator, type, this.getComparator());
    }

    public ISetFunctionState initializeNoCloning(XDataContext context, IParameterEvaluator pEvaluator, IDataType type, int arraySize) {
        return new State(context, pEvaluator, type, this.getOrCreateComparator(), arraySize);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return PercentileCont.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        IDataType dataType = oDataTypes[1];
        if (dataType == null) {
            return null;
        }
        if (dataType.getCCLTypeCode() == 12 && oDataTypes[0].getCCLTypeCode() == 12) {
            return Multiply.getOutputType(oDataTypes);
        }
        if (dataType.getCCLTypeCode() != 60 && dataType.getCCLTypeCode() != 17) {
            dataType = DataTypeFactory.getDoubleType();
        }
        return dataType;
    }

    protected static class State
    implements ISetFunctionState {
        private int count;
        private SortEngine sortEngine;
        private Value[] values = null;
        private IDataType inputType;
        private Value percentileValue = null;
        private DoubleValue d1 = DataValueFactory.createDoubleValue();
        private DoubleValue d2 = DataValueFactory.createDoubleValue();
        private RowComparator rowComparator;
        private ValueComparator setComparator;

        public State(XDataContext context, IParameterEvaluator pEvaluator, IDataType type, ValueComparator comparator) {
            this.inputType = pEvaluator.getParameterType(1);
            RowsetInfo rowsetInfo = new RowsetInfo();
            rowsetInfo.addColumnInfo(new ColumnInfo("inputColumn", this.inputType));
            OrderBy[] orderbyList = new OrderBy[1];
            Boolean isAscending = true;
            if (comparator != null && comparator.getDirection() < 0) {
                isAscending = false;
            }
            orderbyList[0] = new OrderBy(0, isAscending);
            this.rowComparator = new RowComparator(rowsetInfo, orderbyList);
            this.sortEngine = new SortEngine(context, rowsetInfo, this.rowComparator, false);
        }

        public State(XDataContext context, IParameterEvaluator pEvaluator, IDataType type, ValueComparator comparator, int fixedSize) {
            this.sortEngine = null;
            this.setComparator = comparator;
            this.percentileValue = (Value)pEvaluator.getParameter(context, 0);
            this.validatePercentileValue();
            this.values = new Value[fixedSize];
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            if (this.percentileValue == null) {
                this.percentileValue = (Value)pEvaluator.getParameter(context, 0).copy();
            } else {
                Value tempValue = (Value)pEvaluator.getParameter(context, 0);
                if (!tempValue.equals(this.percentileValue)) {
                    throw new XQERuntimeException(XQEMessageKeys.EXE_InvalidPercentileArgumentType);
                }
            }
            Value input = (Value)pEvaluator.getParameter(context, 1);
            this.validatePercentileValue();
            if (input.isNull()) {
                return;
            }
            if (this.sortEngine == null) {
                this.values[this.count] = input;
                ++this.count;
            } else {
                Value aValueForRow = (Value)input.getDataType().createValue();
                aValueForRow.copyFrom(input);
                IValue[] row = new Value[]{aValueForRow};
                RowValue rowValue = DataValueFactory.createRowValue(row);
                this.sortEngine.write(rowValue);
                ++this.count;
            }
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
        }

        @Override
        public void getResult(XDataContext context, IValue iValue) {
            Value value = (Value)iValue;
            if (this.count == 0) {
                value.setNull();
                return;
            }
            double rn = 1.0 + this.percentileValue.getDouble() * (double)(this.count - 1);
            double cRn = Math.ceil(rn);
            double fRn = Math.floor(rn);
            if (this.sortEngine == null) {
                Arrays.sort(this.values, 0, this.count, this.setComparator);
                if (cRn == rn && fRn == rn) {
                    value.copyFrom(this.values[(int)rn - 1]);
                    value.setFormatId(this.values[(int)rn - 1].getFormatId());
                } else {
                    FormatService service = FormatService.getInstance();
                    ArrayList<FormatId> operandIds = new ArrayList<FormatId>();
                    Value v1 = (Value)value.getDataType().createValue();
                    v1.copyFrom(this.values[(int)fRn - 1]);
                    Value v2 = (Value)value.getDataType().createValue();
                    v2.copyFrom(this.values[(int)cRn - 1]);
                    operandIds.add(v1.getFormatId());
                    operandIds.add(v2.getFormatId());
                    this.d1.set(cRn - rn);
                    this.d2.set(rn - fRn);
                    ((IMultiplicable)((Object)v1)).multiply(this.d1);
                    ((IMultiplicable)((Object)v2)).multiply(this.d2);
                    value.set(v1);
                    ((IAddable)((Object)value)).add(v2);
                    FormatId resultFormatId = service.formatResult(PercentileCont.NAME, operandIds);
                    value.setFormatId(resultFormatId);
                }
            } else {
                Value rnValue = null;
                Value v1 = (Value)value.getDataType().createValue();
                Value v2 = (Value)value.getDataType().createValue();
                int i = 1;
                while ((double)i <= cRn) {
                    Value tempValue = (Value)this.sortEngine.next().getColumn(0);
                    if ((double)i == rn) {
                        rnValue = (Value)tempValue.copy();
                    } else if ((double)i == fRn) {
                        v1.copyFrom(tempValue);
                    } else if ((double)i == cRn) {
                        v2.copyFrom(tempValue);
                    }
                    ++i;
                }
                if (cRn == rn && fRn == rn) {
                    value.copyFrom(rnValue);
                    value.setFormatId(rnValue.getFormatId());
                } else {
                    FormatService service = FormatService.getInstance();
                    ArrayList<FormatId> operandIds = new ArrayList<FormatId>();
                    operandIds.add(v1.getFormatId());
                    operandIds.add(v2.getFormatId());
                    this.d1.set(cRn - rn);
                    this.d2.set(rn - fRn);
                    ((IMultiplicable)((Object)v1)).multiply(this.d1);
                    ((IMultiplicable)((Object)v2)).multiply(this.d2);
                    value.set(v1);
                    ((IAddable)((Object)value)).add(v2);
                    FormatId resultFormatId = service.formatResult(PercentileCont.NAME, operandIds);
                    value.setFormatId(resultFormatId);
                }
            }
            if (this.sortEngine != null) {
                this.sortEngine.release();
            }
        }

        @Override
        public void terminate(XDataContext context) {
        }

        private void validatePercentileValue() {
            double nv;
            boolean valid = true;
            if (this.percentileValue == null) {
                valid = false;
            } else if (!this.percentileValue.isNull() && ((nv = this.percentileValue.getDouble()) < 0.0 || nv > 1.0)) {
                valid = false;
            }
            if (!valid) {
                throw new XQERuntimeException(XQEMessageKeys.DAT_NumericValueOutOfRange);
            }
        }
    }
}

