/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.CharValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.runtree.XDataContext;

public class Tertile
extends SetFunction {
    private static final byte[][] ACCEPTED_TYPES = new byte[0][];
    private static final int TERTILE_BUCKETS = 3;

    public Tertile() {
        super("Tertile", ACCEPTED_TYPES, false);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State();
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return Tertile.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return DataTypeFactory.getCharType(1);
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public boolean isTwoPass() {
        return true;
    }

    public static class State
    implements ISetFunctionState {
        private int count = 0;
        private Behaviour behaviour = new IterationBehaviour();

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            this.behaviour.iterate();
            ++this.count;
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getResult(XDataContext context, IValue value) {
            this.behaviour.getResult((CharValue)value);
        }

        @Override
        public void terminate(XDataContext context) {
        }

        private class ResultBehaviour
        extends Behaviour {
            int bucketCapacity;
            int extraItems;
            private int currentBucketNo;
            private int itemsInCurrentBucket;

            ResultBehaviour() {
                this.bucketCapacity = State.this.count / 3;
                this.extraItems = State.this.count % 3;
                if (this.extraItems > 0) {
                    ++this.bucketCapacity;
                }
                this.currentBucketNo = 1;
                this.itemsInCurrentBucket = 0;
            }

            @Override
            public void iterate() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void getResult(Value value) {
                if (this.itemsInCurrentBucket == this.bucketCapacity) {
                    this.itemsInCurrentBucket = 0;
                    if (this.extraItems > 0) {
                        --this.extraItems;
                        if (this.extraItems == 0) {
                            --this.bucketCapacity;
                        }
                    }
                    ++this.currentBucketNo;
                }
                switch (this.currentBucketNo) {
                    case 1: {
                        ((CharValue)value).set("H");
                        break;
                    }
                    case 2: {
                        ((CharValue)value).set("M");
                        break;
                    }
                    default: {
                        ((CharValue)value).set("L");
                    }
                }
                ++this.itemsInCurrentBucket;
            }
        }

        private class IterationBehaviour
        extends Behaviour {
            private IterationBehaviour() {
            }

            @Override
            public void iterate() {
            }

            @Override
            public void getResult(Value value) {
                State.this.behaviour = new ResultBehaviour();
                State.this.behaviour.getResult(value);
            }
        }

        private abstract class Behaviour {
            private Behaviour() {
            }

            public abstract void iterate();

            public abstract void getResult(Value var1);
        }
    }
}

