/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set;

import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.SetFunction;
import com.cognos.xqe.function.set.SetFunctionsFormatManager;
import com.cognos.xqe.runtree.XDataContext;

public class VarPop
extends SetFunction {
    public static final byte[][] ACCEPTED_TYPES = new byte[][]{DataTypeCode.ALL_NUMERIC_TYPES};

    public VarPop() {
        super("VarPop", "var_pop", ACCEPTED_TYPES, false);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(type);
    }

    @Override
    public IDataType getResultDataTypeImpl(IDataType[] oDataTypes) {
        return VarPop.getOutputType(oDataTypes);
    }

    public static IDataType getOutputType(IDataType[] oDataTypes) {
        return DataTypeFactory.getDoubleType();
    }

    public static class VarPopFormatManager
    extends SetFunctionsFormatManager {
        @Override
        protected FormatId calculateFormatId() {
            FormatService service = FormatService.getInstance();
            return service.formatResult("Variance", this.getInputFormatIdList());
        }
    }

    public static class State
    implements ISetFunctionState {
        private double sum;
        private double sumOfSquares;
        private int count;
        private int nullCount;
        protected SetFunctionsFormatManager formatManager = new VarPopFormatManager();

        public State() {
        }

        public State(IDataType type) {
            this.sum = 0.0;
            this.sumOfSquares = 0.0;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            Value input = (Value)pEvaluator.getParameter(context, 0);
            ++this.count;
            if (input.isNull()) {
                ++this.nullCount;
                return;
            }
            this.sum += input.getDouble();
            this.sumOfSquares += input.getDouble() * input.getDouble();
            this.formatManager.iterateFormat(input);
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            Value input = (Value)pEvaluator.getParameter(context, 0);
            --this.count;
            if (input.isNull()) {
                --this.nullCount;
                return;
            }
            this.sum -= input.getDouble();
            this.sumOfSquares -= input.getDouble() * input.getDouble();
        }

        @Override
        public void getResult(XDataContext context, IValue iValue) {
            Value value = (Value)iValue;
            int nonNullCount = this.count - this.nullCount;
            if (this.count == 0 || nonNullCount == 0) {
                value.setNull();
            } else {
                if (nonNullCount == 1) {
                    value.set(0);
                } else {
                    double d1 = this.sum * this.sum / (double)nonNullCount;
                    double d2 = (this.sumOfSquares - d1) / (double)nonNullCount;
                    value.set(d2);
                }
                value.setFormatId(this.formatManager.getResultFormat());
            }
        }

        @Override
        public void terminate(XDataContext context) {
        }
    }
}

