/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set.regression;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.function.BinarySetFunction;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.runtree.XDataContext;

public class RegrSXY
extends BinarySetFunction {
    public RegrSXY() {
        super("RegrSXY", "regr_sxy", true);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(type);
    }

    protected static class State
    implements ISetFunctionState {
        private DoubleValue sumX;
        private DoubleValue sumY;
        private DoubleValue sumXY;
        private int count;
        private int nullCount;

        public State() {
        }

        public State(IDataType type) {
            this.sumX = DataValueFactory.createDoubleValue();
            this.sumX.set(0);
            this.sumY = DataValueFactory.createDoubleValue();
            this.sumY.set(0);
            this.sumXY = DataValueFactory.createDoubleValue();
            this.sumXY.set(0);
        }

        public int getCardinality() {
            return this.count - this.nullCount;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            NumericValue y = (NumericValue)pEvaluator.getParameter(context, 0);
            NumericValue x = (NumericValue)pEvaluator.getParameter(context, 1);
            ++this.count;
            if (y.isNull() || x.isNull()) {
                ++this.nullCount;
                return;
            }
            this.sumX.set(this.sumX.getDouble() + x.getDouble());
            this.sumY.set(this.sumY.getDouble() + y.getDouble());
            double d = this.sumXY.getDouble() + x.getDouble() * y.getDouble();
            this.sumXY.set(d);
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            NumericValue y = (NumericValue)pEvaluator.getParameter(context, 0);
            NumericValue x = (NumericValue)pEvaluator.getParameter(context, 1);
            --this.count;
            if (y.isNull() || x.isNull()) {
                --this.nullCount;
            }
            this.sumX.set(this.sumX.getDouble() - x.getDouble());
            this.sumY.set(this.sumY.getDouble() - y.getDouble());
            double d = this.sumXY.getDouble() - x.getDouble() * y.getDouble();
            this.sumXY.set(d);
        }

        @Override
        public void getResult(XDataContext context, IValue value) {
            NumericValue pValue = (NumericValue)value;
            int nonNullCount = this.count - this.nullCount;
            if (this.count == 0 || nonNullCount == 0) {
                pValue.setNull();
            } else {
                double d = this.sumXY.getDouble() - this.sumX.getDouble() * this.sumY.getDouble() / (double)nonNullCount;
                pValue.set(d);
            }
        }

        @Override
        public void terminate(XDataContext context) {
        }
    }
}

