/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.set.regression;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.function.BinarySetFunction;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.runtree.XDataContext;

public class RegrSYY
extends BinarySetFunction {
    public RegrSYY() {
        super("RegrSYY", "regr_syy", true);
    }

    @Override
    public ISetFunctionState initialize(XDataContext context, IParameterEvaluator pEvaluator, IDataType type) {
        return new State(type);
    }

    protected static class State
    implements ISetFunctionState {
        private DoubleValue sumY;
        private DoubleValue sumY2;
        private int count;
        private int nullCount;

        public State() {
        }

        public State(IDataType type) {
            this.sumY = DataValueFactory.createDoubleValue();
            this.sumY.set(0);
            this.sumY2 = DataValueFactory.createDoubleValue();
            this.sumY2.set(0);
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public void iterate(XDataContext context, IParameterEvaluator pEvaluator) {
            NumericValue y = (NumericValue)pEvaluator.getParameter(context, 0);
            NumericValue x = (NumericValue)pEvaluator.getParameter(context, 1);
            ++this.count;
            if (y.isNull() || x.isNull()) {
                ++this.nullCount;
                return;
            }
            this.sumY.add(y);
            double d = y.getDouble() * y.getDouble() + this.sumY2.getDouble();
            this.sumY2.set(d);
        }

        @Override
        public void remove(XDataContext context, IParameterEvaluator pEvaluator) {
            NumericValue y = (NumericValue)pEvaluator.getParameter(context, 0);
            NumericValue x = (NumericValue)pEvaluator.getParameter(context, 1);
            --this.count;
            if (y.isNull() || x.isNull()) {
                --this.nullCount;
            }
            this.sumY.subtract(y);
            double d = this.sumY2.getDouble() - y.getDouble() * y.getDouble();
            this.sumY2.set(d);
        }

        @Override
        public void getResult(XDataContext context, IValue value) {
            NumericValue pValue = (NumericValue)value;
            int nonNullCount = this.count - this.nullCount;
            if (this.count == 0 || nonNullCount == 0) {
                pValue.setNull();
            } else {
                double d1 = this.sumY.getDouble();
                double d2 = this.sumY2.getDouble() - d1 * d1 / (double)nonNullCount;
                pValue.set(d2);
            }
        }

        @Override
        public void terminate(XDataContext context) {
        }
    }
}

