/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.udf;

import com.cognos.xqe.ast.sql.ddl.SQLCreateFunction;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.ErrorList;
import com.cognos.xqe.function.IFunctionState;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.udf.UDTableFunction;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class UDScriptTableFunction
extends UDTableFunction
implements IFunctionState {
    static final long serialVersionUID = 539883639050706431L;
    private static ScriptEngineManager manager = new ScriptEngineManager();
    private Invocable iScriptEngine;
    private String methodName;
    private ErrorList errorList;

    public UDScriptTableFunction(SQLCreateFunction ddlNode, InputStream is, String name, ErrorList udfErrorList) {
        super(ddlNode);
        this.errorList = udfErrorList;
        this.methodName = name;
        ScriptEngine scriptEngine = manager.getEngineByName(ddlNode.getLanguage().toLowerCase());
        if (is != null) {
            InputStreamReader reader = new InputStreamReader(is);
            try {
                scriptEngine.eval(reader);
            }
            catch (ScriptException e) {
                this.errorList.add(e.getLocalizedMessage());
            }
        }
        this.iScriptEngine = (Invocable)((Object)scriptEngine);
    }

    @Override
    public ITabularResultSet execute(XDataContext context, IParameterEvaluator pEvaluator, IRowsetInfo rowsetInfo) {
        return new TabularHybridResultSet(context, new UDScriptTableFunctionResultSet(context, pEvaluator, rowsetInfo));
    }

    @Override
    public String getJarName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getClassName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getMethodName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValid() {
        return this.errorList.isEmpty();
    }

    @Override
    public ErrorList getErrors() {
        return this.errorList;
    }

    private final class UDScriptTableFunctionResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private IParameterEvaluator pEvaluator;
        private Object resultSet;

        public UDScriptTableFunctionResultSet(XDataContext context, IParameterEvaluator parameterEvaluator, IRowsetInfo theRowsetInfo) {
            super(context, context.getNodeId());
            this.pEvaluator = parameterEvaluator;
            int nArgs = this.pEvaluator.getParameterCount();
            Object[] args = new Object[nArgs];
            for (int i = 0; i < nArgs; ++i) {
                Value pValue = (Value)this.pEvaluator.getParameter(context, i);
                args[i] = pValue.getObject();
            }
            try {
                this.resultSet = UDScriptTableFunction.this.iScriptEngine.invokeFunction(UDScriptTableFunction.this.methodName, args);
            }
            catch (ScriptException e) {
                throw XQERuntimeException.wrap(e);
            }
            catch (NoSuchMethodException e) {
                throw XQERuntimeException.wrap(e);
            }
            this.setTabularRowsetInfo(theRowsetInfo);
        }

        @Override
        public IScrollableIterator getScrollableTabularIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new UDScriptTableFunctionIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
        }

        private final class UDScriptTableFunctionIterator
        extends XTabularIterator {
            private int nRows;
            private IRow result;
            private int nColumns;

            private UDScriptTableFunctionIterator(XDataContext context) {
                super(context, context.getNodeId());
                this.startTimer();
                this.nColumns = UDScriptTableFunctionResultSet.this.rowsetInfo.getNumColumns();
                this.result = DataValueFactory.createRowValue(context.getLocalCollator(), UDScriptTableFunctionResultSet.this.rowsetInfo);
                this.stopTimer();
            }

            @Override
            public Object nextImpl() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                try {
                    Boolean hasNext = (Boolean)UDScriptTableFunction.this.iScriptEngine.invokeMethod(UDScriptTableFunctionResultSet.this.resultSet, "next", null);
                    if (!hasNext.booleanValue()) {
                        return null;
                    }
                    ++this.nRows;
                    for (int i = 0; i < this.nColumns; ++i) {
                        Value value = (Value)this.result.getColumn(i);
                        Object object = UDScriptTableFunction.this.iScriptEngine.invokeMethod(UDScriptTableFunctionResultSet.this.resultSet, "getObject", i + 1);
                        value.set(object);
                        Boolean wasNull = (Boolean)UDScriptTableFunction.this.iScriptEngine.invokeMethod(UDScriptTableFunctionResultSet.this.resultSet, "wasNull", null);
                        if (!wasNull.booleanValue()) continue;
                        value.setNull();
                    }
                }
                catch (ScriptException e) {
                    throw XQERuntimeException.wrap(e);
                }
                catch (NoSuchMethodException e) {
                    throw XQERuntimeException.wrap(e);
                }
                return this.result;
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public void release() {
                try {
                    UDScriptTableFunction.this.iScriptEngine.invokeMethod(UDScriptTableFunctionResultSet.this.resultSet, "close", null);
                    UDScriptTableFunctionResultSet.this.resultSet = null;
                }
                catch (ScriptException e) {
                    throw XQERuntimeException.wrap(e);
                }
                catch (NoSuchMethodException e) {
                    throw XQERuntimeException.wrap(e);
                }
            }
        }
    }
}

