/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.hooks;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.ObjectType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public enum HookEvent {
    JDBC_CONNECT(new IDataType[]{ObjectType.OBJECTTYPE}),
    JDBC_PREPARE(new IDataType[]{ObjectType.OBJECTTYPE, ObjectType.OBJECTTYPE, ObjectType.OBJECTTYPE}),
    JDBC_EXECUTE(new IDataType[]{ObjectType.OBJECTTYPE, ObjectType.OBJECTTYPE}),
    JDBC_CLOSE(new IDataType[]{ObjectType.OBJECTTYPE, ObjectType.OBJECTTYPE}),
    JDBC_DISCONNECT(new IDataType[]{ObjectType.OBJECTTYPE});

    private static boolean ignoreExceptions;
    private static boolean chained;
    private IDataType[] signature;
    private List<Method> hooks = new ArrayList<Method>();
    private int current;

    private HookEvent(IDataType[] hookSignature) {
        this.signature = hookSignature;
    }

    public IDataType[] getSignature() {
        return this.signature;
    }

    public void addHook(Method method) {
        this.hooks.add(method);
    }

    public void execute(Object[] args) throws Exception {
        for (Method hook : this.hooks) {
            try {
                hook.invoke(null, args);
            }
            catch (Exception e) {
                if (!ignoreExceptions) {
                    throw e;
                }
                if (!chained) continue;
                break;
            }
        }
        this.current = 1;
    }

    public void executeNext(Object[] args) throws Exception {
        block3: {
            if (this.current == this.hooks.size()) {
                return;
            }
            Method hook = this.hooks.get(this.current++);
            try {
                hook.invoke(null, args);
            }
            catch (Exception e) {
                if (ignoreExceptions) break block3;
                throw e;
            }
        }
    }

    public boolean hooksDefined() {
        return this.hooks.size() != 0;
    }

    static {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        ignoreExceptions = config.getBooleanProperty("general.hooks[@ignoreExceptions]", true);
        chained = config.getBooleanProperty("general.hooks[@chained]", false);
    }
}

