/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ma4j.framework;

import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.ma4j.framework.MAConstraint;
import com.cognos.xqe.ma4j.framework.MAConstraintProcessor;
import com.cognos.xqe.ma4j.framework.MAFunctionNode;
import com.cognos.xqe.ma4j.framework.MAObjectBrowser;
import com.cognos.xqe.ma4j.framework.MAQueryParser;
import com.cognos.xqe.runtree.ma.MAXNodeRuntimeException;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.fds.IFunctionDefinition;
import com.cognos.xqe.util.fds.IFunctionNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.dom4j.Document;

public class MAFunctionSupportUtility
extends MAObjectBrowser {
    public static final String GROUP = "group";
    public static final String FUNCTION = "function";
    IFunctionDefinition functionDefinition = null;
    Document pDocumentResponse;
    ArrayList<IFunctionNode> functionNodeList = new ArrayList();
    MFWNodeHandle mRootNamespace;
    MAQueryParser pQueryParser;

    public MAFunctionSupportUtility(MFWGateway pGW, MAQueryParser queryParser, MFWNodeHandle pRootNamespace, Locale locale) {
        super(pGW, queryParser.getWorkingLocales());
        this.mRootNamespace = pRootNamespace;
        this.pQueryParser = queryParser;
        this.functionDefinition = IFunctionDefinition.Factory.create(locale);
    }

    public void getSupportedFunctionSetInfo(ArrayList<String> vendorFunctionSetIDs, ArrayList<String> vendorFunctionSetNames) {
        this.functionDefinition.getSupportedVendorFunctionSets(vendorFunctionSetIDs, vendorFunctionSetNames);
    }

    public IFunctionNode buildFunctionInfoNode(String startAtValue, int depth, MAConstraintProcessor constraintProcessor, ArrayList<String> queryTypeList, ArrayList<String> functionSetIDList, ArrayList<String> interfaceIDList) {
        IFunctionNode fdRootNode;
        IFunctionNode result = null;
        Locale locale = this.functionDefinition.getEffectiveLocale();
        this.addContextFilters(constraintProcessor, queryTypeList, functionSetIDList, interfaceIDList, locale);
        if (this.getMFWGateway() != null) {
            this.extractModelFunctions(locale);
        }
        if ((fdRootNode = this.functionDefinition.getRoot()) == null) {
            throw new MAXNodeRuntimeException(XQEMessageKeys.MA_FunctionDefifnitionNotLoad);
        }
        if (!fdRootNode.isGroup()) {
            throw new MAXNodeRuntimeException(XQEMessageKeys.MA_RootNotGroup);
        }
        if (startAtValue == null || startAtValue.length() == 0) {
            result = fdRootNode;
        } else {
            FunctionNodeType fnType = this.findRequestedFunctionGroup(startAtValue, fdRootNode);
            if (fnType.node != null) {
                result = fnType.node;
            } else {
                throw new MAXNodeRuntimeException(XQEMessageKeys.MA_RequestedFunctionGroupNotFound);
            }
        }
        return result;
    }

    public FunctionNodeType findRequestedFunctionGroup(String functionGroupId, IFunctionNode funNode) {
        boolean bChildFound = false;
        FunctionNodeType fNodeType = null;
        String childType = null;
        IFunctionNode childNode2 = null;
        ArrayList<IFunctionNode> children = funNode.getChildren();
        for (IFunctionNode childNode2 : children) {
            if (childNode2 == null) break;
            String childID = childNode2.getId();
            if (!childID.equals(functionGroupId)) continue;
            childType = childNode2.isGroup() ? GROUP : FUNCTION;
            bChildFound = true;
            fNodeType = new FunctionNodeType(childNode2, childType);
            break;
        }
        if (!bChildFound) {
            for (IFunctionNode childNode2 : children) {
                funNode = childNode2;
                fNodeType = this.findRequestedFunctionGroup(functionGroupId, funNode);
                if (fNodeType == null) continue;
                bChildFound = true;
                break;
            }
        }
        return fNodeType;
    }

    public IFunctionDefinition getFunctionDefinition() {
        return this.functionDefinition;
    }

    private void extractModelFunctions(Locale locale) {
        MFWNodeHandle[] funcHandles = this.getMFWGateway().queryObject(this.mRootNamespace, MFWQuerySpec.create((String)"//function"));
        for (int i = 0; i < funcHandles.length; ++i) {
            MFWNodeHandle theFunction = funcHandles[i];
            if (!this.isObjectIncluded(theFunction)) continue;
            this.extractFunction(locale, theFunction, this.functionDefinition.getRoot());
        }
    }

    private void extractFunction(Locale locale, MFWNodeHandle pFunction, IFunctionNode root) {
        String language = LocaleConverter.toString(locale);
        String functionName = this.getLocalizedProperty(pFunction, MAFunctionSupportUtility.MODEL_RES.RID_name, language);
        short ridName = MFWModelRes.getInstance().getResourceID("ID");
        String functionId = this.getMFWGateway().getObjectPropertyValue(pFunction, ridName);
        if (functionId != null) {
            int offsetOpen = functionId.indexOf("[");
            int offsetClose = functionId.indexOf("]");
            functionId = functionId.substring(offsetOpen + 1, offsetClose);
        } else {
            functionId = "";
        }
        String modelRootId = this.getMFWGateway().getObjectPropertyValue(this.mRootNamespace, ridName);
        ArrayList<String> folderNames = new ArrayList<String>();
        ArrayList<String> folderIds = new ArrayList<String>();
        for (MFWNodeHandle pFolder = pFunction.getParent(); pFolder != null && pFolder.getParent() != null; pFolder = pFolder.getParent()) {
            String name;
            String id = this.getMFWGateway().getObjectPropertyValue(pFolder, ridName);
            if (id == null) {
                id = "";
            }
            if (modelRootId.equals(id)) {
                folderIds.add(id);
                name = this.getLocalizedProperty(pFolder, MAFunctionSupportUtility.MODEL_RES.RID_name, language);
                folderNames.add(name);
                break;
            }
            name = this.getLocalizedProperty(pFolder, MAFunctionSupportUtility.MODEL_RES.RID_name, language);
            folderIds.add(id);
            folderNames.add(name);
        }
        IFunctionNode currentNode = root;
        for (int i = folderNames.size() - 1; i >= 0; --i) {
            IFunctionNode node;
            currentNode = node = currentNode.addAppGroup((String)folderIds.get(i), (String)folderNames.get(i));
        }
        MAFunctionNode functionNode = new MAFunctionNode(this.getMFWGateway(), this.pQueryParser, this.functionDefinition, pFunction);
        this.functionNodeList.add(functionNode);
        currentNode.addAppFunction(functionId, functionName, functionNode);
    }

    private void addContextFilters(MAConstraintProcessor constraintProcessor, ArrayList<String> queryTypeList, ArrayList<String> functionSetIDList, ArrayList<String> interfaceIDList, Locale locale) {
        if (constraintProcessor != null && constraintProcessor.hasConstraints()) {
            Iterator<String> constraint = constraintProcessor.getConstraint();
            List<MAConstraint> children = ((MAConstraint)((Object)constraint)).getChildren();
            for (MAConstraint theChild : children) {
                MAConstraint theConstraint = theChild;
                if (theConstraint.getFirstParameter().equals("context")) {
                    this.functionDefinition.addContextFilter(theConstraint.getSecondParameter());
                    continue;
                }
                if (theConstraint.getFirstParameter().equals("type")) {
                    this.functionDefinition.addTypeFilter(theConstraint.getSecondParameter());
                    continue;
                }
                if (!theConstraint.getFirstParameter().equals("vendor")) continue;
                this.functionDefinition.addVendorFunctionSetFilter(theConstraint.getSecondParameter());
            }
        }
        for (String theQueryType : queryTypeList) {
            this.functionDefinition.addModelDatasourceQueryTypeFilter(theQueryType);
        }
        for (String theFuncSetId : functionSetIDList) {
            this.functionDefinition.addVendorFunctionSetFilter(theFuncSetId);
        }
        for (String theInterfaceID : interfaceIDList) {
            this.functionDefinition.addModelDatasourceInterfaceIDFilter(theInterfaceID);
        }
        if (this.getMFWGateway() != null) {
            String description;
            String functionId;
            IFunctionNode.FDSQoSLevelEnum level = IFunctionNode.FDSQoSLevelEnum.UNAVAILABLE;
            MFWNodeHandle[] overrideModelCollection = this.getMFWGateway().getObjectChildren(this.getProjectNode(), MAFunctionSupportUtility.MODEL_RES.RID_qosOverride);
            String language = LocaleConverter.toString(locale);
            for (int i = 0; i < overrideModelCollection.length; ++i) {
                MFWNodeHandle theOverrideObj = overrideModelCollection[i];
                functionId = this.getSimplePropertyValue(theOverrideObj, MAFunctionSupportUtility.MODEL_RES.RID_functionId);
                level = this.getQOSLevel(theOverrideObj);
                description = this.getLocalizedProperty(theOverrideObj, MAFunctionSupportUtility.MODEL_RES.RID_description, language);
                if (description == null) {
                    description = "";
                }
                this.functionDefinition.overrideModelQoSLevel(functionId, level, description);
            }
            MFWNodeHandle[] vSecutyViewCollectors = this.getMFWGateway().getObjectChildren(this.getProjectNode(), MAFunctionSupportUtility.MODEL_RES.RID_securityViews);
            if (vSecutyViewCollectors != null && vSecutyViewCollectors.length > 0) {
                MFWNodeHandle[] securityViewsCollection = this.getMFWGateway().getObjectChildren(vSecutyViewCollectors[0], MAFunctionSupportUtility.MODEL_RES.RID_securityView);
                for (int k = 0; k < securityViewsCollection.length; ++k) {
                    boolean propValue;
                    MFWNodeHandle theSecurityView = securityViewsCollection[k];
                    if (!this.isObjectIncluded(theSecurityView) || (propValue = this.getMFWGateway().getObjectBooleanPropertyValue(theSecurityView, MAFunctionSupportUtility.MODEL_RES.RID_isRoleBased))) continue;
                    MFWNodeHandle[] packageOverrides = this.getMFWGateway().getObjectChildren(theSecurityView, MAFunctionSupportUtility.MODEL_RES.RID_qosOverride);
                    for (int m = 0; m < packageOverrides.length; ++m) {
                        MFWNodeHandle thePackageOverride = packageOverrides[m];
                        functionId = this.getSimplePropertyValue(thePackageOverride, MAFunctionSupportUtility.MODEL_RES.RID_functionId);
                        level = this.getQOSLevel(thePackageOverride);
                        description = this.getLocalizedProperty(thePackageOverride, MAFunctionSupportUtility.MODEL_RES.RID_description, language);
                        this.functionDefinition.overridePackageQoSLevel(functionId, level, description);
                    }
                }
            }
        }
    }

    private boolean isObjectIncluded(MFWNodeHandle handle) {
        boolean hasVisibleProperty;
        boolean bl = hasVisibleProperty = handle.getInfo().findChildInfo(MFWModelRes.getInstance().RID_visible) != null;
        if (hasVisibleProperty) {
            String visibility = null;
            try {
                visibility = this.getMFWGateway().getObjectPropertyValue(handle, MFWModelRes.getInstance().RID_visible);
                if (visibility != null) {
                    return visibility.equals("visibleAndAccessible");
                }
            }
            catch (MFWException e) {
                mErrorLogger.log(e);
                return true;
            }
        }
        return true;
    }

    private IFunctionNode.FDSQoSLevelEnum getQOSLevel(MFWNodeHandle pObject) {
        String qosLevel = this.getSimplePropertyValue(pObject, MAFunctionSupportUtility.MODEL_RES.RID_qosLevel);
        IFunctionNode.FDSQoSLevelEnum level = null;
        if (qosLevel.equals("restricted")) {
            level = IFunctionNode.FDSQoSLevelEnum.RESTRICTED;
        } else if (qosLevel.equals("limited")) {
            level = IFunctionNode.FDSQoSLevelEnum.LIMITED;
        } else if (qosLevel.equals("ok") || qosLevel.equals("OK")) {
            level = IFunctionNode.FDSQoSLevelEnum.OK;
        } else if (qosLevel.equals("unavailable")) {
            level = IFunctionNode.FDSQoSLevelEnum.UNAVAILABLE;
        }
        return level;
    }

    class FunctionNodeType {
        private IFunctionNode node;
        private String type;

        FunctionNodeType(IFunctionNode fNode, String fType) {
            this.node = fNode;
            this.type = fType;
        }

        String getType() {
            return this.type;
        }

        IFunctionNode getFunctionNode() {
            return this.node;
        }
    }
}

