/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ma4j.framework;

import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.ma4j.framework.MAIDManager;
import com.cognos.xqe.ma4j.framework.MAObjectBrowser;
import com.cognos.xqe.ma4j.framework.MAResolverPathInt;
import com.cognos.xqe.ma4j.framework.MAShortcutProcessor;
import com.cognos.xqe.ma4j.framework.MAWorkingLocales;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.xml.XMLUtils;

public class MAResolverFullPath
extends MAObjectBrowser
implements MAResolverPathInt {
    private static final String CLOSE_SQURE_BRACKET = "]";
    private MFWGateway mPGW = null;
    private MAShortcutProcessor mMAShortcutProcessor = null;
    private MAIDManager mIdManager = null;
    private String mPathID = null;
    private boolean mStartContainsShortcut = false;
    private String mOpenBracket = "[";
    private String mCloseBracket = "]";

    public MAResolverFullPath(MFWGateway pGW, MAWorkingLocales locales) {
        super(pGW, locales);
        this.mPGW = pGW;
        this.mMAShortcutProcessor = new MAShortcutProcessor(pGW);
        this.mIdManager = new MAIDManager(pGW, locales);
    }

    @Override
    public MFWNodeHandle resolvePath(String path, MFWNodeHandle parentObject) {
        this.mPathID = path;
        this.mStartContainsShortcut = false;
        MFWNodeHandle resHandle = null;
        MFWNodeHandle targetResHandle = null;
        MFWNodeHandle[] handles = null;
        if (path.length() == 0) {
            String queryPath = new String("//project/namespace");
            MFWQuerySpec aQuerySpec = MFWQuerySpec.create((String)queryPath);
            handles = parentObject == null ? this.mPGW.query(aQuerySpec) : this.mPGW.queryObject(parentObject, aQuerySpec);
            if (handles.length > 0) {
                short type;
                resHandle = handles[0];
                short originalType = type = resHandle.getInfo().getRID();
                String name = this.getName(resHandle, MAWorkingLocales.getRunLocale());
                String nameAuth = this.getName(resHandle, MAWorkingLocales.getRefLocale(this.getUseDesignLocaleForReferenceID()));
                MFWNodeHandle target = this.mMAShortcutProcessor.processShortcuts(resHandle);
                if (target != null) {
                    type = target.getInfo().getRID();
                    resHandle = target;
                    this.mStartContainsShortcut = true;
                }
                this.mIdManager.buildRefIDFull(nameAuth, originalType, type, resHandle, true);
                this.mPathID = this.mOpenBracket + name + this.mCloseBracket;
            }
        } else {
            String bareIdName;
            String[] tokens = null;
            try {
                tokens = UniqueNameParser.parse(path);
            }
            catch (UniqueNameParserException e) {
                throw new XQERuntimeException(XQEMessageKeys.V5_RefItemNotFound, (Object)e, (Object)path);
            }
            if (tokens == null) {
                return resHandle;
            }
            if (tokens.length > 0) {
                String token = UniqueNameGenerator.createUniqueName(tokens[0]);
                String queryPath = new String("//*[ID=" + XMLUtils.xPathLiteral(token) + CLOSE_SQURE_BRACKET);
                MFWQuerySpec aQuerySpec = MFWQuerySpec.create((String)queryPath);
                handles = parentObject == null ? this.mPGW.query(aQuerySpec) : this.mPGW.queryObject(parentObject, aQuerySpec);
                if (handles.length > 0) {
                    short type;
                    resHandle = handles[0];
                    short originalType = type = resHandle.getInfo().getRID();
                    String name = this.getName(resHandle, MAWorkingLocales.getRunLocale());
                    String nameAuth = this.getName(resHandle, MAWorkingLocales.getRefLocale(this.getUseDesignLocaleForReferenceID()));
                    targetResHandle = this.mMAShortcutProcessor.processShortcuts(resHandle);
                    if (targetResHandle != null) {
                        type = targetResHandle.getInfo().getRID();
                        if (tokens.length > 1) {
                            resHandle = targetResHandle;
                            targetResHandle = null;
                        }
                        this.mStartContainsShortcut = true;
                    }
                    this.mIdManager.buildRefIDFull(nameAuth, originalType, type, resHandle, tokens.length == 1);
                    this.mPathID = this.mOpenBracket + name + this.mCloseBracket;
                }
            }
            for (int k = 1; k < tokens.length && (resHandle = this.findObjectByIDName(resHandle, bareIdName = tokens[k])) != null; ++k) {
                short type;
                short originalType = type = resHandle.getInfo().getRID();
                String name = this.getName(resHandle, MAWorkingLocales.getRunLocale());
                String nameAuth = this.getName(resHandle, MAWorkingLocales.getRefLocale(this.getUseDesignLocaleForReferenceID()));
                targetResHandle = this.mMAShortcutProcessor.processShortcuts(resHandle);
                if (targetResHandle != null) {
                    type = targetResHandle.getInfo().getRID();
                    if (k < tokens.length - 1) {
                        resHandle = targetResHandle;
                    }
                    this.mStartContainsShortcut = true;
                }
                this.mIdManager.buildRefIDFull(nameAuth, originalType, type, resHandle, k == tokens.length - 1);
                this.mPathID = this.mPathID + ".[" + name + this.mCloseBracket;
            }
        }
        return resHandle;
    }

    @Override
    public String getRefID() {
        return this.mIdManager.getRefID();
    }

    @Override
    public String getPathID() {
        return this.mPathID;
    }

    @Override
    public short getLastRefType() {
        return this.mIdManager.getLastRefType();
    }

    @Override
    public boolean getStartContainsShortcut() {
        return this.mStartContainsShortcut;
    }
}

