/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ma4j.utilities;

import com.cognos.xqe.ma4j.framework.IMAAttributeTransformer;

public class MAXMLResponseBuilder {
    public static final int E_START_ATTRIB = 0;
    public static final int E_START_NO_ATTRIB = 1;
    public static final int E_END = 2;
    public static final int E_END_NO_LEADING_LF = 3;
    private static final String HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String LESS = "<";
    private static final String MORE = ">";
    private static final String LESS_SLASH = "</";
    private StringBuilder mXmlString;
    private IMAAttributeTransformer mAttributeTransformer = null;

    public MAXMLResponseBuilder() {
        this.initialize();
    }

    public IMAAttributeTransformer getAttributeTransformer() {
        return this.mAttributeTransformer;
    }

    public void setAttributeTransformer(IMAAttributeTransformer attributeTransformer) {
        this.mAttributeTransformer = attributeTransformer;
    }

    public String getXML() {
        return this.mXmlString.toString();
    }

    public void initialize() {
        this.mXmlString = new StringBuilder();
    }

    public void addElement(String name, int type) {
        if (name.compareTo("namespace") == 0) {
            name = "folder";
        }
        switch (type) {
            case 0: {
                this.mXmlString.append(LESS);
                this.mXmlString.append(name);
                break;
            }
            case 1: {
                this.mXmlString.append(LESS);
                this.mXmlString.append(name);
                this.mXmlString.append(MORE);
                break;
            }
            case 2: {
                this.mXmlString.append(LESS_SLASH);
                this.mXmlString.append(name);
                this.mXmlString.append(MORE);
                break;
            }
            case 3: {
                this.mXmlString.append(LESS_SLASH);
                this.mXmlString.append(name);
                this.mXmlString.append(MORE);
                break;
            }
        }
    }

    public void addEmptyElement(String name) {
        this.mXmlString.append(LESS);
        this.mXmlString.append(name);
        this.mXmlString.append("/>");
    }

    public void addAttribute(String name, String value) {
        if (null == (value = this.transformAttributeValue(name, value))) {
            return;
        }
        this.mXmlString.append(" ");
        this.mXmlString.append(name);
        this.mXmlString.append("=\"");
        this.mXmlString.append(value);
        this.mXmlString.append("\"");
    }

    public void addAttribute(String name, int value) {
        this.addAttribute(name, Integer.toString(value));
    }

    public void endElement(boolean bAddSlash) {
        if (bAddSlash) {
            this.mXmlString.append("/");
        }
        this.mXmlString.append(MORE);
    }

    public void addCData(String name, String value) {
        this.addElement(name, 1);
        this.mXmlString.append("![CDATA[");
        this.mXmlString.append(value);
        this.mXmlString.append("]]");
        this.addElement(name, 2);
    }

    public void addText(String text) {
        this.mXmlString.append(text);
    }

    public void addInt(int value) {
        this.mXmlString.append(value);
    }

    public void buildResponseHeader() {
        String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><response><connectionID value=\"***\"/><ResponseRoot>";
        this.addText(header);
    }

    public void buildResponseFooter() {
        String footer = "</ResponseRoot></response>";
        this.addText(footer);
    }

    public void buildEncodingElement() {
        this.addText(HEADER);
    }

    private String transformAttributeValue(String attributeName, String attributeValue) {
        if (null != this.mAttributeTransformer) {
            return this.mAttributeTransformer.transform(attributeName, attributeValue);
        }
        return attributeValue;
    }
}

