/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.management;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.management.XqeRMIConnector;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.SingletonHelper;
import java.io.ObjectInputStream;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

public final class XqeMBeanServer
implements MBeanServer {
    private static XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
    private static final String THE_MBEAN = "The MBean ";
    private MBeanServer mBeanServer;
    private Set<ObjectName> registeredMBeanObjectNames = Collections.synchronizedSet(new HashSet());
    private XqeRMIConnector connection = null;
    private static SingletonHelper<XqeMBeanServer> singletonHelper = new SingletonHelper<XqeMBeanServer>(){

        @Override
        protected XqeMBeanServer newInstance() {
            return new XqeMBeanServer();
        }

        @Override
        protected void initializeImpl(XqeMBeanServer theInstance) {
            theInstance.createMBeanServer();
        }

        @Override
        protected void releaseImpl(XqeMBeanServer theInstance) {
            if (config == null || config.isXQEMBeanServer()) {
                theInstance.stopServer();
            }
        }
    };

    public static XqeMBeanServer getInstance() {
        return singletonHelper.getInstance();
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    private XqeMBeanServer() {
    }

    private void createMBeanServer() {
        try {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
            if (config == null || config.isXQEMBeanServer()) {
                this.startRMIConnector();
            }
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, e);
        }
    }

    private void startRMIConnector() {
        try {
            this.connection = new XqeRMIConnector(this.mBeanServer);
            this.connection.startConnector();
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopServer() {
        try {
            this.connection.stopConnector();
            this.connection = null;
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, e);
        }
        finally {
            XQELogger initTermLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "InitTerm", LogLevel.WARN);
            Set<ObjectName> set = this.registeredMBeanObjectNames;
            synchronized (set) {
                Iterator<ObjectName> nameItr = this.registeredMBeanObjectNames.iterator();
                while (nameItr.hasNext()) {
                    ObjectName name = nameItr.next();
                    if (this.mBeanServer.isRegistered(name)) {
                        if (initTermLogger.isOn(LogLevel.WARN)) {
                            initTermLogger.log(LogLevel.WARN, THE_MBEAN + name.toString() + " is still registered. Unregistering as part of the XQE service shutdown.");
                        }
                        try {
                            this.mBeanServer.unregisterMBean(name);
                        }
                        catch (InstanceNotFoundException e) {
                            initTermLogger.log(LogLevel.ERROR, (Throwable)e);
                        }
                        catch (MBeanRegistrationException e) {
                            initTermLogger.log(LogLevel.ERROR, (Throwable)e);
                        }
                    } else if (initTermLogger.isOn(LogLevel.INFO)) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(THE_MBEAN).append(name.toString()).append(" is still registered according to the ").append(this.getClass().getSimpleName()).append(" singleton, but not according to the ").append("MBeanServer. The MBean was likely unregistered outside of ").append(this.getClass().getSimpleName()).append(".");
                        initTermLogger.log(LogLevel.INFO, sb.toString());
                    }
                    nameItr.remove();
                }
            }
        }
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.mBeanServer.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.mBeanServer.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        return this.mBeanServer.createMBean(className, name);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.mBeanServer.createMBean(className, name, loaderName);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        return this.mBeanServer.createMBean(className, name, params, signature);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.mBeanServer.createMBean(className, name, loaderName, params, signature);
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws OperationsException {
        return this.mBeanServer.deserialize(name, data);
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        return this.mBeanServer.deserialize(className, data);
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws OperationsException, ReflectionException {
        return this.mBeanServer.deserialize(className, loaderName, data);
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.mBeanServer.getAttribute(name, attribute);
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        return this.mBeanServer.getAttributes(name, attributes);
    }

    @Override
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        return this.mBeanServer.getClassLoader(loaderName);
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        return this.mBeanServer.getClassLoaderFor(mbeanName);
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        return this.mBeanServer.getClassLoaderRepository();
    }

    @Override
    public String getDefaultDomain() {
        return this.mBeanServer.getDefaultDomain();
    }

    @Override
    public String[] getDomains() {
        return this.mBeanServer.getDomains();
    }

    @Override
    public Integer getMBeanCount() {
        return this.mBeanServer.getMBeanCount();
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.mBeanServer.getMBeanInfo(name);
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.mBeanServer.getObjectInstance(name);
    }

    @Override
    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.mBeanServer.instantiate(className);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.mBeanServer.instantiate(className, loaderName);
    }

    @Override
    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        return this.mBeanServer.instantiate(className, params, signature);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.mBeanServer.instantiate(className, loaderName, params, signature);
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.mBeanServer.invoke(name, operationName, params, signature);
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return this.mBeanServer.isInstanceOf(name, className);
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        return this.mBeanServer.isRegistered(name);
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        return this.mBeanServer.queryMBeans(name, query);
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        return this.mBeanServer.queryNames(name, query);
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectInstance instance = this.mBeanServer.registerMBean(object, name);
        this.registeredMBeanObjectNames.add(name);
        return instance;
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mBeanServer.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mBeanServer.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mBeanServer.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mBeanServer.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.mBeanServer.setAttribute(name, attribute);
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        return this.mBeanServer.setAttributes(name, attributes);
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.mBeanServer.unregisterMBean(name);
        this.registeredMBeanObjectNames.remove(name);
    }
}

