/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.management;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.management.XqeRMIAuthenticator;
import com.cognos.xqe.management.XqeRmiRegistry;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class XqeRMIConnector {
    private static XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
    private XqeRmiRegistry xqeRmiRegistry;
    private MBeanServer server;
    private static int rmiPort = -1;
    private JMXConnectorServer cs = null;

    public XqeRMIConnector(MBeanServer svr) {
        this.server = svr;
        this.xqeRmiRegistry = new XqeRmiRegistry();
    }

    public static int getRmiPort() {
        return rmiPort;
    }

    public static void setRmiPort(int port) {
        rmiPort = port;
    }

    public static String getConnectionString() {
        StringBuilder connectionStringBuilder = new StringBuilder();
        if (config == null || config.isXQEMBeanServer()) {
            try {
                if (rmiPort == -1) {
                    rmiPort = XqeRmiRegistry.getRegistryPort();
                }
                if (config == null) {
                    config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
                }
                int port = 0;
                if (config != null) {
                    port = config.getIntProperty("network.jmxRemote[@port]", 0);
                }
                String colon = ":";
                connectionStringBuilder.append("service:jmx:rmi://");
                if (port > 0) {
                    connectionStringBuilder.append(InetAddress.getLocalHost().getHostName().toLowerCase());
                    connectionStringBuilder.append(":");
                    connectionStringBuilder.append(port);
                }
                connectionStringBuilder.append("/jndi/rmi://");
                connectionStringBuilder.append(InetAddress.getLocalHost().getHostName().toLowerCase());
                connectionStringBuilder.append(":");
                connectionStringBuilder.append(rmiPort);
                connectionStringBuilder.append("/server");
            }
            catch (UnknownHostException e) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
            }
        } else {
            connectionStringBuilder.append("DQ Servlet - connected to Liberty MBean Server");
        }
        return connectionStringBuilder.toString();
    }

    public void startConnector() throws IOException {
        HashMap<String, XqeRMIAuthenticator> environment = new HashMap<String, XqeRMIAuthenticator>();
        XqeRMIAuthenticator authenticator = new XqeRMIAuthenticator();
        environment.put("jmx.remote.authenticator", authenticator);
        this.xqeRmiRegistry.checkRMIRegistryAndStart();
        JMXServiceURL url = new JMXServiceURL(XqeRMIConnector.getConnectionString());
        this.cs = JMXConnectorServerFactory.newJMXConnectorServer(url, environment, this.server);
        this.cs.start();
    }

    public void stopConnector() {
        Exception exception = null;
        if (this.cs != null) {
            try {
                this.cs.stop();
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (this.xqeRmiRegistry != null) {
            try {
                this.xqeRmiRegistry.stopRMIRegistry();
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, exception);
        }
    }
}

