/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata;

import com.cognos.xqe.metadata.record.RecordType;

public enum PPDSCodeTypeEnum {
    CUBE(RecordType.CUBE, "1"),
    DIMENSION(RecordType.DIMENSION, "2"),
    MEASURE(RecordType.MEASURE, "3"),
    HIERARCHY(RecordType.HIERARCHY, "4"),
    LEVEL(RecordType.LEVEL, "5"),
    MEMBER(RecordType.MEMBER, "6"),
    PROPERTY(RecordType.PROPERTY, "7"),
    CATALOG(RecordType.CATALOG, "8");

    private static final String UNKNOWN_TYPE_PREFIX = "9";
    private final String ppdsPrefix;
    private final RecordType recordType;

    private PPDSCodeTypeEnum(RecordType recType, String thePPDSPrefix) {
        this.recordType = recType;
        this.ppdsPrefix = thePPDSPrefix;
    }

    public String getPPDSCodePrefix() {
        return this.ppdsPrefix;
    }

    public RecordType getRecordType() {
        return this.recordType;
    }

    public static String getPPDSCodePrefixFromType(RecordType type) {
        for (PPDSCodeTypeEnum e : PPDSCodeTypeEnum.values()) {
            if (e.getRecordType() != type) continue;
            return e.getPPDSCodePrefix();
        }
        return UNKNOWN_TYPE_PREFIX;
    }

    public static PPDSCodeTypeEnum valueOf(int ordinal) {
        for (PPDSCodeTypeEnum e : PPDSCodeTypeEnum.values()) {
            if (e.ordinal() != ordinal) continue;
            return e;
        }
        StringBuilder buffer = new StringBuilder("Invalid ordinal (");
        buffer.append(ordinal);
        buffer.append(")");
        throw new IllegalArgumentException(buffer.toString());
    }
}

