/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata;

import com.cognos.xqe.data.types.BusinessKeyType;
import com.cognos.xqe.data.types.DimensionUniqueNameType;
import com.cognos.xqe.data.types.HierarchyUniqueNameType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.LevelLabelType;
import com.cognos.xqe.data.types.LevelNumberType;
import com.cognos.xqe.data.types.LevelUniqueNameType;
import com.cognos.xqe.data.types.MemberCaptionType;
import com.cognos.xqe.data.types.MemberDescriptionType;
import com.cognos.xqe.data.types.MemberRollupType;
import com.cognos.xqe.data.types.MemberUniqueNameType;
import com.cognos.xqe.data.types.PPDSCodeType;
import com.cognos.xqe.data.types.ParentLevelNumberType;
import com.cognos.xqe.data.types.ParentUniqueNameType;
import com.cognos.xqe.data.types.QueryItemModelIDType;
import java.util.HashMap;
import java.util.Map;

public enum RoleTypeEnum {
    BUSINESS_KEY("businessKey", BusinessKeyType.DEFAULTBUSINESSKEYTYPE, "_businessKey", null),
    MULTI_PART_BUSINESS_KEY("MultiPartBusinessKey", null, "_multiPartBusinessKey", null),
    CURRENCY_CODE("currencyCode", null, "_currencyCode", null),
    DIMENSION_UNIQUE_NAME("dimensionUniqueName", DimensionUniqueNameType.DEFAULTDIMENSIONUNIQUENAMETYPE, "_dimensionUniqueName", "DIMENSION_UNIQUE_NAME"),
    HIERARCHY_UNIQUE_NAME("hierarchyUniqueName", HierarchyUniqueNameType.DEFAULTHIERARCHYUNIQUENAMETYPE, "_hierarchyUniqueName", "HIERARCHY_UNIQUE_NAME"),
    LEVEL_UNIQUE_NAME("levelUniqueName", LevelUniqueNameType.DEFAULTLEVELUNIQUENAMETYPE, "_levelUniqueName", "LEVEL_UNIQUE_NAME"),
    LEVEL_NUMBER("levelNumber", LevelNumberType.LEVELNUMBERTYPE, "_levelNumber", "LEVEL_NUMBER"),
    LEVEL_LABEL("levelLabel", LevelLabelType.DEFAULTLEVELLABELTYPE, "_levelLabel", null),
    MEMBER_UNIQUE_NAME("memberUniqueName", MemberUniqueNameType.DEFAULTMEMBERUNIQUENAMETYPE, "_memberUniqueName", "MEMBER_UNIQUE_NAME"),
    MEMBER_CAPTION("memberCaption", MemberCaptionType.DEFAULTMEMBERCAPTIONTYPE, "_memberCaption", "MEMBER_CAPTION"),
    MEMBER_DESCRIPTION("memberDescription", MemberDescriptionType.DEFAULTMEMBERDESCRIPTIONTYPE, "_memberDescription", "DESCRIPTION"),
    MEMBER_ROLLUP("rollupType", MemberRollupType.DEFAULTMEMBERROLLUPTYPE, "_rollupType", null),
    PARENT_UNIQUE_NAME("parentUniqueName", ParentUniqueNameType.DEFAULTPARENTUNIQUENAMETYPE, "_parentUniqueName", "PARENT_UNIQUE_NAME"),
    PARENT_LEVEL_NUMBER("parentLevelNumber", ParentLevelNumberType.DEFAULTPARENTLEVELNUMBERTYPE, "_parentLevelNumber", "PARENT_LEVEL"),
    PPDS_CODE(null, PPDSCodeType.PPDSCODETYPE, "_ppdsCode", "PPDS_CODE"),
    SHORT_NAME(null, null, "_shortName", null),
    LONG_NAME(null, null, "_longName", null),
    MEMBER_KEY(null, null, "", "MEMBER_KEY"),
    MEMBER_TYPE("memberType", null, null, "MEMBER_TYPE"),
    NUMBER_OF_PARENTS(null, null, null, "PARENT_COUNT"),
    CHILDREN_CARDINALITY(null, null, null, "CHILDREN_CARDINALITY"),
    MEMBER_CUSTOM_PROPERTY(null, null, null, null),
    PLANNING_DEFAULT(null, null, "_planningDefault", null),
    QUERY_ITEM_MODELID(null, QueryItemModelIDType.DEFAULTQUERYITEMMODELIDTYPE, "_queryItemModelID", null);

    private static final Map<String, RoleTypeEnum> RSAPI_ENUM_MAP;
    private static final Map<String, RoleTypeEnum> V5_ENUM_MAP;
    private static final Map<String, RoleTypeEnum> MDX_ENUM_MAP;
    private static final Map<String, RoleTypeEnum> DATATYPE_ENUM_MAP;
    private final String rsapiKeyword;
    private final IDataType dataType;
    private final String v5Keyword;
    private final String mdxKeyword;

    private RoleTypeEnum(String theRsapiKeyword, IDataType theDataType, String theV5Keyword, String theMdxKeyword) {
        this.rsapiKeyword = theRsapiKeyword;
        this.dataType = theDataType;
        this.v5Keyword = theV5Keyword;
        this.mdxKeyword = theMdxKeyword;
    }

    public String toRoleValue() {
        return this.toV5Keyword();
    }

    public String toMDDSType() {
        String v5 = this.toV5Keyword();
        if (v5 == null) {
            v5 = "";
        }
        return v5;
    }

    public String toV5Keyword() {
        return this.v5Keyword;
    }

    public IDataType getDataType() {
        return this.dataType;
    }

    public String toMDXKeyword() {
        return this.mdxKeyword;
    }

    public String toRsapiKeyword() {
        return this.rsapiKeyword;
    }

    public static RoleTypeEnum valueOf(int ordinal) {
        for (RoleTypeEnum e : RoleTypeEnum.values()) {
            if (e.ordinal() != ordinal) continue;
            return e;
        }
        StringBuilder buffer = new StringBuilder("Invalid ordinal (");
        buffer.append(ordinal);
        buffer.append(")");
        throw new IllegalArgumentException(buffer.toString());
    }

    public static RoleTypeEnum fromV5(String v5role) {
        RoleTypeEnum result = V5_ENUM_MAP.get(v5role);
        if (null == result) {
            result = MEMBER_CUSTOM_PROPERTY;
        }
        return result;
    }

    public static RoleTypeEnum fromRsapi(String rsapi) {
        return RSAPI_ENUM_MAP.get(rsapi);
    }

    public boolean isIntrinsic() {
        return RoleTypeEnum.isIntrinsic(this.v5Keyword);
    }

    public static boolean isIntrinsic(String v5role) {
        return V5_ENUM_MAP.get(v5role) != null;
    }

    public boolean isRSAPIDefault() {
        return RoleTypeEnum.isRSAPIDefault(this.mdxKeyword);
    }

    public static boolean isRSAPIDefault(String mdxProperty) {
        boolean isRSAPIDefault = PARENT_UNIQUE_NAME.toMDXKeyword().equals(mdxProperty) || CHILDREN_CARDINALITY.toMDXKeyword().equals(mdxProperty);
        return isRSAPIDefault;
    }

    public boolean isRSAPIKeyword() {
        return RoleTypeEnum.isRSAPIKeyword(this.mdxKeyword);
    }

    public static boolean isRSAPIKeyword(String keyword) {
        return RSAPI_ENUM_MAP.containsKey(keyword);
    }

    public static String v5ToMdx(String v5) {
        String result = null;
        RoleTypeEnum role = V5_ENUM_MAP.get(v5);
        if (role != null) {
            result = role.toMDXKeyword();
        }
        return result;
    }

    public static String mdxToRsapi(String mdx) {
        String result = null;
        RoleTypeEnum role = MDX_ENUM_MAP.get(mdx);
        if (role != null) {
            result = role.toRsapiKeyword();
        }
        if (result == null) {
            result = mdx;
        }
        return result;
    }

    public static String rsapiToMdx(String rsapi) {
        String result = null;
        RoleTypeEnum role = RSAPI_ENUM_MAP.get(rsapi);
        if (role != null) {
            result = role.toMDXKeyword();
        }
        return result;
    }

    public static String dataTypeToV5(IDataType dataType) {
        String result = null;
        RoleTypeEnum role = DATATYPE_ENUM_MAP.get(dataType.getTypeName());
        if (role != null) {
            result = role.toV5Keyword();
        }
        return result;
    }

    static {
        RSAPI_ENUM_MAP = new HashMap<String, RoleTypeEnum>(RoleTypeEnum.values().length);
        V5_ENUM_MAP = new HashMap<String, RoleTypeEnum>(RoleTypeEnum.values().length);
        MDX_ENUM_MAP = new HashMap<String, RoleTypeEnum>(RoleTypeEnum.values().length);
        DATATYPE_ENUM_MAP = new HashMap<String, RoleTypeEnum>(RoleTypeEnum.values().length);
        for (RoleTypeEnum e : RoleTypeEnum.values()) {
            if (e.toRsapiKeyword() != null) {
                RSAPI_ENUM_MAP.put(e.toRsapiKeyword(), e);
            }
            if (e.toV5Keyword() != null) {
                V5_ENUM_MAP.put(e.toV5Keyword(), e);
            }
            if (e.toMDXKeyword() != null) {
                MDX_ENUM_MAP.put(e.toMDXKeyword(), e);
            }
            if (e.getDataType() == null) continue;
            DATATYPE_ENUM_MAP.put(e.getDataType().getTypeName(), e);
        }
    }
}

