/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.mdquery;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MetadataOperation;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.mdquery.MDMetadataQuery;
import com.cognos.xqe.metadata.mdquery.MDMetadataResponse;
import com.cognos.xqe.metadata.mdquery.parser.MDQueryParser;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.StringField;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.pool.XQEXMLInputFactoryPool;
import com.cognos.xqe.util.pool.XQEXMLOutputFactoryPool;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class MDQueryAdapter {
    private static final String XML_ENCODING_UTF8 = "UTF-8";
    private static final String LOG_EVENT_GROUP = "Metadata.MDQueryAdapter";
    private IOLAPMetadataProvider metaProvider = null;
    private static XQELogger logger;

    public MDQueryAdapter() {
        MDQueryAdapter.getLogger();
    }

    private void initialize(MetadataQueryArguments arg) {
        if (logger.isOn(LogLevel.TRACE)) {
            logger.log(LogLevel.TRACE, "Initialize XQEODP metadata connection with connection string \"" + arg.getDataSource().getDataSourceConnection().getConnectionString(null) + "\".");
        }
        IOLAPDataProvider dataProvider = ProviderManager.getInstance().getOLAPProvider(arg.getDataSource().getType());
        this.metaProvider = dataProvider.getMetadataProvider(arg);
    }

    private void release() {
        block3: {
            try {
                if (null != this.metaProvider) {
                    this.metaProvider.release();
                }
            }
            catch (Exception ex) {
                if (!logger.isOn(LogLevel.ERROR)) break block3;
                logger.log(LogLevel.ERROR, "Error caught releasing metadata provider: " + ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String execute(RequestEnvironment aReqEnv, String mdQuerySpec) {
        if (logger.isOn(LogLevel.TRACE)) {
            logger.log(LogLevel.TRACE, "Received new MDQuerySpec.");
            logger.log(LogLevel.TRACE, mdQuerySpec);
        }
        XMLStreamReader reader = MDQueryAdapter.createReader(mdQuerySpec);
        MDMetadataQuery query = this.getQuery(aReqEnv, reader);
        if (logger.isOn(LogLevel.INFO)) {
            logger.log(LogLevel.INFO, "Executing XQEODP metadata request: " + (Object)((Object)query.getMetadataOperation()));
        }
        if (logger.isOn(LogLevel.TRACE) && query != null) {
            StringWriter writer = new StringWriter();
            query.writeXML(writer);
            logger.log(LogLevel.TRACE, writer.getBuffer().toString());
        }
        this.initialize(query.getQueryArguments());
        ByteArrayOutputStream responseStream = new ByteArrayOutputStream();
        if (query.getMetadataOperation().equals((Object)MetadataOperation.DATASOURCELOCALES)) {
            List<String> locales = null;
            try {
                locales = this.metaProvider.getDatasourceLocales(query.getRestrictions());
            }
            finally {
                this.release();
            }
            MDQueryAdapter.writeLocaleResponse(query, locales, responseStream);
        } else {
            List<MetadataRecord> records = null;
            try {
                records = MetadataOperation.invoke(query.getMetadataOperation(), this.metaProvider, query.getRestrictions());
            }
            finally {
                this.release();
            }
            this.generateSecondaryQueries(query, records);
            MDQueryAdapter.writeRecordResponse(query, records, responseStream);
        }
        try {
            String responseString = responseStream.toString(XML_ENCODING_UTF8);
            if (logger.isOn(LogLevel.INFO)) {
                logger.log(LogLevel.INFO, "Finished processing response from XQEODP provider.");
            }
            if (logger.isOn(LogLevel.TRACE)) {
                logger.log(LogLevel.TRACE, responseString);
            }
            return responseString;
        }
        catch (UnsupportedEncodingException uee) {
            if (logger.isOn(LogLevel.ERROR)) {
                logger.log(LogLevel.ERROR, "Failed to encode response.");
                logger.log(LogLevel.ERROR, (Throwable)uee);
            }
            throw XQERuntimeException.wrap(uee);
        }
    }

    private void generateSecondaryQueries(MDMetadataQuery query, List<MetadataRecord> records) {
        if (query.getMetadataOperation().equals((Object)MetadataOperation.CUBES) && query.getProperties().contains("Default_Measure")) {
            MetadataRestriction restrictions = new MetadataRestriction();
            if (query.getRestrictions().contains(RestrictionType.CATALOG)) {
                restrictions.add(RestrictionType.CATALOG, query.getRestrictions().getValueOf(RestrictionType.CATALOG));
            }
            for (MetadataRecord c : records) {
                restrictions.add(RestrictionType.CUBE, c.getName());
                String cubeDefaultMeasure = this.metaProvider.getCubeDefaultMeasure(restrictions);
                c.addDynamicField(new StringField("DefaultMeasure", cubeDefaultMeasure));
            }
        }
    }

    public MDMetadataQuery getQuery(RequestEnvironment aReqEnv, String mdQuerySpec) {
        XMLStreamReader reader = MDQueryAdapter.createReader(mdQuerySpec);
        return this.getQuery(aReqEnv, reader);
    }

    private MDMetadataQuery getQuery(RequestEnvironment aReqEnv, XMLStreamReader reader) {
        logger.log(LogLevel.INFO, "Start Parsing MDQuerySpec.");
        MDMetadataQuery query = null;
        try {
            MDQueryParser parser = new MDQueryParser(aReqEnv);
            query = parser.parse(reader);
        }
        catch (XMLStreamException e) {
            logger.log(LogLevel.ERROR, (Throwable)e);
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.log(LogLevel.ERROR, (Throwable)e);
            throw e;
        }
        logger.log(LogLevel.INFO, "Finish Parsing MDQuerySpec.");
        return query;
    }

    public static XQELogger getLogger() {
        if (logger == null) {
            logger = XQELog.getLogger(ServiceEnumeration.XQEODP, "XQEODP", LOG_EVENT_GROUP, LogLevel.ERROR);
        }
        return logger;
    }

    private static XMLStreamReader createReader(String mdQuerySpec) {
        RuntimeException exception;
        XMLStreamReader xmlReader;
        block8: {
            xmlReader = null;
            XMLInputFactory factory = null;
            exception = null;
            try {
                factory = XQEXMLInputFactoryPool.getInstance().borrowXMLInputFactory();
                BufferedInputStream stream = new BufferedInputStream(new ByteArrayInputStream(mdQuerySpec.getBytes(XML_ENCODING_UTF8)));
                xmlReader = factory.createXMLStreamReader(stream);
            }
            catch (Exception e) {
                if (logger.isOn(LogLevel.ERROR)) {
                    logger.log(LogLevel.ERROR, "Failed to create XMLStreamReader.");
                }
                exception = XQERuntimeException.wrap(e);
            }
            if (factory != null) {
                try {
                    XQEXMLInputFactoryPool.getInstance().returnXMLInputFactory(factory);
                }
                catch (Exception e) {
                    if (logger.isOn(LogLevel.WARN)) {
                        logger.log(LogLevel.WARN, "Error returning XMLInputFactory to pool: " + e);
                    }
                    if (exception != null) break block8;
                    exception = XQERuntimeException.wrap(e);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        return xmlReader;
    }

    private static XMLStreamWriter createWriter(ByteArrayOutputStream buffer) {
        RuntimeException exception;
        XMLStreamWriter writer;
        block8: {
            BufferedOutputStream stream = new BufferedOutputStream(buffer);
            writer = null;
            XMLOutputFactory factory = null;
            exception = null;
            try {
                factory = XQEXMLOutputFactoryPool.getInstance().borrowXMLOutputFactory();
                writer = factory.createXMLStreamWriter(stream);
            }
            catch (Exception e) {
                if (logger.isOn(LogLevel.ERROR)) {
                    logger.log(LogLevel.ERROR, "Failed to create XMLStreamWriter.");
                }
                exception = XQERuntimeException.wrap(e);
            }
            if (factory != null) {
                try {
                    XQEXMLOutputFactoryPool.getInstance().returnXMLOutputFactory(factory);
                }
                catch (Exception e) {
                    if (logger.isOn(LogLevel.WARN)) {
                        logger.log(LogLevel.WARN, "Error returning XMLOutputFactory to pool: " + e);
                    }
                    if (exception != null) break block8;
                    exception = XQERuntimeException.wrap(e);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        return writer;
    }

    private static void writeRecordResponse(MDMetadataQuery query, List<? extends MetadataRecord> records, ByteArrayOutputStream buffer) {
        MDMetadataResponse response = MDMetadataResponse.constructRecordResponse(query, records);
        XMLStreamWriter writer = MDQueryAdapter.createWriter(buffer);
        try {
            response.writeXML(writer);
        }
        catch (XMLStreamException e) {
            if (logger.isOn(LogLevel.ERROR)) {
                logger.log(LogLevel.ERROR, "Failed to write metadata record response: " + e);
            }
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
        }
    }

    private static void writeLocaleResponse(MDMetadataQuery query, List<String> locales, ByteArrayOutputStream buffer) {
        MDMetadataResponse response = MDMetadataResponse.constructLocaleResponse(query, locales);
        XMLStreamWriter writer = MDQueryAdapter.createWriter(buffer);
        try {
            response.writeXML(writer);
        }
        catch (XMLStreamException e) {
            if (logger.isOn(LogLevel.ERROR)) {
                logger.log(LogLevel.ERROR, "Failed to write data source locale response: " + e);
            }
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
        }
    }
}

