/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.mdquery.parser;

import java.util.HashMap;
import java.util.Map;

public final class ConnectionPropertyMapper {
    private static final Map<String, String> GENERIC_MAPPING = new HashMap<String, String>();
    private static final Map<String, String> SAP_MAPPING = new HashMap<String, String>();
    private static final Map<String, String> PC_MAPPING = new HashMap<String, String>();
    private static final Map<String, String> ODBO_MAPPING = new HashMap<String, String>();

    public static String toConnStr(String providerType, String mdQueryProp) {
        String result = null;
        if ("BW".equals(providerType)) {
            result = SAP_MAPPING.get(mdQueryProp);
        } else if ("PC".equals(providerType)) {
            result = PC_MAPPING.get(mdQueryProp);
        } else if ("YK".equals(providerType) || "M8".equals(providerType) || "M12".equals(providerType) || "M14".equals(providerType) || "M16".equals(providerType) || "M17".equals(providerType) || "M19".equals(providerType) || "X5".equals(providerType) || "MAZ".equals(providerType) || "X8".equals(providerType)) {
            result = ODBO_MAPPING.get(mdQueryProp);
        }
        if (null == result) {
            result = GENERIC_MAPPING.get(mdQueryProp);
        }
        if (null == result) {
            result = mdQueryProp;
        }
        return result;
    }

    public static Map<String, String> toConnStr(String providerType, Map<String, String> mdQueryProps) {
        HashMap<String, String> result = new HashMap<String, String>(mdQueryProps.size());
        for (Map.Entry<String, String> prop : mdQueryProps.entrySet()) {
            String convertedName = ConnectionPropertyMapper.toConnStr(providerType, prop.getKey());
            result.put(convertedName, prop.getValue());
        }
        return result;
    }

    private ConnectionPropertyMapper() {
    }

    static {
        GENERIC_MAPPING.put("providerType", "PROVIDER_TYPE");
        GENERIC_MAPPING.put("server", "SERVER");
        GENERIC_MAPPING.put("catalog", "CATALOG");
        GENERIC_MAPPING.put("cube", "CUBE");
        GENERIC_MAPPING.put("username", "UID");
        GENERIC_MAPPING.put("password", "PWD");
        SAP_MAPPING.put("SAPServerType", "serverType");
        SAP_MAPPING.put("SAPLogonGroup", "logonGroup");
        SAP_MAPPING.put("SAPSystemID", "sysid");
        SAP_MAPPING.put("SAPSystemNumber", "sysnr");
        SAP_MAPPING.put("SAPClientNumber", "client");
        SAP_MAPPING.put("SAPCodePage", "codePage");
        PC_MAPPING.put("winDataSource", "WIN_PATH");
        PC_MAPPING.put("unixDataSource", "UNIX_PATH");
        ODBO_MAPPING.put("runLocale", "LCID");
        ODBO_MAPPING.put("trustedConnection", "Trusted_Connection");
    }
}

