/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.mdquery.parser;

import com.cognos.xqe.data.providers.olap.MetadataOperation;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.metadata.mdquery.MDMetadataQuery;
import com.cognos.xqe.metadata.mdquery.parser.ConstraintsHandler;
import com.cognos.xqe.metadata.mdquery.parser.PropertiesHandler;
import com.cognos.xqe.util.xml.stax.DelegatingComponentHandler;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class MetadataHandler
extends DelegatingComponentHandler {
    private static final String NAMESPACE = "";
    private static final String XML_ATTR_CLASS = "class";
    private static final String XML_ATTR_RETURN_SCHEMA = "returnSchema";
    private static final String XML_ATTR_RESULT_START = "resultStart";
    private static final String XML_ATTR_RESULT_COUNT = "resultCount";
    private static final String XML_ATTR_DEPTH = "depth";
    private static final String EMPTY_STRING = "";
    private static final QName CONSTRAINTS = new QName("", "constraints");
    private static final QName PROPERTIES = new QName("", "properties");
    private static final Map<String, MetadataOperation> MD_OP_MAP = new HashMap<String, MetadataOperation>();
    private final ConstraintsHandler constraintsHandler = new ConstraintsHandler();
    private final PropertiesHandler propertiesHandler = new PropertiesHandler();
    private MDMetadataQuery query = null;

    public MetadataHandler() {
        this.registerDelegate(CONSTRAINTS, this.constraintsHandler);
        this.registerDelegate(PROPERTIES, this.propertiesHandler);
    }

    @Override
    public void consume(XMLStreamReader reader) throws XMLStreamException {
        Integer size;
        this.reset();
        this.query = new MDMetadataQuery();
        this.processCurrent(reader);
        this.consumeChildren(reader);
        MetadataRestriction restrictions = this.constraintsHandler.getRestrictions();
        Integer from = this.query.getResultStart();
        if (from != null) {
            restrictions.add(RestrictionType.FROM, from);
        }
        if ((size = this.query.getResultCount()) != null) {
            restrictions.add(RestrictionType.SIZE, size);
        }
        this.query.setRestriction(restrictions);
        this.query.setProperties(this.propertiesHandler.getProperties());
    }

    protected void processCurrent(XMLStreamReader reader) throws XMLStreamException {
        MetadataOperation mdOp = MetadataHandler.getMetadataOperation(reader.getAttributeValue("", XML_ATTR_CLASS));
        this.query.setMetadataOperation(mdOp);
        String value = "";
        value = reader.getAttributeValue("", XML_ATTR_RETURN_SCHEMA);
        if (value != null && !value.equals("")) {
            this.query.setReturnSchema(Boolean.valueOf(value));
        }
        if ((value = reader.getAttributeValue("", XML_ATTR_RESULT_START)) != null && !value.equals("")) {
            this.query.setResultStart(Integer.valueOf(value));
        }
        if ((value = reader.getAttributeValue("", XML_ATTR_RESULT_COUNT)) != null && !value.equals("")) {
            this.query.setResultCount(Integer.valueOf(value));
        }
        if ((value = reader.getAttributeValue("", XML_ATTR_DEPTH)) != null && !value.equals("")) {
            this.query.setDepth(Integer.valueOf(value));
        }
    }

    private static MetadataOperation getMetadataOperation(String mddsMetadataClass) {
        return MD_OP_MAP.get(mddsMetadataClass);
    }

    protected void consumeChildren(XMLStreamReader reader) throws XMLStreamException {
        super.consume(reader);
    }

    public MDMetadataQuery getMetadataQuery() {
        return this.query;
    }

    void reset() {
        this.query = null;
    }

    static {
        MD_OP_MAP.put("AliasTable", MetadataOperation.ALIASES);
        MD_OP_MAP.put("Attributes", MetadataOperation.PROPERTIES);
        MD_OP_MAP.put("Cube", MetadataOperation.CUBES);
        MD_OP_MAP.put("Macro", MetadataOperation.MACROS);
        MD_OP_MAP.put("Named_Sets", MetadataOperation.NAMEDSETS);
        MD_OP_MAP.put("Hierarchy_Named_Sets", MetadataOperation.HIERARCHYNAMEDSETS);
        MD_OP_MAP.put("Catalog", MetadataOperation.CATALOGS);
        MD_OP_MAP.put("Dimensions", MetadataOperation.DIMENSIONS);
        MD_OP_MAP.put("Hierarchies", MetadataOperation.HIERARCHIES);
        MD_OP_MAP.put("Levels", MetadataOperation.LEVELS);
        MD_OP_MAP.put("Members", MetadataOperation.MEMBERS);
        MD_OP_MAP.put("Measures", MetadataOperation.MEASURES);
        MD_OP_MAP.put("Actions", MetadataOperation.ACTIONS);
        MD_OP_MAP.put("Variables", MetadataOperation.VARIABLES);
        MD_OP_MAP.put("Locales", MetadataOperation.DATASOURCELOCALES);
    }
}

