/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.mdquery.parser;

import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.IStaxComponentHandler;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class PropertiesHandler
implements IStaxComponentHandler {
    private static final String SYM_PROPERTY_START = "@";
    private static final String XML_NAMESPACE = "";
    private static final String XML_ATTRIBUTE_NAME = "name";
    private static final String XML_ELEMENT_PROPERTY = "property";
    private List<String> properties = null;

    public PropertiesHandler() {
        this.reset();
    }

    @Override
    public void consume(XMLStreamReader reader) throws XMLStreamException {
        this.reset();
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            String name = reader.getLocalName();
            if (name.equals(XML_ELEMENT_PROPERTY)) {
                String value = reader.getAttributeValue(XML_NAMESPACE, XML_ATTRIBUTE_NAME);
                this.properties.add(PropertiesHandler.getPropertyName(value));
            }
            StaxUtil.skipElement(reader);
        }
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public void reset() {
        this.properties = new LinkedList<String>();
    }

    private static String getPropertyName(String value) {
        int startIdx = value.indexOf(SYM_PROPERTY_START) + 1;
        return value.substring(startIdx);
    }
}

