/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.provider;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.provider.Metadata;

public class AbstractRelationship
extends Metadata {
    static final long serialVersionUID = 7647274105530911872L;
    protected static final String LEFT_REF_OBJ = "leftrefobj";
    protected static final String RIGHT_REF_OBJ = "rightrefobj";
    protected static final String LEFT_MIN_CARD = "leftmincard";
    protected static final String LEFT_MAX_CARD = "leftmaxcard";
    protected static final String RIGHT_MIN_CARD = "rightmincard";
    protected static final String RIGHT_MAX_CARD = "rightmaxcard";

    public IMetadata getLeftRefObject() {
        String left = (String)this.getProperty(LEFT_REF_OBJ);
        return this.getConnection().bindMetadataReference(left);
    }

    public IMetadata getRightRefObject() {
        String right = (String)this.getProperty(RIGHT_REF_OBJ);
        return this.getConnection().bindMetadataReference(right);
    }

    public String getLeftRefObjectId() {
        return (String)this.getProperty(LEFT_REF_OBJ);
    }

    public String getRightRefObjectId() {
        return (String)this.getProperty(RIGHT_REF_OBJ);
    }

    public Enum<IRelationship.Cardinality> getLeftCardinality() {
        String leftMin = (String)this.getProperty(LEFT_MIN_CARD);
        String leftMax = (String)this.getProperty(LEFT_MAX_CARD);
        return this.getCardinality(leftMin, leftMax);
    }

    public Enum<IRelationship.Cardinality> getRightCardinality() {
        String rightMin = (String)this.getProperty(RIGHT_MIN_CARD);
        String rightMax = (String)this.getProperty(RIGHT_MAX_CARD);
        return this.getCardinality(rightMin, rightMax);
    }

    private Enum<IRelationship.Cardinality> getCardinality(String min, String max) {
        if (min.equals("zero")) {
            if (max.equals("one")) {
                return IRelationship.Cardinality.ZERO_ONE;
            }
            if (max.equals("many")) {
                return IRelationship.Cardinality.ZERO_MANY;
            }
        }
        if (min.equals("one")) {
            if (max.equals("one")) {
                return IRelationship.Cardinality.ONE_ONE;
            }
            if (max.equals("many")) {
                return IRelationship.Cardinality.ONE_MANY;
            }
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "getCardinality():  Unexpected cardinality.");
    }
}

